; DataAgent
; Retrieves file size, basic disk analysis and memory specifications
; By Alchem^st - DLL courtesy DragonZap
on *:load: { 
  if ($version < 5.6) { echo $colour(info) -a 212 You must be using mIRC 5.6 or higher to run this addon. | echo $colour(info2) -a Unloading script... | unload -rs $script } | elseif ($findfile($mircdir,fsmem.dll,1) != $scriptdirfsmem.dll) {
    echo $colour(info) -a You must place Fsmem.dll in $cap($scriptdir) for DataAgent to function.
  }
  else {
    echo $colour(info) -a 212 Welcome to DataAgent, a file/memory utility for mIRC. | echo $colour(info2) -a COMMANDS: | echo $colour(info2) -a 14/datacon    - opens the main console | echo $colour(info2) -a 14/file.size  - retrieves file size | echo $colour(info2) -a 14/drive.scan - performs disk analysis | echo $colour(info2) -a 14/mem.stats  - returns memory stats | echo $colour(info2) -a 14/attrib     - opens the attributions dialog | echo $colour(info) -a 212 Access DataAgent via menubar popups
  }
}
on *:start:{ set %dll.loc $scriptdirfsmem.dll }
alias -l cap { return $upper($left($1,1)) $+ $lower($right($1,$calc($len($1) - 1))) }
menu menubar {
  DataAgent
  .Console:datacon
  .-
  .Unload:nload
}
alias bytes2 { 
  if ($1 == $null) return N/A  
  if ($1 < 1024) return $1 B
  if ($1 < $calc(1024^2)) return $round($calc($1 / 1024),2) KB
  if ($1 < $calc(1024^3)) return $round($calc($1 / 1024^2),2) MB
  if ($1 < $calc(1024^4)) return $round($calc($1 / 1024^3),2) GB
}
alias datacon { dialog -m datacon datacon }
dialog datacon {
  title "DataAgent Console"
  size 334 68 299 56
  button "&File Size" 1, 7 20 69 31
  button "&Drive Specs" 2, 80 20 69 31
  button "&Mem Stats" 3, 152 20 69 31
  button "&Attributions" 4, 224 20 69 31
  button "" 5, 0 0 0 0, ok
  box "Retrieve" 6, 1 1 298 55
}
on *:dialog:datacon:sclick:1:{ timer 1 0 file.size }
alias file.size { if (%fle == $null) set %fle $mircdir | file.select }  
alias -l file.select { { 
    %fle = $dir="Exploring - ( $+ $cap($nofile(%fle)) $+ )" $nofile(%fle)
  }    
  if (%fle == $null) halt  
  window -ka @Results 0 0 334 81 Terminal 14
  aline @Results 12---------
  aline @Results FILE SIZE
  aline @Results 2---------
  aline -p @Results  $+ $colour(info) $+ $nopath(%fle) $+ : $+  $bytes2($file(%fle))
}
on *:dialog:datacon:sclick:2:{ drive.scan }
on *:dialog:datacon:sclick:3:{ mem.stats }
alias mem.stats { if (%dll.loc == $null) {
    set %dll.loc $scriptdir $+ fsmem.dll
  }
  window -ka @Results 0 0 334 133 Terminal 14
  aline @Results 12------------
  aline @Results MEMORY STATS
  aline @Results 2------------
  aline @Results  $+ $colour(info) $+ Current Load: $+  $dll(%dll.loc,GetMemInfo,memoryload) $+ % | aline @Results  $+ $colour(info) $+ Total Physical: $+  $bytes2($dll(%dll.loc,GetMemInfo, totalphys )) | aline @Results  $+ $colour(info) $+ Free Physical: $bytes2($dll(%dll.loc,GetMemInfo, freephys )) | aline @Results  $+ $colour(info) $+ Total Virtual: $bytes2($dll(%dll.loc,GetMemInfo, totalvirtual )) | aline @Results  $+ $colour(info) $+ Free Virtual: $bytes2($dll(%dll.loc,GetMemInfo, freevirtual ))
}
alias -l diskinfo {
  if ($len(%d.letr) == 1) set %d.letr %d.letr $+ :
  if ($right(%d.letr,1) != \) set %d.letr %d.letr $+ \
}
alias drive.scan { if (%dll.loc == $null) { 
    set %dll.loc $scriptdir $+ fsmem.dll
  }
  dialog -m drive.sel drive.sel 
}
dialog drive.sel {
  title "Select Drive Letter to Scan"
  size 334 149 204 71
  button "&Scan", 1, 5 37 194 32, ok
  radio "A", 2, 15 10 50 17
  radio "C", 3, 65 10 50 17
  radio "D", 4, 115 10 50 17
  edit "", 6, 165 7 21 21, autohs
}
on *:dialog:drive.sel:init:*:{
  %d.letr = C  
  did -c $dname 3
}
on *:dialog:drive.sel:sclick:2:%d.letr = A
on *:dialog:drive.sel:sclick:3:%d.letr = C
on *:dialog:drive.sel:sclick:4:%d.letr = D
on *:dialog:drive.sel:edit:6: { did -u drive.sel 3 | %d.letr = $did(drive.sel,6).text }
on *:dialog:drive.sel:sclick:1:{ 
  diskinfo
  if ($disk(%d.letr).label == $null) { var %disk.label None } 
  else { var %disk.label $cap($disk(%d.letr).label) } 
  if ($disk(%d.letr).label == $null) { var %disk.label None } 
  else { var %disk.label $cap($disk(%d.letr).label) }   
  if ($disk(%d.letr).type == $null) { var %disk.type N/A }  
  elseif ($disk(%d.letr).type == cdrom) { var %disk.type CD-ROM } 
  else { var %disk.type $cap($disk(%d.letr).type) }
  if (%disk.type == Fixed) {  
    window -ka @Results 0 0 334 146 Terminal 14
    aline @Results 12-------
    aline @Results DRIVE $cap($remove(%d.letr,:\))
    aline @Results 2-------
    aline @Results  $+ $colour(info) $+ Total Space: $bytes2($dll(%dll.loc,GetSpaceInfo, total [ %d.letr ] )) | aline @Results  $+ $colour(info) $+ Free Space: $bytes2($dll(%dll.loc,GetSpaceInfo, free [ %d.letr ] )) | aline @Results  $+ $colour(info) $+ Type: %disk.type | aline @Results  $+ $colour(info) $+ Label: %disk.label 
  aline @Results  $+ $colour(info) $+ File System Type: $dll(%dll.loc,GetVolumeInfo,fstype C:\) | aline @Results  $+ $colour(info) $+ Serial Number: $dll(%dll.loc,GetVolumeInfo, serial [ %d.letr ] ) }
  else { 
    window -ka @Results 0 0 334 120 Terminal 14
    aline @Results 12-------
    aline @Results DRIVE $cap($remove(%d.letr,:\))
    aline @Results 2-------
  aline @Results  $+ $colour(info) $+ Total Space: $bytes2($dll(%dll.loc,GetSpaceInfo, total [ %d.letr ] )) | aline @Results  $+ $colour(info) $+ Free Space: $bytes2($dll(%dll.loc,GetSpaceInfo, free [ %d.letr ] )) | aline @Results  $+ $colour(info) $+ Type: %disk.type | aline @Results  $+ $colour(info) $+ Label: %disk.label }
}
on *:dialog:datacon:sclick:4:{ dialog -m attrib attrib }
alias attrib { dialog -m attrib attrib }
dialog attrib {
  size 334 149 208 153
  edit "", 1, 5 5 194 22, autohs  
  text "Path and File/Dir" 2, 59 35 120 22  
  button "&View" 3, 107 115 95 32
  button "&Apply" 4, 5 115 95 32
  title "Modify/View Attributions"
  check "r", 5, 10 70 25 17
  check  "h", 6, 10 90 25 17
  check "s", 7, 50 70 25 17
  check "a", 8, 50 90 25 17
  box "" 9, 1 50 103 103
  box "" 10, 103 50 103 103
  button "" 11, 0 0 0 0, ok
}
on *:dialog:attrib:edit:1:{ %att.list = $did(attrib,1).text | %file.att = $did(attrib,1).text }
on *:dialog:attrib:sclick:3:{ if (%att.list == $null) { set %att.list $mircdir } | attriblist %att.list }
on *:dialog:attrib:sclick:4:{
  set %file.attr $iif($did(5).state == 1,r) $+ $iif($did(6).state == 1,h) $+ $iif($did(7).state == 1,s) $+ $iif($did(8).state == 1,a)
  if (%file.attr != $null) && (%file.att != $null) { dll %dll.loc SetFileAttr %file.attr %file.att } 
  else { set %file.attr n | dll %dll.loc SetFileAttr %file.attr %file.att }
}
alias -l attriblist {
  window -c @Attributes
  if ($isdir($$1-) == $false) return
  window -lk -t8 @Attributes 0 0 334 500 Terminal 14
  titlebar @Attributes - ( $+ $cap($1-) $+ )
   $finddir($1-,*.*,0,1,showattrib $1-)
   $findfile($1-,*.*,0,1,showattrib $1-)
}
alias -l showattrib aline @Attributes $dll(%dll.loc,GetFileAttr,$1-) $+ $chr(9) $+ $cap($nopath($1-))
alias -l  return $1-
alias -l nload { 
  if ($?!="Unload DataAgent?") { 
    unset %d.letr | unset %fle | unset %dll.loc | unset %ount | unset %att.list | unset %file.att
    unload -rs $script       
  } 
}
