unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Spin, ComCtrls, Winsock, Buttons, IniFiles;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label2: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Button1: TButton;
    StatusBar1: TStatusBar;
    Label12: TLabel;
    SpinEdit1: TSpinEdit;
    Label13: TLabel;
    SpinEdit2: TSpinEdit;
    Label14: TLabel;
    ListBox1: TListBox;
    SpeedButton1: TSpeedButton;
    Timer1: TTimer;
    function GetIP:String;
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
   { Private declarations }
  public
    { Public declarations }
    Total,Scanned:LongInt;
    PortNumber:Integer;
    Dur:Boolean;
    R3:Integer;
    R3Before:Integer;
  end;

type
  Thread=Class(TThread)

  protected
    constructor Create;

  public
    procedure Execute; override;

end;

var
  Form1: TForm1;
  TNumber:Integer;

implementation

{$R *.DFM}

constructor Thread.Create;
begin
  inherited Create(False);
FreeOnTerminate:=True;
end;

procedure Thread.Execute;
var
RawSocket:TSocket;
HedefAdres:TSockAddrIn;
WSAData:TWSAData;
Port:Integer;
IP:String;
begin
{open tcp socket}
WSAStartup($101, WSAData);
RawSocket:=Socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
if RawSocket=Invalid_Socket then begin
ShowMessage('Could not open tcp socket');
exit;
end;
{set variables}
Port:=Form1.PortNumber;
{target address options}
HedefAdres.sin_family:=AF_INET;
HedefAdres.sin_port:=htons(Port);
repeat
IP:=Form1.GetIP;
HedefAdres.sin_addr.S_addr:=inet_addr(PChar(IP));
if Connect(RawSocket, HedefAdres, Sizeof(HedefAdres))>-1 then Form1.ListBox1.Items.Add(IP);
CloseSocket(RawSocket);
RawSocket:=Socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
until
Form1.Dur=True;
CloseSocket(RawSocket);
end;

function TForm1.GetIP:String;
var
R1,R2,R4,R5,R6,R7,R8:Integer;
IP:String;
begin
R1:=StrtoInt(Edit1.Text);
R2:=StrtoInt(Edit2.Text);
R3:=StrtoInt(Edit3.Text);
R4:=StrtoInt(Edit4.Text);
R5:=StrtoInt(Edit5.Text);
R6:=StrtoInt(Edit6.Text);
R7:=StrtoInt(Edit7.Text);
R8:=StrtoInt(Edit8.Text);
if (R1>255) or (R2>255) or (R3>255) or (R4>255) or (Button1.Caption='SCAN') then begin
Dur:=True;
Button1.Caption:='SCAN';
exit;
end;
if (R1=R5) and (R2=R6) and (R3=R7) and (R4=R8) and (R3<R7) and (R4<R8) then begin
Dur:=True;
Button1.Caption:='SCAN';
exit;
end;
Inc(R4);
if R4>255 then begin
R4:=0;
R3:=R3Before+1;
end;
Edit1.Text:=InttoStr(R1);
Edit2.Text:=InttoStr(R2);
Edit3.Text:=InttoStr(R3);
Edit4.Text:=InttoStr(R4);
IP:=InttoStr(R1)+'.'+InttoStr(R2)+'.'+InttoStr(R3)+'.'+InttoStr(R4);
Inc(Scanned);
StatusBar1.Panels[0].Text:='Scanned: '+InttoStr(Scanned)+'  Progress: %'+Inttostr((Scanned*100) div Total);
Result:=IP;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
Edit5.Text:=Edit1.Text;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
Edit6.Text:=Edit2.Text;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
if key=#8 then exit;
try
StrtoInt(Key);
except
key:=#0;
end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
i:Integer;
begin
if Button1.Caption='SCAN' then begin
Button1.Caption:='STOP';
Total:=0;
Scanned:=0;
PortNumber:=SpinEdit2.Value;
Dur:=False;
Total:=((StrToInt(Edit7.Text))-(StrtoInt(Edit3.Text)))*255+((StrtoInt(Edit8.Text))-(StrtoInt(Edit4.text)));
for i:=1 to SpinEdit1.Value do Thread.Create;
end
else Button1.Caption:='SCAN';
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
ListBox1.Clear;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
ini:TIniFile;
begin
Edit5.Text:=Edit1.Text;
Edit6.Text:=Edit2.Text;
ini:=TIniFile.Create('IPScan.ini');
Edit1.Text:=ini.ReadString('IPScan', 'R1', Edit1.Text);
Edit2.Text:=ini.ReadString('IPScan', 'R2', Edit2.Text);
Edit3.Text:=ini.ReadString('IPScan', 'R3', Edit3.Text);
Edit4.Text:=ini.ReadString('IPScan', 'R4', Edit4.Text);
Edit5.Text:=ini.ReadString('IPScan', 'R5', Edit5.Text);
Edit6.Text:=ini.ReadString('IPScan', 'R6', Edit6.Text);
Edit7.Text:=ini.ReadString('IPScan', 'R7', Edit7.Text);
Edit8.Text:=ini.ReadString('IPScan', 'R8', Edit8.Text);
SpinEdit1.Value:=ini.ReadInteger('IPScan', 'Thread', SpinEdit1.Value);
SpinEdit2.Value:=ini.ReadInteger('IPScan', 'Port', SpinEdit2.Value);
ini.Free;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
{i must do this in timer to prevent threads to inc R3 at the same time}
R3Before:=R3;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
ini:TIniFile;
begin
ini:=TIniFile.Create('IPScan.ini');
ini.WriteString('IPScan', 'R1', Edit1.Text);
ini.WriteString('IPScan', 'R2', Edit2.Text);
ini.WriteString('IPScan', 'R3', Edit3.Text);
ini.WriteString('IPScan', 'R4', Edit4.Text);
ini.WriteString('IPScan', 'R5', Edit5.Text);
ini.WriteString('IPScan', 'R6', Edit6.Text);
ini.WriteString('IPScan', 'R7', Edit7.Text);
ini.WriteString('IPScan', 'R8', Edit8.Text);
ini.WriteInteger('IPScan', 'Thread', SpinEdit1.Value);
ini.WriteInteger('IPScan', 'Port', SpinEdit2.Value);
ini.Free;
end;

end.
