/* Socket Engine code */

#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <stdlib.h>
#include "grinder.h"
#include "sockeng.h"

/* simple static class method to get a NBO ip from a string */

extern int gRunning;

long sockeng::getaddr(char *string)
{
	struct hostent * hp;
	long addr;
	WSADATA wsaData;

	if (WSAStartup(MAKEWORD(2,1),&wsaData) != 0)
	{
//		return -1;
	}

	addr = inet_addr(string); 
	if (addr == INADDR_NONE)
	{
		hp = gethostbyname(string);
		if (!hp)
		{
			WSACleanup( );
			return -1;
		}
		memcpy(&(addr),hp->h_addr,sizeof(addr));
	}
	WSACleanup( );
	return addr;
}

/* constructor - malloc our mem */

sockeng::sockeng(int numsockets,long to,long s,long e,char *u)
{
	num=numsockets;
	left=ntohl(e)-ntohl(s);
	total=left;
	if (num>left) num=left;

	sockets=new snode[num];

	for (int i=0;i<num;i++)
	{
		sockets[i].state=0;
		sockets[i].timestamp=0;
	}
	timeout=to;
	start=s;

	url=(char *)malloc(strlen(u)+30);
	sprintf(url,"GET %s HTTP/1.0\n\n",u);
}

/* destructor */

sockeng::~sockeng(void)
{
	free(url);
	delete sockets;
}

/* lets get all our sockets ready 
 * this function also lets the user know if they specified
 * too many sockets because one of the socket()s will fail */

int sockeng::init_engine(void)
{
	WSADATA wsaData;
	unsigned long off=0;
	unsigned long on=1;

	shutdown_engine();

	for (int i=0;i<num;i++)
	{
		sockets[i].state=0;
		if (WSAStartup(MAKEWORD(2,1),&wsaData) != 0)
		{
//			for (int j=0;j<i;j++)
//			{
//				sockets[j].state=0;
//				ioctlsocket(sockets[j].s,FIONBIO,&off);
//				shutdown(sockets[j].s,2);
//				closesocket(sockets[j].s);
//				WSACleanup();
//			}
//			return -1;
		}
		sockets[i].s=socket(AF_INET,SOCK_STREAM,0);	
		if (sockets[i].s==SOCKET_ERROR)
		{
			WSACleanup();
			for (int j=0;j<i;j++)
			{
				ioctlsocket(sockets[j].s,FIONBIO,&off);
				shutdown(sockets[j].s,2);
				closesocket(sockets[j].s);
				sockets[j].state=0;
				WSACleanup();
			}
			return -1;
		}
		/* Non-blocking socket */
		ioctlsocket(sockets[i].s,FIONBIO,&on);
		sockets[i].state=1;
	}
	return 1;
}

/* general purpose cleanup function */

void sockeng::shutdown_engine(void)
{
	unsigned long off=0;

	for (int i=0;i<num;i++)
	{
		if (sockets[i].state!=0)
		{
			/* lets make sure our close is blocking */
			ioctlsocket(sockets[i].s,FIONBIO,&off);
			shutdown(sockets[i].s,2);
			closesocket(sockets[i].s);
			WSACleanup();
		}
	}
}

/* our engine */

int sockeng::grind(LPVOID pParam)
{
	fd_set fdset;
	struct sockaddr_in dest;
	
	unsigned long on=1;	
	unsigned long off=0;

	int bwrote;
	int s,i;
	struct timeval tv= {0,0};

	char buffer[8192];
	char *answer;
	char *token;

	FD_ZERO(&fdset);

	memset(&dest,0,sizeof(dest));
	dest.sin_addr.s_addr=start;
	dest.sin_port=htons(80);	
	dest.sin_family = AF_INET;

	/* reset prog bar */
	::PostMessage((HWND)pParam,WM_THREADPROGRESS,0,-1);

	while(1)
	{
		if (gRunning==0)
		{
			shutdown_engine();
			return 1;
		}

		Sleep(100);
		/* if we have hosts left to scan, and free sockets,
		 * then lets do a non-blocking connect */

		for (i=0;(i<num) && left;i++)
		{
			if (sockets[i].state==0)
			{
				sockets[i].s=socket(AF_INET,SOCK_STREAM,0);	
				if (sockets[i].s!=SOCKET_ERROR)
				{
					/* Non-blocking socket */
					ioctlsocket(sockets[i].s,FIONBIO,&on);
					sockets[i].state=1;
				}
			}
			if (sockets[i].state==1)
			{
				bwrote = connect(sockets[i].s,
					(struct sockaddr*)&dest, sizeof(dest));
				sockets[i].state=2;
				sockets[i].timestamp=GetTickCount();
				sockets[i].target=dest.sin_addr.s_addr;
				dest.sin_addr.s_addr=htonl(ntohl(dest.sin_addr.s_addr)+1);
				left--;
			}
			if ((i%4)==0)
			{
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
				Sleep(200);
			}
		}

		if (gRunning==0)
		{
			shutdown_engine();
			return 1;
		}


		/* if we have any sockets currently connecting, lets
		 * check them to see if they are done or errored out
		 */
		FD_ZERO(&fdset);
		for (i=0;i<num;i++)
		{
			if (sockets[i].state==2)
			{
				FD_SET(sockets[i].s,&fdset);
			}
			if ((i%10)==0)
			{
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
				Sleep(10);
			}
		}
		s=select(0,NULL,&fdset,NULL,&tv);
		for (i=0;i<num;i++)
		{
			if (FD_ISSET(sockets[i].s,&fdset))
			{
				/* Successful connect */
				sockets[i].state=3;
				sockets[i].timestamp=GetTickCount();

			}
			if ((i%10)==0)
			{
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
				Sleep(10);
			}
		}

		if (gRunning==0)
		{
			shutdown_engine();
			return 1;
		}

		for (i=0;i<num;i++)
		{
			if (sockets[i].state==3)
			{
				send(sockets[i].s,url,strlen(url),0);
				sockets[i].state=4;
			}
			if ((i%10)==0)
			{
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
				Sleep(10);
			}
		}

		if (gRunning==0)
		{
			shutdown_engine();
			return 1;
		}

		FD_ZERO(&fdset);
		for (i=0;i<num;i++)
		{
			if (sockets[i].state==4)
			{
				FD_SET(sockets[i].s,&fdset);
			}
			if ((i%10)==0)
			{
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
				Sleep(10);
			}
		}
		s=select(0,&fdset,NULL,NULL,&tv);
		for (i=0;i<num;i++)
		{
			if (FD_ISSET(sockets[i].s,&fdset))
			{
				/* Ready to be read from */
				/* We can block on this because it makes it easy */
				/* And we know the data is already here */
				ioctlsocket(sockets[i].s,FIONBIO,&off);
				if (recv(sockets[i].s,buffer,8192,0)>0)
				{
					answer=NULL;
					if (strstr(buffer,"200"))
					{
						answer=(char *)malloc(8192); 
						sprintf(answer,"URL Present\t");
					}
					else if (strstr(buffer,"302"))
					{
						answer=(char *)malloc(8192); 
						sprintf(answer,"Document Moved\t");
					}
					else if (strstr(buffer,"401"))
					{
						answer=(char *)malloc(8192); 
						sprintf(answer,"Auth Required\t");
					}
					else if (strstr(buffer,"403"))
					{
						answer=(char *)malloc(8192); 
						sprintf(answer,"Access Denied\t");
					}
					else if (strstr(buffer,"500"))
					{
						answer=(char *)malloc(8192); 
						sprintf(answer,"Server Error\t");
					}
					else if (!strstr(buffer,"404"))
					{
						answer=(char *)malloc(8192); 
						sprintf(answer,"Odd Response\t");
					}
					if (answer)
					{
						token=strtok(buffer,"\n");
						while(token)
						{
							if (!strncmp(token,"Server:",7))
							{
								strcat(answer,(strchr(token,':')+1));
								break;
							}
							token=strtok(NULL,"\n");
						}
						::PostMessage((HWND)pParam,WM_THREADHOST,
							(unsigned int)answer,	sockets[i].target);
					}
				}
				shutdown(sockets[i].s,2);
				closesocket(sockets[i].s);
				sockets[i].state=0;

				::PostMessage((HWND)pParam,WM_THREADPROGRESS,0,
					total);
			}
			if ((i%10)==0)
			{
				Sleep(10);
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
			}
		}

		/* check for error or timeout */

		FD_ZERO(&fdset);
		for (i=0;i<num;i++)
		{
			if (sockets[i].state==2 || sockets[i].state==4)
			{
				if ((GetTickCount()-sockets[i].timestamp)>timeout)
				{
					ioctlsocket(sockets[i].s,FIONBIO,&off);
					shutdown(sockets[i].s,2);
					closesocket(sockets[i].s);
					sockets[i].state=0;
					::PostMessage((HWND)pParam,WM_THREADPROGRESS,0,total);
				}
				else
					FD_SET(sockets[i].s,&fdset);
			}
			if ((i%10)==0)
			{
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
				Sleep(10);
			}
		}
		s=select(0,NULL,NULL,&fdset,&tv);
		for (i=0;i<num;i++)
		{
			if (FD_ISSET(sockets[i].s,&fdset))
			{
				/* Unsuccessful connect */
				ioctlsocket(sockets[i].s,FIONBIO,&off);
				shutdown(sockets[i].s,2);
				closesocket(sockets[i].s);
				sockets[i].state=0;
				::PostMessage((HWND)pParam,WM_THREADPROGRESS,0,total);			
			}
			if ((i%10)==0)
			{
				if (gRunning==0)
				{
					shutdown_engine();
					return 1;
				}
				Sleep(10);
			}
		}


		if (!left)
		{
			int any=0;
			for (i=0;i<num;i++)
				if (sockets[i].state!=0)
					any=1;
			if (!any) 
			{
				return 1;
			}
		}
	}
}
