// grinderDlg.cpp
//

#include "stdafx.h"
#include "grinder.h"
#include "grinderDlg.h"
#include "sockeng.h"
#include "cbtext.h"
#include "AboutDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

struct ThreadArgs
{
	HWND win;
	long NumSockets;
	long Start,End,Timeout;
	char Url[1024];
};

/* Our two global variables */

int gContent;
int gRunning;

/* Our thread entry point */

UINT ComputeThreadProc(LPVOID pParam)
{
	struct ThreadArgs *ta;

	ta=(struct ThreadArgs *)pParam;

	if (ta->NumSockets>=0 && ta->NumSockets<=100000)
	{
		gRunning=1;
		sockeng *s=new sockeng(ta->NumSockets,ta->Timeout,ta->Start,
			ta->End,ta->Url);
		::PostMessage(ta->win,WM_THREADSTARTING,0,0);
		if (s->init_engine()==-1)
			::PostMessage(ta->win,WM_THREADERROR,0,
			(long)"Error starting up socket engine. You probably specified too many sockets.");
		else
			::PostMessage(ta->win,WM_THREADREADY,0,0);
		if (s->grind(ta->win)==-1)
			::PostMessage(ta->win,WM_THREADERROR,0,
				(long)"Scanning Error.");
		else
			::PostMessage(ta->win,WM_THREADSHUTDOWN,0,0);
		s->shutdown_engine();
		::PostMessage(ta->win,WM_THREADDONE,0,0);
	}
	else
	{
		::PostMessage(ta->win,WM_THREADERROR,0,
			(long)"Error parsing parallel sockets field.");
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

/* Our custom message handlers for messages from the thread */

LRESULT CGrinderDlg::OnStartup(WPARAM wParam, LPARAM lParam)
{
	CStatic *statusBar=(CStatic *)GetDlgItem(IDC_STATUS);
	CProgressCtrl *pro=(CProgressCtrl *)GetDlgItem(IDC_PROGRESS);

	statusBar->SetWindowText("Initializing Socket Engine...");
	pro->ShowWindow(1);
	
	return 0L;
}

LRESULT CGrinderDlg::OnError(WPARAM wParam, LPARAM lParam)
{
	CStatic *statusBar=(CStatic *)GetDlgItem(IDC_STATUS);
	CProgressCtrl *prog=(CProgressCtrl *)GetDlgItem(IDC_PROGRESS);

	statusBar->SetWindowText("");
	prog->ShowWindow(0);

	gRunning=0;

	if (lParam)
	{
		CString msg((char *)lParam);
		MessageBox(msg,"Scanning Error",
				MB_ICONEXCLAMATION);
	}

	return 0L;
}

LRESULT CGrinderDlg::OnReady(WPARAM wParam, LPARAM lParam)
{
	CStatic *statusBar=(CStatic *)GetDlgItem(IDC_STATUS);
	CProgressCtrl *prog=(CProgressCtrl *)GetDlgItem(IDC_PROGRESS);

	statusBar->SetWindowText("Grinding...");
	prog->SetPos(0);
	prog->ShowWindow(1);
	return 0L;
}

LRESULT CGrinderDlg::OnShutdown(WPARAM wParam, LPARAM lParam)
{
	CStatic *statusBar=(CStatic *)GetDlgItem(IDC_STATUS);
	CProgressCtrl *prog=(CProgressCtrl *)GetDlgItem(IDC_PROGRESS);

	statusBar->SetWindowText("Shutting Down Socket Engine...");
	prog->ShowWindow(1);

	gRunning=0;

	return 0L;
}

LRESULT CGrinderDlg::OnDone(WPARAM wParam, LPARAM lParam)
{
	CStatic *statusBar=(CStatic *)GetDlgItem(IDC_STATUS);
	CProgressCtrl *pro=(CProgressCtrl *)GetDlgItem(IDC_PROGRESS);

	statusBar->SetWindowText("");
	pro->ShowWindow(0);
	CButton *prog=(CButton *)GetDlgItem(IDC_BUTTON1);
	prog->SetWindowText("Scan");
	return 0L;
}

LRESULT CGrinderDlg::OnHost(WPARAM wParam, LPARAM lParam)
{
	CListBox *list=(CListBox *)GetDlgItem(IDC_LIST2);

	char bob[8192];
	sprintf(bob,"%d.%d.%d.%d\t%s",(lParam&255),(lParam>>8)&255,
		(lParam>>16)&255,(lParam>>24)&255,
		(char *)wParam);
	bob[strlen(bob)-1]=0;

	free((char *)wParam);
	list->AddString(bob);

	if (!gContent)
	{
		CButton *prog=(CButton *)GetDlgItem(IDC_BUTTON2);	
		prog->EnableWindow(1);
		prog=(CButton *)GetDlgItem(IDC_BUTTON3);	
		prog->EnableWindow(1);
		prog=(CButton *)GetDlgItem(IDC_BUTTON4);	
		prog->EnableWindow(1);
	}
	gContent=1;

	return 0L;
}

LRESULT CGrinderDlg::OnProgress(WPARAM wParam, LPARAM lParam)
{
	static l=0;

	if (lParam==-1) { l=0; return 0L; }

	CProgressCtrl *prog=(CProgressCtrl *)GetDlgItem(IDC_PROGRESS);
	CStatic *statusBar=(CStatic *)GetDlgItem(IDC_STATUS);

	prog->SetPos(l++);

	char bob[80];
	sprintf(bob,"Grinding... %d/%d hosts scanned",l,lParam);
	statusBar->SetWindowText(bob);

	return 0L;
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)


	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGrinderDlg dialog

CGrinderDlg::CGrinderDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGrinderDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGrinderDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGrinderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGrinderDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGrinderDlg, CDialog)
	//{{AFX_MSG_MAP(CGrinderDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_EDIT4, OnChangeEdit4)
	ON_EN_CHANGE(IDC_EDIT5, OnChangeEdit5)
	ON_EN_CHANGE(IDC_EDIT6, OnChangeEdit6)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	//}}AFX_MSG_MAP
ON_MESSAGE(WM_THREADERROR, OnError)
ON_MESSAGE(WM_THREADSTARTING, OnStartup)
ON_MESSAGE(WM_THREADREADY, OnReady)
ON_MESSAGE(WM_THREADSHUTDOWN, OnShutdown)
ON_MESSAGE(WM_THREADDONE, OnDone)
ON_MESSAGE(WM_THREADHOST, OnHost)
ON_MESSAGE(WM_THREADPROGRESS, OnProgress)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGrinderDlg message handlers
void CGrinderDlg::OnOK()
{ 
}

BOOL CGrinderDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	CEdit *pUrl=(CEdit *)GetDlgItem(IDC_EDIT1);
	if (pUrl)
		pUrl->SetWindowText("/index.html");

	CEdit *pTimeout=(CEdit *)GetDlgItem(IDC_EDIT2);
	pTimeout->SetWindowText("15000");

	CEdit *pSockets=(CEdit *)GetDlgItem(IDC_EDIT3);
	pSockets->SetWindowText("50");

	CEdit *pLastFromOct=(CEdit *)GetDlgItem(IDC_EDIT7);
	pLastFromOct->SetWindowText("1");

	CEdit *pFirstFromOct=(CEdit *)GetDlgItem(IDC_EDIT11);
	pFirstFromOct->SetWindowText("254");
	
	gContent=0;
	gRunning=0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGrinderDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGrinderDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGrinderDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGrinderDlg::OnChangeEdit4() 
{
	CString cstr;
	CEdit *pOct1=(CEdit *)GetDlgItem(IDC_EDIT4);
	CEdit *pOct5=(CEdit *)GetDlgItem(IDC_EDIT8);

	if (pOct1 && pOct5)
	{
		pOct1->GetWindowText(cstr);
		if (cstr)
			pOct5->SetWindowText(cstr);
	}
}

void CGrinderDlg::OnChangeEdit5() 
{
	CString cstr;
	CEdit *pOct2=(CEdit *)GetDlgItem(IDC_EDIT5);
	CEdit *pOct6=(CEdit *)GetDlgItem(IDC_EDIT9);

	if (pOct2 && pOct6)
	{
		pOct2->GetWindowText(cstr);
		if (cstr)
			pOct6->SetWindowText(cstr);
	}	
}

void CGrinderDlg::OnChangeEdit6() 
{
	CString cstr;
	CEdit *pOct3=(CEdit *)GetDlgItem(IDC_EDIT6);
	CEdit *pOct7=(CEdit *)GetDlgItem(IDC_EDIT10);

	if (pOct3 && pOct7)
	{
		pOct3->GetWindowText(cstr);
		if (cstr)
			pOct7->SetWindowText(cstr);
	}
}

int CGrinderDlg::validate(CString cstr)
{
	if ((atoi(cstr)<0) || (atoi(cstr)>255))
	{
		CString msg("The IP addresses you entered are invalid.");
		MessageBox(msg,"Data Validation Error",
			MB_ICONEXCLAMATION);
		return 0;
	}
	return 1;
}

/* Scan button */

void CGrinderDlg::OnButton1() 
{
	CString o1,o2,o3,o4,o5,o6,o7,o8,sockets,to;
	static struct ThreadArgs ta;

	if (gRunning==1)
	{
		gRunning=0;
		return;
	}

	CEdit *pUrl=(CEdit *)GetDlgItem(IDC_EDIT1);
	CEdit *pTimeout=(CEdit *)GetDlgItem(IDC_EDIT2);
	CEdit *pSockets=(CEdit *)GetDlgItem(IDC_EDIT3);
	CEdit *pFOct1=(CEdit *)GetDlgItem(IDC_EDIT4);
	CEdit *pFOct2=(CEdit *)GetDlgItem(IDC_EDIT5);
	CEdit *pFOct3=(CEdit *)GetDlgItem(IDC_EDIT6);
	CEdit *pFOct4=(CEdit *)GetDlgItem(IDC_EDIT7);
	CEdit *pTOct1=(CEdit *)GetDlgItem(IDC_EDIT8);
	CEdit *pTOct2=(CEdit *)GetDlgItem(IDC_EDIT9);
	CEdit *pTOct3=(CEdit *)GetDlgItem(IDC_EDIT10);
	CEdit *pTOct4=(CEdit *)GetDlgItem(IDC_EDIT11);

	pFOct1->GetWindowText(o1);
	if (!validate(o1)) return;
	pFOct2->GetWindowText(o2);
	if (!validate(o2)) return;
	pFOct3->GetWindowText(o3);
	if (!validate(o3)) return;
	pFOct4->GetWindowText(o4);
	if (!validate(o4)) return;
	pTOct1->GetWindowText(o5);
	if (!validate(o5)) return;
	pTOct2->GetWindowText(o6);
	if (!validate(o6)) return;
	pTOct3->GetWindowText(o7);
	if (!validate(o7)) return;
	pTOct4->GetWindowText(o8);
	if (!validate(o8)) return;	

	pSockets->GetWindowText(sockets);
	pTimeout->GetWindowText(to);
	char t[1000];
	pUrl->GetWindowText(t,1000);
	strncpy(ta.Url,t,100);
	ta.NumSockets=atoi(sockets);
	ta.Timeout=atoi(to);

	char startIP[80],endIP[80];

	sprintf(startIP,"%s.%s.%s.%s",o1.GetBuffer(3),o2.GetBuffer(3)
		,o3.GetBuffer(3),o4.GetBuffer(3));
	sprintf(endIP,"%s.%s.%s.%s",o5.GetBuffer(3),o6.GetBuffer(3)
		,o7.GetBuffer(3),o8.GetBuffer(3));

	ta.Start=sockeng::getaddr(startIP);
	if (ta.Start==-1)
	{
		CString msg("There is a problem with your starting IP.");
		MessageBox(msg,"Data Validation Error",
			MB_ICONEXCLAMATION);
		return;
	}
	ta.End=sockeng::getaddr(endIP);
	if (ta.End==-1)
	{
		CString msg("There is a problem with your ending IP.");
		MessageBox(msg,"Data Validation Error",
			MB_ICONEXCLAMATION);
		return;
	}

	if ((ntohl(ta.End))<(ntohl(ta.Start)))
	{
		CString msg("Your ending IP is lower than your starting IP.");
		MessageBox(msg,"Data Validation Error",
			MB_ICONEXCLAMATION);
		return;
	}

	CProgressCtrl *prog=(CProgressCtrl *)GetDlgItem(IDC_PROGRESS);
	prog->SetRange32(0,ntohl(ta.End)-ntohl(ta.Start));

	CButton *prg=(CButton *)GetDlgItem(IDC_BUTTON1);
	prg->SetWindowText("Stop");

	ta.win=GetSafeHwnd();

	CWinThread *pThread =
	AfxBeginThread(ComputeThreadProc, &ta,
			   THREAD_PRIORITY_NORMAL);
}

/* Clear Button */

void CGrinderDlg::OnButton2() 
{
	gContent=0;

	CButton *prog=(CButton *)GetDlgItem(IDC_BUTTON2);	
	prog->EnableWindow(0);
	prog=(CButton *)GetDlgItem(IDC_BUTTON3);	
	prog->EnableWindow(0);
	prog=(CButton *)GetDlgItem(IDC_BUTTON4);	
	prog->EnableWindow(0);

	CListBox *list=(CListBox *)GetDlgItem(IDC_LIST2);
	list->ResetContent();
}

/* Copy Button */

void CGrinderDlg::OnButton4() 
{
	CBText t;
	char item[8192];
	CString clip;

	CListBox *list=(CListBox *)GetDlgItem(IDC_LIST2);
	for (int i=0;i<list->GetCount();i++)
	{
		list->GetText(i,item);
		clip=clip+item+"\n";
	}
	t.SetText(clip);
}

/* Save Button */

void CGrinderDlg::OnButton3() 
{
	CFileDialog fileDialog(FALSE,
		"txt", NULL,
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		"Text Files (*.txt)|*.txt|All Files (*.*)|*.*||");

	if (fileDialog.DoModal() == IDOK)
	{
		CString filePathName=fileDialog.GetPathName();
		CFile file;

		if (!file.Open(filePathName,CFile::modeCreate|
			CFile::modeWrite))
		{
			CString msg("Can't Open "+ filePathName+
				"\nCheck the filename.");
			MessageBox(msg,"File Save Error",
				MB_ICONEXCLAMATION);
		}
		else
		{
			char item[8192];
			CString clip;

			CListBox *list=(CListBox *)GetDlgItem(IDC_LIST2);
			for (int i=0;i<list->GetCount();i++)
			{
				list->GetText(i,item);
				clip=clip+item+"\n";
			}
			file.Write(clip,strlen(clip));
			file.Close();
		}
	}
}

/* About / Help Dialog */
void CGrinderDlg::OnButton5() 
{
	AboutDialog ad;
	ad.DoModal();
}
