/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#if !defined(AFX_UDPCRAFTER_H__E0C62C93_E6F6_4935_A5C9_F129A76F357A__INCLUDED_)
#define AFX_UDPCRAFTER_H__E0C62C93_E6F6_4935_A5C9_F129A76F357A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "UDPSocket.h"
#include "IPCrafter.h"

class CUDPCrafter : 
	public CUDPSocket, 
	public CIPCrafter  
{
public:
	//Use default checksum or given checksum
	void SetUDPUseDefaultChecksum(BOOL bDefault);

	//Set the default checksum
	void SetUDPChecksum(unsigned short usChecksum);

	//Set the default data
	void SetUDPDefault();

	//ctor and dtor
	CUDPCrafter();
	virtual ~CUDPCrafter();
protected:
	//Create an IP header
	virtual LPIpHeader ConstructIPHeader (unsigned char  ucProtocol,
										  unsigned short usFragmentationFlags,
										  unsigned char  ucTTL,
										  unsigned short usIdentification,
										  unsigned char  ucHeaderLength);

	//Last stop before sending the header
	virtual void FinalIPHeader(LPIpHeader lpHead);

	//Last stop before modifying the header
	virtual void FinalUDPHeader(LPUDPHeader lpHeader);
private:
	//Checksum flag
	unsigned short m_usUDPChecksum;
	BOOL m_UDPDefaultChecksum;
};

#endif // !defined(AFX_UDPCRAFTER_H__E0C62C93_E6F6_4935_A5C9_F129A76F357A__INCLUDED_)
