/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "UDPCrafter.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define CUDPCrafter_Class "CUDPCrafter"

CUDPCrafter::CUDPCrafter() : CUDPSocket(),
							 CIPCrafter()
{
	try
	{
		//Set our name
		CUDPSocket::SetName(CUDPCrafter_Class);

		//Set the default
		SetUDPDefault();
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"CUDPCrafter")
}

CUDPCrafter::~CUDPCrafter()
{

}

LPIpHeader CUDPCrafter::ConstructIPHeader(unsigned char  ucProtocol,
										  unsigned short usFragmentationFlags,
										  unsigned char  ucTTL,
										  unsigned short usIdentification,
										  unsigned char  ucHeaderLength)
{
	return ConstructCraftedIPHeader(ucProtocol,
									usFragmentationFlags,
									ucTTL,
									usIdentification,
									ucHeaderLength);
}

void CUDPCrafter::FinalIPHeader(LPIpHeader lpHead)
{
	try
	{
		//Check if we need to modify the header
		if (!m_DefaultChecksum)
			lpHead->CheckSum=htons(m_usChecksum);
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"FinalIPHeader")
}

void CUDPCrafter::SetUDPDefault()
{
	try
	{
		//Default checksum used
		m_UDPDefaultChecksum=TRUE;
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"SetUDPDefault")
}

void CUDPCrafter::SetUDPChecksum(unsigned short usChecksum)
{
	m_usUDPChecksum=usChecksum;
}

void CUDPCrafter::SetUDPUseDefaultChecksum(BOOL bDefault)
{
	m_UDPDefaultChecksum=bDefault;
}

void CUDPCrafter::FinalUDPHeader(LPUDPHeader lpHeader)
{
	if (!m_UDPDefaultChecksum)
		lpHeader->Checksum=htons(m_usUDPChecksum);
}