/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#if !defined(AFX_TCPCRAFTER_H__E2C01EE5_8ABA_4D74_91D6_E80D1D404E5C__INCLUDED_)
#define AFX_TCPCRAFTER_H__E2C01EE5_8ABA_4D74_91D6_E80D1D404E5C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TCPSocket.h"
#include "IPCrafter.h"

class CTCPCrafter : 
	public CTCPSocket,
	public CIPCrafter
{
public:
	//Set urgent pointer
	void SetUrgentPointer(unsigned short usUrgentPointer);

	//Indicate if we want to use TCP default checksum
	void SetTCPUseDefaultChecksum(BOOL bDefault);

	//Set the TCP checksum
	void SetTCPChecksum(unsigned short usTCPChecksum);

	//Set the window size
	void SetWindow(unsigned short usWindow);

	//Set the TCP flags
	void SetFlags(unsigned char ucFlags);

	//Set the data offset (TCP)
	void SetDataOffset(unsigned char ucDataOffset);

	//Set the acknowledge number
	void SetAcknowledgeNumber(unsigned int iAcknowledgeNumber);

	//Set the sequence number
	void SetSequenceNumber(unsigned int iSequenceNumber);

	//Send raw packet
	virtual BOOL SendRaw(int iSourcePort, 
						 LPCSTR lpDestinationAddress, 
						 int iDestinationPort,
						 char* buf,
						 int BufLength,
						 unsigned char ucFlags=0);

	//ctor and dtor
	CTCPCrafter();
	virtual ~CTCPCrafter();
protected:
	//Create an IP header
	virtual LPIpHeader ConstructIPHeader (unsigned char  ucProtocol,
										  unsigned short usFragmentationFlags,
										  unsigned char  ucTTL,
										  unsigned short usIdentification,
										  unsigned char  ucHeaderLength);

	//Last stop before sending the header
	virtual void FinalIPHeader(LPIpHeader lpHead);

	//Create the TCP header
	virtual LPTCPHeader ConstructTCPHeader(int iSourcePort,int iDestinationPort,int iHeaderLength);

	//Last call before send
	virtual void FinalTCPHeader(LPTCPHeader lpHead);
private:
	//Our sequence number
	unsigned int m_SequenceNumber;

	//Our acknowledge number
	unsigned int m_AcknowledgeNumber;

	//TCP data offset
	unsigned char m_DataOffset;

	//TCP flags
	unsigned char m_Flags;

	//Window size
	unsigned short m_Window;

	//TCP checksum
	unsigned short m_TCPChecksum;
	BOOL m_TCPUseDefaultChecksum;

	//Urgent pointer indicator
	unsigned short m_UrgentPointer;
};

#endif // !defined(AFX_TCPCRAFTER_H__E2C01EE5_8ABA_4D74_91D6_E80D1D404E5C__INCLUDED_)
