/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "UDPSocketAsync.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define CUDPSocketAsync_Class "CUDPSocketAsync"

CUDPSocketAsync::CUDPSocketAsync() : CUDPSocket(), 
									 CAsyncSocket()
{
	try
	{
		CSpoofSocket::SetName(CUDPSocketAsync_Class);
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"CUDPSocketAsync")
}

CUDPSocketAsync::~CUDPSocketAsync()
{
	//We need to close it here
	try
	{
		Close();
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"~CUDPSocketAsync")
}

BOOL CUDPSocketAsync::Listen()
{
	try
	{
		//Quit if not ok
		if (!CheckSocketValid())
			return FALSE;

		int iResult;
		
		iResult=WSAAsyncSelect(GetHandle(),GetWindowHandle(),WM_SOCKET_GENERAL,FD_READ);
		if (iResult)
		{
			CUDPSocket::SetLastError("Listen");
			return FALSE;
		}

		return TRUE;
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Listen",FALSE)
}

BOOL CUDPSocketAsync::SetAsync()
{
	try
	{
		//Quit if not ok
		if (!CheckSocketValid())
			return FALSE;

		//Set event to read / write 
		int iResult;

		iResult=WSAAsyncSelect(GetHandle(),GetWindowHandle(),WM_SOCKET_GENERAL,FD_WRITE | FD_READ);
		if (iResult)
		{
			CUDPSocket::SetLastError("SetAsync");
			return FALSE;
		}
		
		return TRUE;
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"SetAsync",FALSE)
}

BOOL CUDPSocketAsync::OnSocketConnect(int iErrorCode)
{
	//First set async again
	return SetAsync();
}

void CUDPSocketAsync::Accepted()
{
	try
	{
		AddSocketToList();

		//Go to async mode
		SetAsync();
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"CTCPSocketAsync")
}

SOCKET CUDPSocketAsync::GetAsyncHandle() const
{
	return GetHandle();
}

BOOL CUDPSocketAsync::CreateRegular()
{
	try
	{
		if (!CUDPSocket::CreateRegular())
			return FALSE;
		else
		{
			AddSocketToList();
			return TRUE;
		}
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"CreateRegular",FALSE)
}

BOOL CUDPSocketAsync::Create()
{
	try
	{
		if (!CUDPSocket::Create())
			return FALSE;
		else
		{
			AddSocketToList();
			return TRUE;
		}
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Create",FALSE)
}

BOOL CUDPSocketAsync::Close()
{
	try
	{
		//Quit if not ok
		if (!ValidSocket())
			return FALSE;

		//Kill the timer
		CAsyncSocket::SocketClosing();

		//Remove from socket list
		RemoveSocketFromList();

		return CUDPSocket::Close();
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Close",FALSE)
}