/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "TCPSocketAsync.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define CTCPSocketAsync_Class "CTCPSocketAsync"

CTCPSocketAsync::CTCPSocketAsync() : CTCPSocket(), 
									 CAsyncSocket()
{
	try
	{
		CSpoofSocket::SetName(CTCPSocketAsync_Class);
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"CTCPSocketAsync")
}

CTCPSocketAsync::~CTCPSocketAsync()
{
	//We need to close it here
	try
	{
		Close();
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"~CTCPSocketAsync")
}

BOOL CTCPSocketAsync::Connect(int iSourcePort,LPCSTR lpDestinationAddress,int iDestinationPort,BOOL bDisableAsync)
{
	try
	{
		//Quit if not ok
		if (!CheckSocketValid())
			return FALSE;

		//Set the async notification
		if (!bDisableAsync)
		{
			int iResult;
			iResult=WSAAsyncSelect(GetHandle(),GetWindowHandle(),WM_SOCKET_CONNECT,FD_CONNECT);

			if (iResult)
			{
				CTCPSocket::SetLastError("Connect");
				return FALSE;
			}
		}

		//Call the original connect
		BOOL bResult;
		bResult=CTCPSocket::Connect(iSourcePort,lpDestinationAddress,iDestinationPort);

		if (bResult)
			AddSocketToList();
		else
			CTCPSocket::ReportError("Connect","Failed to connect!");

		return bResult;
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Connect",FALSE)
}

BOOL CTCPSocketAsync::Listen(int iBackLog)
{
	try
	{
		//Quit if not ok
		if (!CheckSocketValid())
			return FALSE;

		int iResult;
		
		iResult=WSAAsyncSelect(GetHandle(),GetWindowHandle(),WM_SOCKET_ACCEPT,FD_ACCEPT);
		if (iResult)
		{
			CTCPSocket::SetLastError("Listen");
			return FALSE;
		}

		return CTCPSocket::Listen(iBackLog);
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Listen",FALSE)
}

BOOL CTCPSocketAsync::SetAsync()
{
	try
	{
		//Quit if not ok
		if (!CheckSocketValid())
			return FALSE;

		//Set event to read / write / close / oob
		int iResult;

		iResult=WSAAsyncSelect(GetHandle(),GetWindowHandle(),WM_SOCKET_GENERAL,FD_WRITE | FD_READ | FD_CLOSE | FD_OOB);
		if (iResult)
		{
			CTCPSocket::SetLastError("SetAsync");
			return FALSE;
		}
		
		return TRUE;
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"SetAsync",FALSE)
}

BOOL CTCPSocketAsync::OnSocketConnect(int iErrorCode)
{
	//First set async again
	return SetAsync();
}

void CTCPSocketAsync::Accepted()
{
	try
	{
		AddSocketToList();

		//Go to async mode
		SetAsync();
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"CTCPSocketAsync")
}

SOCKET CTCPSocketAsync::GetAsyncHandle() const
{
	return GetHandle();
}

BOOL CTCPSocketAsync::CreateRegular()
{
	try
	{
		if (!CTCPSocket::CreateRegular())
			return FALSE;
		else
		{
			AddSocketToList();
			return TRUE;
		}
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"CreateRegular",FALSE)
}

BOOL CTCPSocketAsync::Create()
{
	try
	{
		if (!CTCPSocket::Create())
			return FALSE;
		else
		{
			AddSocketToList();
			return TRUE;
		}
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Create",FALSE)
}

BOOL CTCPSocketAsync::Close()
{
	try
	{
		//Quit if not ok
		if (!ValidSocket())
			return FALSE;

		//Kill the timer
		CAsyncSocket::SocketClosing();

		//Remove from socket list
		RemoveSocketFromList();

		return CTCPSocket::Close();
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Close",FALSE)
}