/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "ICMPSocketAsync.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define CICMPSocketAsync_Class "CICMPSocketAsync"

CICMPSocketAsync::CICMPSocketAsync() : CICMPSocket(),
									   CAsyncSocket()
{
	try
	{
		CSpoofSocket::SetName(CICMPSocketAsync_Class);
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"CICMPSocketAsync")
}

CICMPSocketAsync::~CICMPSocketAsync()
{
	//We need to close it here
	try
	{
		Close();
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"~CICMPSocketAsync")
}

BOOL CICMPSocketAsync::SetAsync()
{
	try
	{
		//Set event to read / write / close / oob
		int iResult;

		iResult=WSAAsyncSelect(GetHandle(),GetWindowHandle(),WM_SOCKET_GENERAL,FD_WRITE | FD_READ);
		if (iResult)
		{
			CICMPSocket::SetLastError("SetAsync");
			return FALSE;
		}
		
		return TRUE;
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"SetAsync",FALSE)
}

BOOL CICMPSocketAsync::OnSocketReceive(int iErrorCode)
{
	try
	{
		//Here we receive the data
		if (!iErrorCode)
		{
			//Buffer
			char* buf;
			buf=new char[ICMP_BUF];

			//Read the data
			int iRead;
			iRead=Receive(buf,ICMP_BUF);

			BOOL bResult=FALSE;

			//Only if not an error
			if (iRead!=SOCKET_ERROR)
				bResult=ProccessICMP(buf);
			
			//Clean up
			delete [] buf;
			return bResult;
		}
		else
			return FALSE;
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"OnSocketReceive",FALSE)
}

BOOL CICMPSocketAsync::Create()
{
	try
	{
		if (!CICMPSocket::Create())
		{
			CICMPSocket::ReportError("Create","Failed to create ICMP socket!");
			return FALSE;
		}

		AddSocketToList();

		return SetAsync();
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Create",FALSE)
}

SOCKET CICMPSocketAsync::GetAsyncHandle() const
{
	return GetHandle();
}

BOOL CICMPSocketAsync::Close()
{
	try
	{
		//Quit if not ok
		if (!ValidSocket())
			return FALSE;

		//Kill the timer
		CAsyncSocket::SocketClosing();

		//Remove from socket list
		RemoveSocketFromList();

		return CICMPSocket::Close();
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"Close",FALSE)
}