/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "GenericThread.h"
#include "OSManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGenericThread::CGenericThread(LPGenericThreadProc pThreadProc) : m_pThreadProc(pThreadProc),
																  m_dwThreadID(0),
																  m_pData(NULL),
																  m_ThreadStatus(tsError),
																  m_pCSection(NULL)
{
	//Create the critical section
	m_pCSection=COSManager::CreateCriticalSection();
}

CGenericThread::~CGenericThread()
{
	delete m_pCSection;
}

DWORD CGenericThread::GetThreadID() const
{
	return m_dwThreadID;
}

LPVOID CGenericThread::GetData() const
{
	return m_pData;
}

BOOL CGenericThread::Start(LPVOID pData)
{
	//Save the data
	m_pData=pData;

	return TRUE;
}

void CGenericThread::SetThreadStatus(ThreadStatus aStatus)
{
	try
	{
		m_pCSection->Enter();
		m_ThreadStatus=aStatus;
	}
	catch (...)
	{
	}

	m_pCSection->Exit();
}

CGenericThread::ThreadStatus CGenericThread::GetThreadStatus() const
{
	return m_ThreadStatus;
}

LPGenericThreadProc CGenericThread::GetThreadProc() const
{
	return m_pThreadProc;
}
