/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "Win32Thread.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CWin32Thread::CWin32Thread(LPGenericThreadProc pThreadProc) : CGenericThread(pThreadProc),
															  m_hThread(0)
{
	if (m_pThreadProc)
	{
		//Create the thread in suspend mode
		m_hThread=CreateThread(NULL,
   							   0,
							   Win32Thread,
							   this,
							   CREATE_SUSPENDED,
							   &m_dwThreadID);

		//Check if created
		if (m_hThread)
			SetThreadStatus(tsSuspended);
	}
		
}

CWin32Thread::~CWin32Thread()
{
	Stop();
}

BOOL CWin32Thread::Start(LPVOID pData)
{
	if (GetThreadStatus()!=tsSuspended)
		return FALSE;

	CGenericThread::Start(pData);

	//Resume the thread
	if (m_hThread)
		if (ResumeThread(m_hThread)!=-1)
			//We are running
			return TRUE;

	return FALSE;
}

BOOL CWin32Thread::Stop()
{
	//Only if suspened or running
	if ((GetThreadStatus()==tsRunning ||
		GetThreadStatus()==tsSuspended) && m_hThread)
		if (CloseHandle(m_hThread))
		{
			//Stopped
			SetThreadStatus(tsStopped);
			return TRUE;
		}
		else
			return FALSE;
	else
		return FALSE;
}

DWORD WINAPI CWin32Thread::Win32Thread(LPVOID lpData)
{
	//We have ourselves
	CWin32Thread* pClass;
	pClass=(CWin32Thread*)lpData;
	
	//Indicate we started running
	pClass->SetThreadStatus(tsRunning);

	//Get our data
	LPVOID pData;
	pData=pClass->GetData();

	//Our threadproc
	LPGenericThreadProc lpProc;
	lpProc=pClass->GetThreadProc();

	//Get the proc return value
	DWORD dwReturnValue;
	dwReturnValue=(*lpProc)(pData);

	//Indicate we stopped running
	pClass->SetThreadStatus(tsStopped);

	return dwReturnValue;
}
