/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "TCPCrafter.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define CTCPCrafter_Class "CTCPCrafter"

CTCPCrafter::CTCPCrafter() : CTCPSocket(), 
							 CIPCrafter()
{
	try
	{
		//Set our name
		CTCPSocket::SetName(CTCPCrafter_Class);

		//Set our default
		m_TCPUseDefaultChecksum=TRUE;

		//No sequence
		m_SequenceNumber=0;

		//No ack
		m_AcknowledgeNumber=0;

		//No offset
		m_DataOffset=(TCPHeaderLength/4) << 4;

		//No flags
		m_Flags=0;

		//No window
		m_Window=512;

		//No urgent pointer
		m_UrgentPointer=0;
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"CTCPCrafter")
}

CTCPCrafter::~CTCPCrafter()
{

}

LPIpHeader CTCPCrafter::ConstructIPHeader(unsigned char  ucProtocol,
										  unsigned short usFragmentationFlags,
										  unsigned char  ucTTL,
										  unsigned short usIdentification,
										  unsigned char  ucHeaderLength)
{
	return ConstructCraftedIPHeader(ucProtocol,
									usFragmentationFlags,
									ucTTL,
									usIdentification,
									ucHeaderLength);
}

void CTCPCrafter::FinalIPHeader(LPIpHeader lpHead)
{
	try
	{
		//Check if we need to modify the header
		if (!m_DefaultChecksum)
			lpHead->CheckSum=htons(m_usChecksum);
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"FinalIPHeader")
}

void CTCPCrafter::SetSequenceNumber(unsigned int iSequenceNumber)
{
	m_SequenceNumber=iSequenceNumber;
}

void CTCPCrafter::SetAcknowledgeNumber(unsigned int iAcknowledgeNumber)
{
	m_AcknowledgeNumber=iAcknowledgeNumber;
}

void CTCPCrafter::SetDataOffset(unsigned char ucDataOffset)
{
	m_DataOffset=ucDataOffset;
}

void CTCPCrafter::SetFlags(unsigned char ucFlags)
{
	m_Flags=ucFlags;
}

void CTCPCrafter::SetWindow(unsigned short usWindow)
{
	m_Window=usWindow;
}

void CTCPCrafter::SetTCPChecksum(unsigned short usTCPChecksum)
{
	m_TCPChecksum=usTCPChecksum;
}

void CTCPCrafter::SetTCPUseDefaultChecksum(BOOL bDefault)
{
	m_TCPUseDefaultChecksum=bDefault;
}

void CTCPCrafter::SetUrgentPointer(unsigned short usUrgentPointer)
{
	m_UrgentPointer=usUrgentPointer;
}

LPTCPHeader CTCPCrafter::ConstructTCPHeader(int iSourcePort,int iDestinationPort,int iHeaderLength)
{
	try
	{
		//Create the initial header
		LPTCPHeader lpHead;
		lpHead=CTCPSocket::ConstructTCPHeader(iSourcePort,iDestinationPort,iHeaderLength);

		if (!lpHead)
			return NULL;

		//Overide some data
		lpHead->Windows=htons(m_Window);

		//Set the packet number
		lpHead->AcknowledgeNumber=htonl(m_AcknowledgeNumber);

		//And the sequence
		lpHead->SequenceNumber=htonl(m_SequenceNumber);

		//Data offset
		lpHead->DataOffset=m_DataOffset << 4;

		//Flags
		lpHead->Flags=m_Flags;

		//Urgent pointer
		lpHead->UrgentPointer=htons(m_UrgentPointer);

		//Return it to the user
		return lpHead;
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"ConstructTCPHeader",NULL)
}

void CTCPCrafter::FinalTCPHeader(LPTCPHeader lpHead)
{
	try
	{
		if (!m_TCPUseDefaultChecksum)
			lpHead->Checksum=htons(m_TCPChecksum);
	}
	ERROR_HANDLER_AMBIG(CSpoofSocket,"FinalTCPHeader")
}

BOOL CTCPCrafter::SendRaw(int iSourcePort, 
						  LPCSTR lpDestinationAddress, 
						  int iDestinationPort,
						  char* buf,
						  int BufLength,
						  unsigned char ucFlags)
{
	try
	{
		unsigned char uclFlags;
		
		if (!ucFlags)
			uclFlags=m_Flags;
		else
			uclFlags=ucFlags;

		return CTCPSocket::SendRaw(iSourcePort,lpDestinationAddress,iDestinationPort,buf,BufLength,uclFlags);
	}
	ERROR_HANDLER_AMBIG_RETURN(CSpoofSocket,"SendRaw",FALSE)
}