//////////////////////////////////////////////////////////////////////
/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "SpoofBase.h"

#include "OSManager.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//----------------------- CSpoofLog start -----------------------
CSpoofBase::CSpoofLog* CSpoofBase::m_Log=NULL;

CSpoofBase::CSpoofLog::CSpoofLog()
{
}

CSpoofBase::CSpoofLog::~CSpoofLog()
{
}
//----------------------- CSpoofLog end -----------------------

BOOL CSpoofBase::m_bMultiThreaded=FALSE;
BOOL CSpoofBase::m_Initialized=FALSE;
int CSpoofBase::m_NumberOfThreads=0;
CGenericCriticalSection* CSpoofBase::m_pCSection=NULL;

CSpoofBase::CSpoofBase() : m_lpClassName(NULL),
						   m_LocalLog(NULL)
{
	try
	{
		//Set it
		SetName("CSpoofBase");
	}
	ERROR_HANDLER("CSpoofBase")
}

CSpoofBase::~CSpoofBase()
{
	try
	{
		//Dispose of the name
		free(m_lpClassName);
	}
	ERROR_HANDLER("~CSpoofBase")
}

void CSpoofBase::SetLastError(LPCSTR lpMethod) const
{
	try
	{
#ifdef WIN32
		//First set the error
		m_LastError=WSAGetLastError();
#else
		m_LastError=errno();
#endif

		//Check if there is an error
		if (m_LastError)
			ReportError(m_lpClassName,m_LastError);
	}
	ERROR_HANDLER("SetLastError")
}

void CSpoofBase::SetLastError(LPCSTR lpMethod,int iErrorCode) const
{
	try
	{
		//First set the error
		m_LastError=iErrorCode;

		//Check if there is an error
		if (m_LastError)
			ReportError(m_lpClassName,m_LastError);
	}
	ERROR_HANDLER("SetLastError")
}

void CSpoofBase::SetName(LPCSTR lpName) const
{
	try
	{
		//if exists dispose of it
		if (m_lpClassName)
			free(m_lpClassName);

		m_lpClassName=strdup(lpName);
	}
	ERROR_HANDLER("SetName")
}

void CSpoofBase::ReportError(LPCSTR lpMethod,int iErrorCode) const
{
	if (!GetLog())
		return;

	try
	{
		//Get the log
		CSpoofLog* pLog;
		pLog=GetLog();

		//Report to the log
		pLog->ReportSocketError(m_lpClassName,lpMethod,iErrorCode);
	}
	catch (...)
	{
		//Can't do anything to avoid circular catch
	}
}

void CSpoofBase::ReportError(LPCSTR lpMethod, LPCSTR lpMessage) const
{
	if (!GetLog())
		return;

	try
	{
		CSpoofLog* pLog;
		pLog=GetLog();

		//Report to the log
		pLog->ReportInitiatedError(m_lpClassName,lpMethod,lpMessage);
	}
	catch (...)
	{
		//Can't do anything to avoid circular catch
	}
}

int CSpoofBase::GetLastError() const
{
	return m_LastError;
}

BOOL CSpoofBase::InitializeSockets(BOOL bMultiThreaded,int iNumberOfThreads)
{
	//To avoid double initialize
	if (m_Initialized)
		return TRUE;

	try
	{
#ifdef WIN32
		//Initialize the sockets
		WORD wVersionRequested;
		WSADATA wsaData;
		int err;
 
		wVersionRequested = MAKEWORD( 2, 2 );
 
		err = WSAStartup( wVersionRequested, &wsaData );
		if (err!=0)
			/* Tell the user that we could not find a usable */
			/* WinSock DLL.                                  */
			return FALSE;
 
		/* Confirm that the WinSock DLL supports 2.2.*/
		/* Note that if the DLL supports versions greater    */
		/* than 2.2 in addition to 2.2, it will still return */
		/* 2.2 in wVersion since that is the version we      */
		/* requested.                                        */
 
		if (LOBYTE(wsaData.wVersion)!=2 || HIBYTE(wsaData.wVersion)!=2)
		{
			/* Tell the user that we could not find a usable */
			/* WinSock DLL.                                  */
			WSACleanup();
			return FALSE;
		}

#endif
		//Save the threading information
		m_bMultiThreaded=bMultiThreaded;
		m_NumberOfThreads=iNumberOfThreads;

		//Create the critical section
		m_pCSection=COSManager::CreateCriticalSection();

		//And we are initialized
		m_Initialized=TRUE;

		return TRUE;
	}
	catch (...)
	{
		return FALSE;
	}
}

BOOL CSpoofBase::ShutdownSockets()
{
	//Only if initialized
	if (!m_Initialized)
		return TRUE;

	try
	{
		delete m_pCSection;

		//Notify shutdown class
		if (m_pShutdownClass)
		{
			m_pShutdownClass->NotifyShutdown();
			delete m_pShutdownClass;
		}

#ifdef WIN32
		if (WSACleanup()==SOCKET_ERROR)
			return FALSE;
#endif

		m_Initialized=FALSE;
		return TRUE;
	}
	catch (...)
	{
		return FALSE;
	}
}

void CSpoofBase::NotifyShutdown()
{
}

void CSpoofBase::RegisterShutdown(CSpoofBase* pBase)
{
	try
	{
		//Check if we already have a class
		if (m_pShutdownClass)
			delete m_pShutdownClass;

		m_pShutdownClass=pBase;
	}
	ERROR_HANDLER("RegisterShutdown")
}


CSpoofBase* CSpoofBase::m_pShutdownClass=NULL;

void CSpoofBase::SetLog(CSpoofLog *pLog)
{
	//Save the new log
	m_Log=pLog;
}

void CSpoofBase::ReportError(LPCSTR lpMethod) const
{
	if (!GetLog())
		return;

	try
	{
#ifdef WIN32
		//Unknown error
		LPVOID lpMsgBuf;

		FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			::GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL);

		//Report the error
		//Get the log
		GetLog()->ReportCatchError(m_lpClassName,lpMethod,(LPSTR)lpMsgBuf);

		//Free the resources
		LocalFree(lpMsgBuf);
#else
		GetLog()->ReportCatchError(m_lpClassName,lpMethod,"Unknown error!");
#endif
	}
	catch (...)
	{
	}
}

char FAR * CSpoofBase::LongToString(long lAddr)
{
	try
	{
		//Enter the critical section
		m_pCSection->Enter();

		//First create the address
		in_addr addr;

		//Assign it
		addr.S_un.S_addr=lAddr;

		//Return the value
		char FAR * pAddr;
		pAddr=inet_ntoa(addr);

		//Exit the critical section
		m_pCSection->Exit();

		return pAddr;
	}
	ERROR_HANDLER_STATIC("CSpoofBase","LongToString")
	
	//Exit the critical section
	m_pCSection->Exit();

	return NULL;
}


CSpoofBase::CSpoofLog* CSpoofBase::GetLog() const
{
	try
	{
		if (m_LocalLog)
			return m_LocalLog;
		else
			return m_Log;
	}
	catch (...)
	{
		return NULL;
	}
}

void CSpoofBase::SetLocalLog(CSpoofLog *pLog)
{
	m_LocalLog=pLog;
}

BOOL CSpoofBase::IsMultiThreaded()
{
	return m_bMultiThreaded;
}

int CSpoofBase::GetNumberOfThreads()
{
	return m_NumberOfThreads;
}

void CSpoofBase::ReportStaticError(LPCSTR lpClass,LPCSTR lpMethod)
{
	if (!m_Log)
		return;

	try
	{
#ifdef WIN32
		//Unknown error
		LPVOID lpMsgBuf;

		FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			::GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL);

		//Report the error
		m_Log->ReportCatchError(lpClass,lpMethod,(LPSTR)lpMsgBuf);

		//Free the resources
		LocalFree(lpMsgBuf);
#else
		m_Log->ReportCatchError(lpClass,lpMethod,"Unknown error!");
#endif
	}
	catch (...)
	{
	}
}

void CSpoofBase::ReportStaticError(LPCSTR lpClass,LPCSTR lpMethod,LPCSTR lpMessage)
{
	if (m_Log)
		return;

	try
	{
		//Report to the log
		m_Log->ReportInitiatedError(lpClass,lpMethod,lpMessage);
	}
	catch (...)
	{
		//Can't do anything to avoid circular catch
	}
}

BOOL CSpoofBase::IsInitialized()
{
	return m_Initialized;
}
