/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#if !defined(AFX_SOCKETTHREADMANAGER_H__74FE76EA_CB87_4F58_8F81_AA23A971A332__INCLUDED_)
#define AFX_SOCKETTHREADMANAGER_H__74FE76EA_CB87_4F58_8F81_AA23A971A332__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SpoofBase.h"
#include "GenericCriticalSection.h"
#include "GenericThread.h"

class CSocketThreadManager : public CSpoofBase  
{
public:
	//Less socket in the system
	void DecreaseSocketCount(HWND hWindowHandle,BOOL bFreeze=FALSE);

	//Get the window handle
	HWND GetWindowHandle();

	//ctor and dtor
	CSocketThreadManager(int iThreadCount,HINSTANCE hInstance);
	virtual ~CSocketThreadManager();
private:
	//Delete the thread structure
	void CleanThreads();

	//Get the socket array position by the window handle
	int GetIndexByHWND(HWND hHandle) const;
	
	//Get the freeiest thread
	int GetMostAvailableThread() const;

	//Our thread function
	static DWORD SocketThread(LPVOID lpParameter);

	//Spawn the threads
	void SpawnThreads();

	//Our thread data
	typedef struct _ThreadData
	{
		HWND			hWindowHandle;
		int				iSocketCount;
		BOOL			bFreeze;
		CGenericThread*	pThread;
		HINSTANCE		hInstance;
		HANDLE			hEvent;
	} ThreadData;

	//Our thread count
	int m_iThreadCount;

	//Our windows struct
	ThreadData* m_pThreadData;

	//Our instance
	HINSTANCE m_hInstance;

	//Our critical section
	CGenericCriticalSection* m_pCSection;
};

#endif // !defined(AFX_SOCKETTHREADMANAGER_H__74FE76EA_CB87_4F58_8F81_AA23A971A332__INCLUDED_)
