// PacketCrafterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PacketCrafter.h"
#include "PacketCrafterDlg.h"
#include "..\TCPCrafter.h"
#include "UDPDialog.h"
#include "TCPDialog.h"
#include "..\UDPCrafter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPacketCrafterDlg dialog

CPacketCrafterDlg::CPacketCrafterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPacketCrafterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPacketCrafterDlg)
	m_DefaultIdentification = TRUE;
	m_DefaultSize = TRUE;
	m_FragmentationType = 0;
	m_HeaderSize = 20;
	m_Identification = 0;
	m_TTL = 255;
	m_TypeOfService = 0;
	m_SourcePort = 0;
	m_DestinationPort = 0;
	m_CheckSum = 0;
	m_DefaultChecksum = TRUE;
	m_Offset = 0;
	m_DataSize = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPacketCrafterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPacketCrafterDlg)
	DDX_Control(pDX, IDC_HYPERLINK, m_HyperLink);
	DDX_Control(pDX, IDC_ToAddress, m_ToAddress);
	DDX_Control(pDX, IDC_FromAddress, m_FromAddress);
	DDX_Check(pDX, IDC_DefaultIndentification, m_DefaultIdentification);
	DDX_Check(pDX, IDC_DefaultSize, m_DefaultSize);
	DDX_CBIndex(pDX, IDC_FragmentationType, m_FragmentationType);
	DDX_Text(pDX, IDC_HeaderSize, m_HeaderSize);
	DDV_MinMaxByte(pDX, m_HeaderSize, 20, 64);
	DDX_Text(pDX, IDC_Identification, m_Identification);
	DDX_Text(pDX, IDC_TTL, m_TTL);
	DDV_MinMaxByte(pDX, m_TTL, 0, 255);
	DDX_CBIndex(pDX, IDC_TypeOfService, m_TypeOfService);
	DDX_Text(pDX, IDC_SourcePort, m_SourcePort);
	DDV_MinMaxUInt(pDX, m_SourcePort, 0, 65535);
	DDX_Text(pDX, IDC_DestinationPort, m_DestinationPort);
	DDV_MinMaxUInt(pDX, m_DestinationPort, 0, 65535);
	DDX_Text(pDX, IDC_CheckSum, m_CheckSum);
	DDV_MinMaxUInt(pDX, m_CheckSum, 0, 65535);
	DDX_Check(pDX, IDC_DefaultChecksum, m_DefaultChecksum);
	DDX_Text(pDX, IDC_Offset, m_Offset);
	DDV_MinMaxUInt(pDX, m_Offset, 0, 16383);
	DDX_Text(pDX, IDC_DataSize, m_DataSize);
	DDV_MinMaxUInt(pDX, m_DataSize, 0, 64000);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPacketCrafterDlg, CDialog)
	//{{AFX_MSG_MAP(CPacketCrafterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_SEND_IP, OnSendIp)
	ON_BN_CLICKED(ID_SEND_UDP, OnSendUdp)
	ON_BN_CLICKED(ID_SEND_TCP, OnSendTcp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPacketCrafterDlg message handlers

BOOL CPacketCrafterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPacketCrafterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPacketCrafterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPacketCrafterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPacketCrafterDlg::OnSendIp() 
{
	//First resync
	UpdateData(TRUE);

	//Send only if valid
	if (CheckValidIP())
	{
		//OK construct our packet
		CTCPCrafter* pCrafter;
		pCrafter=new CTCPCrafter;

		//Set the crafter parameters
		SetIPCrafter(pCrafter);

		//Send it
		SendIP(pCrafter);

		//Delete the crafter
		delete pCrafter;
	}
}

BOOL CPacketCrafterDlg::CheckValidIP()
{
	BOOL bOK;
	bOK=FALSE;

	if (!IPCtrlToSTR(&m_FromAddress))
		MessageBox("Please enter a valid source address!");
	else if (!IPCtrlToSTR(&m_ToAddress))
		MessageBox("Please enter a valid destination address!");
	else if (m_TypeOfService==-1)
		MessageBox("Please enter a valid type of service!");
	else if (m_FragmentationType==-1)
		MessageBox("Please enter a valid fragmentation size!");
	else
		bOK=TRUE;

	return bOK;
}

LPSTR CPacketCrafterDlg::IPCtrlToSTR(CIPAddressCtrl* ctrl)
{
	//Converts the control address to textual address
	//Convert bytes to string
	BYTE bOctet1;
	BYTE bOctet2;
	BYTE bOctet3;
	BYTE bOctet4;

	//Get the value and blank values
	int iBlank;
	iBlank=ctrl->GetAddress(bOctet1,bOctet2,bOctet3,bOctet4);

	if (iBlank!=4)
		//Not filled
		return NULL;
	else
	{
		in_addr iAddr;
		iAddr.S_un.S_un_b.s_b1=bOctet1;
		iAddr.S_un.S_un_b.s_b2=bOctet2;
		iAddr.S_un.S_un_b.s_b3=bOctet3;
		iAddr.S_un.S_un_b.s_b4=bOctet4;

		return inet_ntoa(iAddr);
	}
}

void CPacketCrafterDlg::SetIPCrafter(CIPCrafter *pCrafter)
{
	//Conversion from combo to fragmentation flags
	static const unsigned short ConvertFragFlag[4]={IpFragFlag_MAY_FRAG,IpFragFlag_MORE_FRAG,IpFragFlag_LAST_FRAG,IpFragFlag_DONT_FRAG};

	//Set the values
	pCrafter->SetDefault();

	//Check if we use default checksum
	pCrafter->SetUseDefaultChecksum(m_DefaultChecksum);

	//And do we need to set it
	if (!m_DefaultChecksum)
		pCrafter->SetChecksum(m_CheckSum);

	//Do we need to set the header size
	if (!m_DefaultSize)
		pCrafter->SetHeaderLength(m_HeaderSize);

	//Set the type of service
	pCrafter->SetTypeOfService(m_TypeOfService);

	//Set the fragmentation flag
	pCrafter->SetFragmentationFlags(ConvertFragFlag[m_FragmentationType] | m_Offset/8);
}

void CPacketCrafterDlg::SendIP(CSpoofSocket *pSocket)
{
	//Set it as raw
	pSocket->SetRaw(TRUE);

	//Get the addresses
	LPSTR lpSourceAddress;
	lpSourceAddress=strdup(IPCtrlToSTR(&m_FromAddress));

	LPSTR lpDestinationAddress;
	lpDestinationAddress=strdup(IPCtrlToSTR(&m_ToAddress));

	//Set the source address
	pSocket->SetSourceAddress(lpSourceAddress);

	//Create it
	pSocket->Create(IPPROTO_IP);
	
	//Create a buffer to supplement the header size
	char* cTmp;
	cTmp=new char[44+m_DataSize];

	//set it with garbage
	memset(cTmp,255,44+m_DataSize);

	int iSendSize;

	//Calculate the needed size
	if (m_DefaultSize)
		iSendSize=0;
	else
		iSendSize=m_HeaderSize-IpHeaderLength;

	//And sent a packet
	pSocket->Send(lpDestinationAddress,cTmp,iSendSize+m_DataSize-m_Offset,m_DestinationPort);

	//Delete the buffer
	delete [] cTmp;

	//Releae the addresses
	free(lpDestinationAddress);
	free(lpSourceAddress);
}

void CPacketCrafterDlg::OnSendUdp() 
{
	//First validate the data
	//First resync
	UpdateData(TRUE);

	//Send only if valid
	if (CheckValidIP())
	{
		CUDPDialog dlg(this);
	
		int nResponse = dlg.DoModal();
	}
}

void CPacketCrafterDlg::SendUDP(unsigned short usUDPChecksum,BOOL bDefaultUDPChecksum)
{
	//OK construct our packet
	CUDPCrafter* pCrafter;
	pCrafter=new CUDPCrafter;

	//Set the crafter parameters
	pCrafter->SetUDPChecksum(usUDPChecksum);
	pCrafter->SetUDPUseDefaultChecksum(bDefaultUDPChecksum);

	//Set the crafter parameters
	SetIPCrafter(pCrafter);

	//Set it as raw
	pCrafter->SetRaw(TRUE);

	//Get the addresses
	LPSTR lpSourceAddress;
	lpSourceAddress=strdup(IPCtrlToSTR(&m_FromAddress));

	LPSTR lpDestinationAddress;
	lpDestinationAddress=strdup(IPCtrlToSTR(&m_ToAddress));

	//Set the source address
	pCrafter->SetSourceAddress(lpSourceAddress);

	//Create it
	pCrafter->Create();
	
	//Create a buffer to supplement the header size
	char* cTmp;
	cTmp=new char[m_DataSize];

	//set it with garbage
	memset(cTmp,255,m_DataSize);

	//And sent a packet
	pCrafter->Send(m_SourcePort,lpDestinationAddress,m_DestinationPort,cTmp,m_DataSize);

	//Delete the buffer
	delete [] cTmp;

	//Releae the addresses
	free(lpDestinationAddress);
	free(lpSourceAddress);

	//Delete the crafter
	delete pCrafter;
}

void CPacketCrafterDlg::OnSendTcp() 
{
	//First validate the data
	//First resync
	UpdateData(TRUE);

	//Send only if valid
	if (CheckValidIP())
	{
		CTCPDialog dlg(this);
	
		int nResponse = dlg.DoModal();
	}
}

void CPacketCrafterDlg::SendTCP(unsigned char ucFlags,
								DWORD Acknowledge,
								DWORD Sequence,
								BYTE Offset,
								UINT Urgent,
								unsigned short usWindow,
								BOOL bDefaultChecksum,
			 					unsigned short usChecksum)
{
	//OK construct our packet
	CTCPCrafter* pCrafter;
	pCrafter=new CTCPCrafter;

	//Set the crafter parameters
	pCrafter->SetFlags(ucFlags);
	pCrafter->SetAcknowledgeNumber(Acknowledge);
	pCrafter->SetTCPUseDefaultChecksum(bDefaultChecksum);
	pCrafter->SetTCPChecksum(usChecksum);
	pCrafter->SetSequenceNumber(Sequence);
	pCrafter->SetDataOffset(Offset);
	pCrafter->SetUrgentPointer(Urgent);
	pCrafter->SetWindow(usWindow);

	//Set the crafter parameters
	SetIPCrafter(pCrafter);

	//Set it as raw
	pCrafter->SetRaw(TRUE);

	//Get the addresses
	LPSTR lpSourceAddress;
	lpSourceAddress=strdup(IPCtrlToSTR(&m_FromAddress));

	LPSTR lpDestinationAddress;
	lpDestinationAddress=strdup(IPCtrlToSTR(&m_ToAddress));

	//Set the source address
	pCrafter->SetSourceAddress(lpSourceAddress);

	//Create it
	pCrafter->Create();
	
	//Create a buffer to supplement the header size
	char* cTmp;
	cTmp=new char[m_DataSize];

	//set it with garbage
	memset(cTmp,255,m_DataSize);

	//And sent a packet
	pCrafter->SendRaw(m_SourcePort,lpDestinationAddress,m_DestinationPort,cTmp,m_DataSize);

	//Delete the buffer
	delete [] cTmp;

	//Releae the addresses
	free(lpDestinationAddress);
	free(lpSourceAddress);

	//Delete the crafter
	delete pCrafter;
}
