/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#if !defined(AFX_IPCRAFTER_H__F0489B68_2C15_400C_AB57_03B439B93500__INCLUDED_)
#define AFX_IPCRAFTER_H__F0489B68_2C15_400C_AB57_03B439B93500__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SpoofBase.h"
#include "SpoofSocket.h"

#define IPCRAFTER_DEFAULT_HEADER_SIZE 255

class CIPCrafter : private CSpoofBase  
{
public:
	//Use default checksum or given checksum
	void SetUseDefaultChecksum(BOOL bDefault);

	//Set the default checksum
	void SetChecksum(unsigned short usChecksum);

	//Set the default data
	void SetDefault();

	//Set the type of service
	void SetTypeOfService(unsigned char ucTypeOfService);

	//Set the header length (255 for the correct size)
	void SetHeaderLength(unsigned char ucHeaderLength);

	//Set our indentification
	void SetIdentification(unsigned short usIdentification);

	//Set the fragmentation flags
	void SetFragmentationFlags(unsigned short usFragmentationFlags);

	//ctor and dtor
	CIPCrafter();
	virtual ~CIPCrafter();
protected:
	LPIpHeader ConstructCraftedIPHeader(unsigned char  ucProtocol,
								    	unsigned short usFragmentationFlags,
										unsigned char  ucTTL,
										unsigned short usIdentification,
										unsigned char  ucHeaderLength);

	//Our crafted members
	unsigned short m_usFragmentationFlags;
	unsigned short m_usIdentification;
    unsigned char  m_ucHeaderLength;
	unsigned char  m_ucTypeOfService;

	//Checksum flag
	unsigned short m_usChecksum;
	BOOL m_DefaultChecksum;
};

#endif // !defined(AFX_IPCRAFTER_H__F0489B68_2C15_400C_AB57_03B439B93500__INCLUDED_)
