/*
 *
 *
 *  Copyright (c) 2000 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Contact info:
 * Site: http://www.komodia.com
 * Email: barak@komodia.com
 */

#include "stdafx.h"
#include "IPCrafter.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define CIPCrafter_Class "CIPCrafter"

CIPCrafter::CIPCrafter() : CSpoofBase()
{
	try
	{
		//Set our name
		SetName(CIPCrafter_Class);

		//Set the default data
		SetDefault();
	}
	ERROR_HANDLER("CIPCrafter")
}

CIPCrafter::~CIPCrafter()
{

}

void CIPCrafter::SetFragmentationFlags(unsigned short usFragmentationFlags)
{
	m_usFragmentationFlags=htons(usFragmentationFlags);
}

void CIPCrafter::SetIdentification(unsigned short usIdentification)
{
	m_usIdentification=htons(usIdentification);
}

void CIPCrafter::SetHeaderLength(unsigned char ucHeaderLength)
{
	m_ucHeaderLength=ucHeaderLength;
}

void CIPCrafter::SetTypeOfService(unsigned char ucTypeOfService)
{
	m_ucTypeOfService=ucTypeOfService;
}

void CIPCrafter::SetDefault()
{
	try
	{
		m_usFragmentationFlags=IpFragFlag_DONT_FRAG;
		m_usIdentification=(unsigned short)GetCurrentProcessId();
		m_ucHeaderLength=IPCRAFTER_DEFAULT_HEADER_SIZE; //Default size
		m_ucTypeOfService=IpService_ROUTINE;

		//Default checksum used
		m_DefaultChecksum=TRUE;
	}
	ERROR_HANDLER("SetDefault")
}

void CIPCrafter::SetChecksum(unsigned short usChecksum)
{
	m_usChecksum=usChecksum;
}

void CIPCrafter::SetUseDefaultChecksum(BOOL bDefault)
{
	m_DefaultChecksum=bDefault;
}

LPIpHeader CIPCrafter::ConstructCraftedIPHeader(unsigned char  ucProtocol,
								    			unsigned short usFragmentationFlags,
												unsigned char  ucTTL,
												unsigned short usIdentification,
												unsigned char  ucHeaderLength)
{
	try
	{
		//Get the original header
		LPIpHeader lpHead;

		//Check what header length to pass
		unsigned char ucLength;

		if (m_ucHeaderLength==IPCRAFTER_DEFAULT_HEADER_SIZE)
			ucLength=ucHeaderLength;
		else
			ucLength=m_ucHeaderLength;

		//Get the header
		lpHead=CSpoofSocket::ConstructStaticIPHeader(ucProtocol,m_usFragmentationFlags,ucTTL,m_usIdentification,ucLength);

		//Check we have it
		if (lpHead)
			//Set the type of service
			//Precedence
			lpHead->TypeOfService=m_ucTypeOfService;

		return lpHead;
	}
	ERROR_HANDLER_RETURN("ConstructCraftedIPHeader",NULL)
}
