//---------------------------------------------------------------
// Services.js: Object Web JavaScript
//
// Copyright (C) 1998-2001 Starbase Corporation.
// All rights reserved.
//---------------------------------------------------------------
// I M P O R T A N T   N O T I C E
//
// Do not modify this file directly.  This file is automatically
// generated from the stdjava.afg AFG template.  If you
// wish to customize this file, edit the AFG template.  This file
// will be updated the next time you update the web site.
//---------------------------------------------------------------
//---------------------------------------------------------------
// fileName()
//
// Replaces illegal filename characters in the input path with
// the default fill character.  NOTE:  This function is *not*
// aware of the URLFiller option in the [HTML Options] section
// of a profile.  If you use a different URLFiller than
// '~', you will need to change this function accordingly.
//---------------------------------------------------------------
function fileName(inputName)
{
	var tempFileName = "";
	for (var i=0; i < inputName.length; i++)
	{
		switch(inputName.charAt(i))
		{
			case ':':
			case '<':
			case '>':
				tempFileName += '~';
				break;
			default:
				tempFileName += inputName.charAt(i);
		}
	}
	return tempFileName;
}

//---------------------------------------------------------------
// onKeyDownOverride()
//---------------------------------------------------------------
function onKeyDownOverride(Event_)
{
	if (parent.g_IsIE)
		return parent._ControlFrame.window.doKeyDownOverride(window.event.ctrlKey, window.event.keyCode, 1);

	return parent._ControlFrame.window.doKeyDownOverride(Event_.modifiers & Event.CTRL_MASK, evnt.which, 1);
}

//---------------------------------------------------------------
// MemberInfo()
//---------------------------------------------------------------
function MemberInfo(Name_, File_)
{
	this.m_Name = Name_;
	this.m_File = File_;
}

//---------------------------------------------------------------
// ParseLinkTarget()
//---------------------------------------------------------------
function IsIdent(c_)
{
	return ('A' <= c_ && c_ <= 'Z') || ('a' <= c_ && c_ <= 'z') || (c_=='_') || (c_=='$');
}


function ParseLinkTarget(Target_)
{
	// Extract bookmark.
	var Bookmark = "";
	var iBookmark = Target_.indexOf("##");
	if (iBookmark != -1)
	{
		Bookmark = Target_.substr(iBookmark+2);
		Target_ = Target_.substring(0, iBookmark);
	}

	// Extract member.
	var Member = "";
	var iMember = Target_.indexOf("::");
	if (iMember != -1)
	{
		Member = Target_.substr(iMember+2);
		Target_ = Target_.substring(0, iMember);
	}
	else
	{
		iMember = Target_.indexOf("#");
		if (iMember != -1)
		{
			Member = Target_.substr(iMember+1);
			Target_ = Target_.substring(0, iMember);
		}
	}

	// Extract Class and Guid.
	var Class = Target_;
	var Guid = ""
	if (Class != "")
	{
		if (Guid == "" && Class.charAt(0) == '*')
		{
			Guid = Class;
			Class = ""
		}
		if (Member == "" && Class.charAt(0) == '@')
		{  
			Member = Class;
			Class = "";
		}
	}

	// Extract page name.
	var Page = "";
	if (Member != "" && Member.charAt(0) == '@')
	{
		Page = Member.substring(1);
		Member = "";

		if (Page == "Overview")
			Page = "Main";
	}

	// Convert operator names into cannonical form.
	if (Member.length > 8 && Member.indexOf("operator") == 0 && !IsIdent(Member.charAt(8)))
	{
		var tmp = Member.substring(8);
		var re = /\s/g;
		tmp = tmp.replace(re, "");

		if (tmp != "()")
		{
			if (tmp.substr(tmp.length-2) == "()")
				tmp = tmp.substr(0, tmp.length-2);
		}

		Member = "operator " + tmp;
	}
	else
	{
		var iParen = Member.indexOf("(");
		if (iParen != -1)
			Member = Member.substring(0, iParen);
		var iBracket = Member.indexOf("[");
		if (iBracket != -1)
			Member = Member.substring(0, iBracket);
	}

	// Store results in parent.
	parent.g_LinkObject   = Class;   
	parent.g_LinkGuid	  = Guid;
	parent.g_LinkMember   = Member;   
	parent.g_LinkPage     = Page;   
	parent.g_LinkBookmark = Bookmark;   
}

//---------------------------------------------------------------
// IsSpecialPage()
//---------------------------------------------------------------
function IsSpecialPage(name)
{
	var tempName = name.toLowerCase();
      
	if (tempName.indexOf("about")==0)
		return true;

	if (tempName.indexOf("home")==0)
		return true;

	if (tempName.indexOf("toplevelchartindex")==0)
		return true;

	if (tempName.indexOf("editfromtheweb")==0)
		return true;

	if (tempName.indexOf("editorsetup")==0)
		return true;
	
	if (tempName.indexOf("trialinfo")==0)
		return true;

	return false;
}

//---------------------------------------------------------------
// GetBookmark()
//---------------------------------------------------------------
function GetBookmark()
{
	if (parent.g_LinkBookmark == "")
		return "";

	var Bookmark = '#' + parent.g_LinkBookmark;
	parent.g_LinkBookmark = "";

	return Bookmark;
}

//---------------------------------------------------------------
// LinkObject()
//---------------------------------------------------------------
function LinkObject()
{
	if (parent.g_LinkObject == "")
		return false;

	var Object = parent.g_LinkObject;
	parent.g_LinkObject = "";

	var HRef = parent.location.href;
	HRef = HRef.substring(0, HRef.lastIndexOf('/'));
	parent._MainFrame.location.href = HRef + "/Links/" + fileName(Object) + ".htm";
	return true;
}

//---------------------------------------------------------------
// LinkMember()
//---------------------------------------------------------------
function LinkMember()
{
	if (parent.g_LinkMember == "")
		return false;

	if (parent.g_MemberList == null)
		return false;

	var Name = parent.g_LinkMember;
	parent.g_LinkMember = "";

	var MemberList = parent.g_MemberList;
	var iMember;

	for (iMember in MemberList)
	{
		var Info = MemberList[iMember];
		if (Info.m_Name == Name)
		{
			parent.g_LinkMember = "";

			var Href = fileName(Info.m_File) + ".htm" + GetBookmark();
			parent._MainFrame.location.href = Href;	
			return true;
		}
	}

	window.status = "Warning: member not found: " + Name;
	return false;
}

//---------------------------------------------------------------
// LinkPage()
//---------------------------------------------------------------
function LinkPage()
{
	if (parent.g_LinkPage == "")
		return false;

	var Page = parent.g_LinkPage;
	parent.g_LinkPage = "";

	var Href = fileName(Page) + ".htm" + GetBookmark();

	if (IsSpecialPage(Href))
	{
		var Root = parent.location.href;
		Root = Root.substring(0, Root.lastIndexOf('/'));
		Href = Root + "/Objects/" + Href;
	}

	parent._MainFrame.location.href = Href;
	return true;
}

//---------------------------------------------------------------
// LinkBookmark()
//---------------------------------------------------------------
function LinkBookmark(Doc_)
{
	if (parent.g_LinkBookmark == "")
		return false;

	Doc_.location.href = GetBookmark();
	return true;
}

//---------------------------------------------------------------
// Link()
//---------------------------------------------------------------
function Link(Doc_)
{
	if (LinkObject())
		return true;

	if (LinkMember() || LinkPage())
		return true;

	if (LinkBookmark(Doc_))
		return true;

	return false;
}

//---------------------------------------------------------------
// LinkTo()
//---------------------------------------------------------------
function LinkTo(Doc_, Target_)
{
	ParseLinkTarget(Target_);
	Link(Doc_);
}

//---------------------------------------------------------------
// x_al()
//---------------------------------------------------------------
function x_al()
{
	var Msg =
		"The \"Autolink\" feature automatically creates hyperlinks that let "+
		"you quickly navigate to objects used in aggregations, associations, parameter lists, "+
		"template arguments, local variables, even referenced in comments!\n\n"+

		"About half of these hyperlinks (including the one you just clicked) are disabled because "+
		"the web site was generated using Starbase trial software.  You can test this feature by "+
		"clicking on a different hyperlink.\n\n"+
		
		"Do you want more information about trial license limitations?";

	if (confirm(Msg))
	{
		var HRef = parent.location.href;
		HRef = HRef.substring(0, HRef.lastIndexOf('/'));
		parent._MainFrame.location.href = HRef + "/Objects/TrialInfo.htm#Limitations";
	}
}

//---------------------------------------------------------------
// x_ml()
//---------------------------------------------------------------
function x_ml()
{
	var Msg =
		"Each object has a \"Member Index\" that lets you quickly navigate the "+
		"object members without going back to a \"Class Members\" page.\n\n"+

		"About half of these hyperlinks (including the one you just clicked) are disabled because "+
		"the web site was generated using Starbase trial software.  You can test this feature by "+
		"clicking on a different hyperlink (the first six member index links are never disabled).\n\n"+
		
		"Do you want more information about trial license limitations?";

	if (confirm(Msg))
	{
		var HRef = parent.location.href;
		HRef = HRef.substring(0, HRef.lastIndexOf('/'));
		parent._MainFrame.location.href = HRef + "/Objects/TrialInfo.htm#Limitations";
	}
}
//---------------------------------------------------------------
// EditFromTheWebToolbar()
//---------------------------------------------------------------
function EditFromTheWebToolbar(
	document_,
	ToolbarClsID_,
	ToolbarCodebase_,
	ClassID_,
	DeclFile_,
	DefnFile_)
{
	if (!parent.g_bActiveX)
		return;

	with (document_)
	{
		writeln("<object ID='ToolBar'");
			writeln("classid='clsid:" + ToolbarClsID_ + "'");
			writeln("type='x-oleobject'");
			writeln("codebase='../../Controls/" + ToolbarCodebase_ + "'");
			writeln("width=105");
			writeln("height=30>");

		if (ClassID_ != 0)
			writeln("<param name='ClassID' value='" + ClassID_ + "'>");

		if (DeclFile_ != "")
			writeln("<param name='DeclFile' value='" + DeclFile_ + "'>");

		if (DefnFile_ != "")
			writeln("<param name='DefnFile' value='" + DefnFile_ + "'>");

		writeln("<embed name='ToolBar'");
		writeln("classid='clsid:" + ToolbarClsID_ + "'");
		writeln("type='x-oleobject'");
		writeln("codebase='../../Controls/" + ToolbarCodebase_ + "'");

		if (ClassID_ != 0)
			writeln("    param_ClassID='" + ClassID_ + "'");

		if (DeclFile_ != "")
			writeln("    param_DeclFile='" + DeclFile_ + "'");

		if (DefnFile_ != "")
			writeln("    param_DefnFile='" + DefnFile_ + "'");

		writeln(" width=105");
		writeln(" height=30");
		writeln(">");

		writeln("</object>");
	}
}

//---------------------------------------------------------------
// OnEnterListPage()
//---------------------------------------------------------------
function OnEnterListPage(Doc_, File_)
{
	// Override the 'Enter' key
    if (!parent.g_IsIE)
		document.captureEvents(Event.KeyDown);
    document.onkeydown=onKeyDownOverride;

	return true;
}

//---------------------------------------------------------------
// OnEnterObjectMainPage()
//---------------------------------------------------------------
function OnEnterObjectMainPage(Doc_)
{
	Link(Doc_);
	return true;
}

//---------------------------------------------------------------
// OnEnterMemberPage()
//---------------------------------------------------------------
function OnEnterMemberPage(Doc_, File_)
{
	Link(Doc_);
	return true;
}

//---------------------------------------------------------------
// OnEnterPage()
//---------------------------------------------------------------
function OnEnterPage(Doc_, File_, FrameFile_, Guid_)
{
	var FrameLoaded = parent.g_FrameLoaded;
	if (FrameLoaded == null)
	{
		var Href = FrameFile_ + '#';
		if (Guid_ != "")
		{
			Href += '*' + Guid_;
		}
		Href += '@' + File_;
		window.location =  Href;
		return true;
	}

	// Dispatch to specific page handlers.
	if (File_.indexOf("Main") == 0)
	{
		return OnEnterObjectMainPage(Doc_);
	}

	if (File_.indexOf("List") == 0)
	{
		return OnEnterListPage(Doc_, File_);
	}

	if (File_.indexOf("Fn",         File_) == 0 ||
		File_.indexOf("Dat",        File_) == 0 ||
		File_.indexOf("Custom",     File_) == 0 ||
		File_.indexOf("History",    File_) == 0 ||
		File_.indexOf("Hierarchy",  File_) == 0 ||
		File_.indexOf("SampleCode", File_) == 0 )
	{
		return OnEnterMemberPage(Doc_, File_);
	}

	Link(Doc_);
	return true;
}
