#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <windows.h>

typedef struct DirNode
                 {
                   char           strFileName [MAX_PATH];
                   DWORD          dwAttributes;
                   struct DirNode *pNext;
                 } *DirNodePtr;

typedef struct DirectoryNode
                 {
                   char                 *strFileName;
                   struct DirectoryNode *pNext;
                 } *DirectoryNodePtr;

static void BuildDirectory(char *,DirectoryNodePtr *);
static void CheckFileForASCII(int *,int,char *,char *,int *);
static void CheckFileForBinary(int *,int,char *,unsigned char *,int *);
static void CheckFileForUnicode(int *,int,char *,char *,int *);
static void CheckFile(char *,char *,unsigned char *);
static void GetDir(char *,DirNodePtr *);
static int  HexToByte(char *,unsigned char *);
static int  HexToHalfByte(char,unsigned char *);
       int  main(int,char **);

int bFatalError;

int main(
  int  argc,
  char **argv)
    {
      static int              nArg;
      static DirectoryNodePtr pDirectory;
      static DirectoryNodePtr pDirectoryHead;
      static unsigned char    ucHex [6];

      bFatalError=FALSE;
      if ((argc >= 3)
      &&  (strlen(*(argv+1)) == 12)
      &&  (HexToByte(*(argv+1),&ucHex[0])))
        {
          for (nArg=2; ((! bFatalError) && (nArg < argc)); ++nArg)
            {
              pDirectoryHead=NULL;
              BuildDirectory(*(argv+nArg),&pDirectoryHead);
              while (pDirectoryHead != NULL)
                {
                  if (! bFatalError)
                    CheckFile(pDirectoryHead->strFileName,*(argv+1),&ucHex[0]);
                  pDirectory=pDirectoryHead;
                  pDirectoryHead=pDirectoryHead->pNext;
                  free((char *) pDirectory);
                }
            }
        }
      else
        {
          fprintf(stderr,
           "\nfindadap finds the files in the specified directories and their\n"
           "     subdirectories containing the specified MAC address encoded\n"
           "     as binary, ASCII, or Unicode.\n\n"
           "   Usage:  findadap <MAC-address> <starting-directory> "
           "[<starting-directory>]\n\n"
           "     The MAC address must be specified as 12 hexadecimal "
           "\"digits\".\n\n"
           "Examples:  findadap 0020afba56f8 C: E:\n"
           "           findadap 0020afba56f8 .\n"
           "           findadap 0020afba56f8 \"C:\\My Documents\"\n\n");
          bFatalError=TRUE;
        }
      return bFatalError;
    }

static int HexToHalfByte(
  char          cHex,
  unsigned char *ucByte)
    {
      register int bSuccess;

      bSuccess=TRUE;
      if ((cHex >= '0') && (cHex <= '9'))
        *ucByte=(unsigned char) (cHex-'0');
      else 
        if ((cHex >= 'a') && (cHex <= 'f'))
          *ucByte=(unsigned char) (cHex-'a'+0xa);
        else
          if ((cHex >= 'A') && (cHex <= 'F'))
            *ucByte=(unsigned char) (cHex-'A'+0xa);
          else
            {
              *ucByte=(unsigned char) '\0';
              bSuccess=FALSE;
            }
      return bSuccess;
    }


static int HexToByte(
  char          *strTarget,
  unsigned char *ucHex)
    {
      register int           bSuccess;
      static   unsigned char ucHalfByte;

      bSuccess=TRUE;
      while ((bSuccess) && (*strTarget))
        if (bSuccess=HexToHalfByte(*strTarget++,&ucHalfByte))
          {
            *ucHex=(unsigned char) (ucHalfByte << 4);
            if (bSuccess=HexToHalfByte(*strTarget++,&ucHalfByte))
              {
                *ucHex+=ucHalfByte;
                ++ucHex;
              }
          }
      return bSuccess;
    }

static void BuildDirectory(
  char             *strPathName,
  DirectoryNodePtr *pDirectoryHead)
    {
      char             *pChar;
      DirNodePtr       pDir;
      DirNodePtr       pDirHead;
      DirectoryNodePtr pNewDirectory;
      char             strDirName[1024];
      char             strNewPathName[1024];

      strcpy(strDirName,strPathName);
      strcat(strDirName,"\\*.*");
      pDirHead=NULL;
      GetDir(strDirName,&pDirHead);
      if (! bFatalError)
        {
          while (pDirHead != NULL)
            {
              if (pDirHead->strFileName[0] != '.')
                {
                  strcpy(strNewPathName,strPathName);
                  strcat(strNewPathName,"\\");
                  strcat(strNewPathName,pDirHead->strFileName);
                  if ((pDirHead->dwAttributes) & FILE_ATTRIBUTE_DIRECTORY)
                    BuildDirectory(strNewPathName,pDirectoryHead);
                  else
                    {
                      pChar=pDirHead->strFileName;
                      if (*pDirectoryHead == NULL)
                        {
                          if ((*pDirectoryHead
                           =(struct DirectoryNode *)
                           malloc((unsigned) sizeof(struct DirectoryNode)))
                           == NULL)
                            {
                              bFatalError=TRUE;
                              fprintf(stderr,"Fatal error:  out of memory.\n");
                            }
                          else
                            {
                              (*pDirectoryHead)->pNext=NULL;
                              if (((*pDirectoryHead)->strFileName
                               =malloc((unsigned) (1+strlen(strNewPathName))))
                               == NULL)
                                {
                                  bFatalError=TRUE;
                                  fprintf(stderr,
                                   "Fatal error:  out of memory.\n");
                                }
                              else
                                strcpy((*pDirectoryHead)->strFileName,
                                 strNewPathName);
                            }
                        }
                      else
                        {
                          if ((pNewDirectory=(struct DirectoryNode *)
                           malloc((unsigned) sizeof(struct DirectoryNode)))
                           == NULL)
                            {
                              bFatalError=TRUE;
                              fprintf(stderr,"Fatal error:  out of memory.\n");
                            }
                          else
                            {
                              pNewDirectory->pNext=(*pDirectoryHead);
                              (*pDirectoryHead)=pNewDirectory;
                              if ((pNewDirectory->strFileName
                               =malloc((unsigned) (1+strlen(strNewPathName))))
                               == NULL)
                                {
                                  bFatalError=TRUE;
                                  fprintf(stderr,
                                   "Fatal error:  out of memory.\n");
                                }
                              else
                                strcpy(pNewDirectory->strFileName,
                                 strNewPathName);
                            }
                        }
                    }
                }
              pDir=pDirHead;
              pDirHead=pDirHead->pNext;
              free((char *) pDir);
            }
        }
    }

static void GetDir(
  char far   *strDirName,
  DirNodePtr *pDirHead)
    {
      static DirNodePtr      pNewDir;
      static HANDLE          hDir;
      static WIN32_FIND_DATA fdDirResult;

      if ((hDir=FindFirstFile(strDirName,&fdDirResult)) 
       != INVALID_HANDLE_VALUE)
        {
          do
            {
              if (*pDirHead == NULL)
                {
                  if ((*pDirHead
                   =(struct DirNode *)
                   malloc((unsigned) sizeof(struct DirNode))) == NULL)
                    {
                      bFatalError=TRUE;
                      fprintf(stderr,"Fatal error:  out of memory.\n");
                    }
                  else
                    {
                      (*pDirHead)->pNext=NULL;
                      strcpy((*pDirHead)->strFileName,fdDirResult.cFileName);
                      (*pDirHead)->dwAttributes=fdDirResult.dwFileAttributes;
                    }
                }
              else
                {
                  if ((pNewDir=(struct DirNode *)
                   malloc((unsigned) sizeof(struct DirNode))) == NULL)
                    {
                      bFatalError=TRUE;
                      fprintf(stderr,"Fatal error:  out of memory.\n");
                    }
                  else
                    {
                      strcpy(pNewDir->strFileName,fdDirResult.cFileName);
                      pNewDir->dwAttributes=fdDirResult.dwFileAttributes;
                      pNewDir->pNext=(*pDirHead);
                      (*pDirHead)=pNewDir;
                    }
                }
            }
          while (FindNextFile(hDir,&fdDirResult));
          FindClose(hDir);
        }
      return;
    }

static void CheckFileForASCII(
  int           *pCircularBufferHead,
  int           nStartingByteNum,
  char          *strFileName,
  char          *strTarget,
  int           *bFound)
    {
      register int  nByteNum;
      static   int  nOffset;
      static   int  *pByte;
      static   char *pTarget;

      *bFound=TRUE;
      nOffset=nStartingByteNum;
      pByte=pCircularBufferHead+nOffset;
      pTarget=strTarget;
      for (nByteNum=12; ((*bFound) && (nByteNum--));)
        {
          *bFound=(*pByte == (int) *pTarget++);
          if (++nOffset < 24)
            ++pByte;
          else
            {
              nOffset=0;
              pByte=pCircularBufferHead;
            }
        }
      if (*bFound)
        printf("ASCII   %s\n",strFileName);
      return;
    }

static void CheckFileForUnicode(
  int           *pCircularBufferHead,
  int           nStartingByteNum,
  char          *strFileName,
  char          *strTarget,
  int           *bFound)
    {
      register int  bOdd;
      register int  nByteNum;
      static   int  nOffset;
      static   int  *pByte;
      static   char *pTarget;

      *bFound=TRUE;
      bOdd=TRUE;
      nOffset=nStartingByteNum;
      pByte=pCircularBufferHead+nOffset;
      pTarget=strTarget;
      for (nByteNum=24; ((*bFound) && (nByteNum--));)
        {
          if (bOdd)
            *bFound=(*pByte == (int) *pTarget++);
          else
            *bFound=(*pByte == 0);
          if (++nOffset < 24)
            ++pByte;
          else
            {
              nOffset=0;
              pByte=pCircularBufferHead;
            }
          bOdd=! bOdd;
        }
      if (*bFound)
        printf("UNICODE %s\n",strFileName);
      return;
    }

static void CheckFileForBinary(
  int           *pCircularBufferHead,
  int           nStartingByteNum,
  char          *strFileName,
  unsigned char *ucHex,
  int           *bFound)
    {
      register int  nByteNum;
      static   int  nOffset;
      static   int  *pByte;
      static   char *pTarget;

      *bFound=TRUE;
      nOffset=nStartingByteNum;
      pByte=pCircularBufferHead+nOffset;
      for (nByteNum=6; ((*bFound) && (nByteNum--));)
        {
          *bFound=(*pByte == (int) *ucHex++);
          if (++nOffset < 24)
            ++pByte;
          else
            {
              nOffset=0;
              pByte=pCircularBufferHead;
            }
        }
      if (*bFound)
        printf("BINARY  %s\n",strFileName);
      return;
    }

static void CheckFile(
 char          *strFileName,
 char          *strTarget,
 unsigned char *ucHex)
  {
    static   int  bASCIIFound;
    static   int  bBinaryFound;
    static   int  bUnicodeFound;
             FILE *i;
    register int  nByteNum;
    register int  nCharNum;
    static   int  nCurrentChar;
    static   int  nLast24Bytes [24];

    bASCIIFound=FALSE;
    bBinaryFound=FALSE;
    bUnicodeFound=FALSE;
    if ((i=fopen(strFileName,"rb")) != NULL)
      {
        nByteNum=0;
        while (((nLast24Bytes[nByteNum]=fgetc(i)) != EOF)
        &&     (++nByteNum < 24));
        if (nByteNum >= 24)
          {
            nByteNum=0;
            do
              {
                if (! bUnicodeFound)
                  CheckFileForUnicode(&nLast24Bytes[0],nByteNum,
                   strFileName,strTarget,&bUnicodeFound);
                if (! bASCIIFound)
                  CheckFileForASCII(&nLast24Bytes[0],nByteNum,
                   strFileName,strTarget,&bASCIIFound);
                if (! bBinaryFound)
                  CheckFileForBinary(&nLast24Bytes[0],nByteNum,
                   strFileName,ucHex,&bBinaryFound);
                nCurrentChar=fgetc(i);
                if (nCurrentChar != EOF)
                  {
                    nLast24Bytes[nByteNum]=nCurrentChar;
                    if (++nByteNum >= 24)
                      nByteNum=0;
                  }
              }
            while ((! bFatalError)
            &&     (nCurrentChar != EOF)
            &&     ((! bASCIIFound) || (! bBinaryFound) || (! bUnicodeFound)));
          }
        else
          {
            while (nByteNum < 24)
              nLast24Bytes[nByteNum++]=-1;
            nByteNum=0;
            if (! bASCIIFound)
              CheckFileForASCII(&nLast24Bytes[0],nByteNum,
               strFileName,strTarget,&bASCIIFound);
            if (! bBinaryFound)
              CheckFileForBinary(&nLast24Bytes[0],nByteNum,
               strFileName,ucHex,&bBinaryFound);
          }
        fclose(i);
        if ((! bASCIIFound) || (! bBinaryFound))
          for (nCharNum=6; ((! bFatalError) && (nCharNum--));)
            {
              nLast24Bytes[nByteNum]=-1;
              if (++nByteNum >= 24)
                nByteNum=0;
              if (! bASCIIFound)
                CheckFileForASCII(&nLast24Bytes[0],nByteNum,
                 strFileName,strTarget,&bASCIIFound);
              if (! bBinaryFound)
                CheckFileForBinary(&nLast24Bytes[0],nByteNum,
                 strFileName,ucHex,&bBinaryFound);
            }
        if ((! bASCIIFound) || (! bBinaryFound))
          for (nCharNum=6; ((! bFatalError) && (nCharNum--));)
            {
              nLast24Bytes[nByteNum]=-1;
              if (++nByteNum >= 24)
                nByteNum=0;
              if (! bASCIIFound)
                CheckFileForASCII(&nLast24Bytes[0],nByteNum,
                 strFileName,strTarget,&bASCIIFound);
              if (! bBinaryFound)
                CheckFileForBinary(&nLast24Bytes[0],nByteNum,
                 strFileName,ucHex,&bBinaryFound);
            }
        if (! bBinaryFound)
          for (nCharNum=6; ((! bFatalError) && (nCharNum--));)
            {
              nLast24Bytes[nByteNum]=-1;
              if (++nByteNum >= 24)
                nByteNum=0;
              CheckFileForBinary(&nLast24Bytes[0],nByteNum,
               strFileName,ucHex,&bBinaryFound);
            }
      }
    return;
  }
