/**
*@http200okWrapper		 extends dataProxy, implements a HTTP 200 ok 
*				  check while proxying data
*@author			 elab (www.elaboration.f2s.com)
*@date				
*@notes				 adds reply2(), returns a boolean if the reply 
*				  is a HTTP 200 ok
*				  16.11.01 - fixed carriage return string chars
*				  	     to bytes problem
**/

import java.io.*;
import java.lang.*;


public class http200okWrapper extends dataProxy
{
        public String query2(InputStream in, OutputStream out)
                throws IOException
        {
                byte buffer[] = new byte[200]; //a buffer of 200 bytes
                int count=0;
                DataInputStream dis = new DataInputStream(in);
                DataOutputStream dos = new DataOutputStream(out);
                String firstLine=null;

                try
                {
			//read the first line
                        firstLine = dis.readLine();
			//copy is as bytes to the buffer
			firstLine.getBytes(0,firstLine.length(),buffer,0);
			//add two bytes - carriage return
			byte[] end = {13,10};	
			//copy them to the buffer
			System.arraycopy(end,0,buffer,firstLine.length(),end.length);
			//set the counter to the write position to continue
			//reading
                        count = firstLine.length()+2;
	        }
                catch(EOFException eofe)
                {
			System.out.println("Exception throw trying to read first line " + eofe);
                }

                while(true)
		{
                        try
                        {
				if(count == buffer.length)
				{
					dos.write(buffer);
					count = 0;
				}
				else
				{
                                        if((buffer[count] = dis.readByte()) != 0xff)
                                        {
						count++;
                                        }
                                        else
                                        {
                                                break;
                                        }
                                }
                        }
			catch(EOFException eof)
			{
				break;
			}
			catch(IOException ioe)
			{
				break;
			}
        	}

                //count could poss be 0 when IOException occurs
                //maybe need to check buffer.length is > 0
		byte buffer2[] = new byte[count]; //second buffer, correct size

		//copy the request to the new array
		System.arraycopy(buffer,0,buffer2,0,count);

		//write the query
		dos.write(buffer2);

	return firstLine;
	}	
	public boolean reply2(InputStream in,OutputStream out)
		throws IOException
	{
		byte buffer[] = new byte[400];
		int count=0;
                boolean is200=false;
                DataInputStream dis = new DataInputStream(in);
                DataOutputStream dos = new DataOutputStream(out);

		//HTTP/1.1 200 OK
		int http200Buffer[] = {72,84,84,80,47,49,46,49,32,50,48,48,32,79,75};
		while(true)
		{
			if(http200Buffer.length == count)
			{
                        	byte checkArray[] = new byte[count];
                       	        System.arraycopy(buffer,0,checkArray,0,count);
	
	                        for(int i=0;i<checkArray.length;i++)
               	                {
					try
					{
	                       	      		if(http200Buffer[i] == checkArray[i])
        	                       	  	{
	        	                  	      is200 = true;
	       	        	                }
                	        	        else if(http200Buffer[i] != checkArray[i])
               	        	        	{
	                	        	        is200 = false;
        	                       	        	break;
	        	                       	}
					}
					catch(Exception e)
					{
						System.out.println("Exception in httptest " + e);
						break;
					}
	       	                }
			}
			
			//must check to see is200 is true - or buffer will fill and count reset to zero
			//and the check will repeat but on the wrong bytes
			if(is200 == true)
			{
				//break the loop
				break;
			}
			//if the array is full
			if(count == buffer.length)
			{
				try
				{
					//write the buffer
                                        dos.write(buffer);
				}
				catch(Exception e)
				{
					break;
				}
				//reset the counter
				count=0;
			}
                        else 
			{
				try
				{
                                        if((buffer[count] = dis.readByte()) != 0xff)
       	                                {
               	                                count++;
                       	                }
                               	        else
                                       	{
                                                break;
       	                                }
				}
				catch(EOFException eofe)
				{
					byte buffer2[] = new byte[count];
					System.arraycopy(buffer,0,buffer2,0,count);
					out.write(buffer2);
					break;
				}
				catch(IOException ioe)
				{
					byte buffer2[] = new byte[count];
					System.arraycopy(buffer,0,buffer2,0,count);
					out.write(buffer2);
					break;
				}
			}
		}
	return is200;
	}	
}	
