/**
*@smallWrapper		 class that can act as a socket wrapper
*@author		 elab (www.elaboration.f2s.com)
*@date			 
*@notes			 originally written as part of the OROBOROS project
*			  - two methods:
*					 checkBlocked(String ip)
*					 addAddress(String ip)
*
*			  - checkBlocked converts the string into a InetAddress 
*			  object and compares it to the other objs in an array
*
*			  - addAddress converts the string, checks the blocked 
*			  array isn't full then adds the obj; if the array is 
*			  full, the array is written to a file and reset
**/

import java.lang.*;
import java.net.*;
import java.io.*;

public class smallWrapper
{
	InetAddress blockedArray[] = new InetAddress[30];
	int count = 0;

	public boolean checkBlocked(InetAddress client)
		throws IOException
	{
	boolean blocked = false;
		if(client != null)
		{
			for(int i=0;i<count;i++)
			{
				try
				{
				 	if(client.equals(blockedArray[count]))
					{
						blocked = true;
						break;
					}
					else
					{
						blocked = false;
					}
				}
				catch(Exception e)
				{
				 	//do nada
			        }
			} 
		}	
		return blocked;
	}	

	//should only be called once checkBlocked() evaluates flase
	//method returns false when blockedArray written to file blocked.txt
	public boolean addAddress(InetAddress client)
		throws IOException
	{
		boolean added;
		if(count == blockedArray.length)
		{
			added = false;
			DataOutputStream fOut = new DataOutputStream(new FileOutputStream("blocked.txt"));
			int i=0;

			while(true)
			{
				try
				{	
					fOut.writeBytes(blockedArray[i].toString());
					i++;
				}
				catch(Exception e)
				{
					break;
				}
			}
			count = 0;
		}
		else
		{
			blockedArray[count] = client;
			count++;
			added = true;
		}	
	return added;	
	}
}
