
#if !defined( _MSDRM_H_ )
#define _MSDRM_H_

#include <openssl/des.h>
#include "ecc.h"
#include "MultiSwap.h"

typedef unsigned char uchar;

#define MS_BN_LEN 20

typedef struct ms_bn_st {
	uchar d[MS_BN_LEN];
} MS_BN;

typedef struct ms_eccpt_st {
	MS_BN x, y;
} MS_ECCpt;

typedef struct contkey_st {
	uchar ckey[MS_BN_LEN];
	int ckeylen;
	uchar keyhash[20];
	des_key_schedule keysched;
	uchar outmask[8];
	uchar inmask[8];
	MULTISWAPKEY hashkey;
} CONTKEY;

wchar_t *get_element(wchar_t * tag, wchar_t * str);
void MSDRM_decr_packet(uchar * data, int len, CONTKEY * ckey);
CONTKEY *MSDRM_init(wchar_t * license);

extern struct globalinfo_st {
	int verbose;
	void *fileheader;
	char *ofname;
	int packetlen;
	int numpackets;
	CONTKEY *content_key;
	wchar_t *kid;
	int hasV1header;
	int hasV2header;
} globalinfo;

#endif
