/* ----------------------------------------------------- */
/* Digitizer Check (digichek.c)                          */
/* Dave MacLeod <davmac@netcomuk.co.uk>                  */
/*                                                       */
/* This app show where the Pilot "thinks" the stylus is  */
/* touching the screen.                                  */
/* ----------------------------------------------------- */
/* v0.1     25/11/97    Creation                         */
/*                                                       */
/* ----------------------------------------------------- */

#pragma pack(2)
#include <System/SysAll.h>
#include <UI/UIAll.h>

#define MainForm     1000
#define MainRand     1001
#define MainPrev     1002
#define MainNext     1003
#define MainFld      1004
#define MainNo       1005

#define HelpText     1000

#define FormAbout    1050
#define AboutDone    1051

#define menuAbout    3001
#define menuHelp     3005

#define maxno        131

/* ----------------------------------------------------- */
/* Global Variables                                      */
/* ----------------------------------------------------- */

static short CurrNo = 0;

static char ObStrat [maxno][107] =
{
  "(Organic) machinery",
  "[blank white card]",
  "A line has two sides",
  "Abandon normal instruments",
  "Accept advice",
  "Accretion",
  "Allow an easement (an easement is the abandonment of a stricture)",
  "Always first steps",
  "Always give yourself credit for having more than personality",
  "Are there sections? Consider transitions",
  "Ask people to work against their better judgement",
  "Ask your body",
  "Assemble some of the elements in a group and treat the group",
  "Balance the consistency principle with the inconsistency principle",
  "Be extravagant",
  "Be less critical more often ",
  "Breathe more deeply",
  "Bridges -build -burn",
  "Cascades",
  "Change instrument roles",
  "Change nothing and continue with immaculate consistency",
  "Cluster analysis",
  "Consider different fading systems",
  "Consult other sources -promising -unpromising",
  "Convert a melodic element into a rhythmic element ",
  "Courage!",
  "Decorate decorate",
  "Define an area as 'safe' and use it as an anchor",
  "Destroy -nothing -the most important thing",
  "Discard an axiom",
  "Disciplined self-indulgence",
  "Disconnect from desire",
  "Discover the recipes you are using and abandon them",
  "Distorting time",
  "Do nothing for as long as possible",
  "Do something boring",
  "Do the washing up",
  "Do the words need changing?",
  "Do we need holes?",
  "Don't be afraid of things because they're easy to do",
  "Don't be frightened of cliches",
  "Don't be frightened to display your talents",
  "Don't break the silence",
  "Don't stress one thing more than another",
  "Emphasize differences",
  "Emphasize repetitions",
  "Emphasize the flaws",
  "Faced with a choice do both (given by Dieter Rot) ",
  "Fill every beat with something",
  "From nothing to more than nothing ",
  "Get your neck massaged ",
  "Ghost echoes",
  "Give the game away",
  "Give way to your worst impulse",
  "Go outside.  Shut the door.",
  "Go outside. Shut the door.",
  "Go slowly all the way round the outside",
  "Go to an extreme move back to a more comfortable place ",
  "Honor thy error as a hidden intention",
  "How would you have done it?",
  "Humanize something free of error",
  "Idiot glee",
  "Imagine the piece as a set of disconnected events",
  "In total darkness or in a very large room very quietly",
  "Infinitesimal gradations",
  "Intentions -credibility of -nobility of -humility of ",
  "Into the impossible",
  "Is it finished?",
  "Is the intonation correct?",
  "Is there something missing?",
  "It is quite possible (after all)",
  "Just carry on",
  "Left channel right channel centre channel ",
  "Listen to the quiet voice",
  "Look at the order in which you do things",
  "Look closely at the most embarrassing details and amplify them",
  "Lost in useless territory ",
  "Lowest common denominator",
  "Make a blank valuable by putting it in an exquisite frame",
  "Make a sudden destructive unpredictable action; incorporate",
  "Make an exhaustive list of everything you might do and do the last thing on the list",
  "Mechanicalize something idiosyncratic",
  "Mute and continue",
  "Not building a wall but making a brick",
  "Once the search is in progress something will be found ",
  "Only a part not the whole",
  "Only one element of each kind",
  "Overtly resist change",
  "Put in earplugs",
  "Question the heroic approach",
  "Remember those quiet evenings",
  "Remove ambiguities and convert to specifics",
  "Remove specifics and convert to ambiguities",
  "Repetition is a form of change",
  "Retrace your steps ",
  "Revaluation (a warm feeling) ",
  "Reverse",
  "Short circuit (eg; man eating peas with idea that they'll improve virility shovels them straight into lap)",
  "Simple subtraction",
  "Simply a matter of work ",
  "Spectrum analysis",
  "State the problem in words as clearly as possible ",
  "Take a break",
  "Take away the elements in order of apparent non-importance",
  "Tape your mouth (given by Ritva Saarikko)",
  "The inconsistency principle",
  "The most important thing is the thing most easily forgotten",
  "The tape is now the music",
  "Think of the radio",
  "Tidy up",
  "Towards the insignificant",
  "Trust in the you of now",
  "Turn it upside down",
  "Twist the spine",
  "Use an old idea",
  "Use an unacceptable color",
  "Use fewer notes",
  "Use filters",
  "Use 'unqualified' people",
  "Water",
  "What are the sections sections of? Imagine a caterpillar moving",
  "What are you really thinking about just now? Incorporate ",
  "What is the reality of the situation?",
  "What mistakes did you make last time?",
  "What would your closest friend do?",
  "What wouldn't you do?",
  "Work at a different speed",
  "Would anybody want it?",
  "You are an engineer",
  "You can only make one dot at a time",
  "You don't have to be ashamed of using your own ideas"
};

/* ----------------------------------------------------- */
/* RandN                                                 */
/*   This function generates a random number between 0   */
/*   and MaxNo                                           */
/* Parms                                                 */
/*   MaxNo - Maximum number to be returned               */
/* Returns                                               */
/*   A random integer                                    */
/* ----------------------------------------------------- */

int RandN(int MaxNo)
{
  return((int)(((double)SysRandom(0) * (double)MaxNo) / (double)sysRandomMax));
}

/* ----------------------------------------------------- */
/* DisplayWord                                           */
/*   This function wallops the buzzword out onto the     */
/*   screen.                                             */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

void DisplayWord(void)
{
  FormPtr  frmP;
  FieldPtr dstP;
  CharPtr  dstT;
  VoidHand dstHandle;
  char Tmp1[4];
  char Tmp2[5];

  /* Get pointer to active form */
  frmP = FrmGetActiveForm();

  StrIToA(Tmp1,CurrNo+1);
  StrCopy(Tmp2,"#");
  StrCat(Tmp2,Tmp1);

  /* Get pointer to the field which will hold the clipboard contents */
  dstP = (FieldPtr)(FrmGetObjectPtr(frmP, (FrmGetObjectIndex(frmP, MainNo))));

  /* Allocate and lock the destination for the clipboard size */
  dstHandle = MemHandleNew(StrLen(Tmp2)+1);
  dstT = MemHandleLock(dstHandle);

  /* Move the string in, unlock it and repaint the field */
  StrCopy(dstT, Tmp2);
  MemHandleUnlock(dstHandle);
  FldSetTextHandle(dstP, (Handle)dstHandle);
  FldDrawField(dstP);

  /* Get pointer to the field which will hold the clipboard contents */
  dstP = (FieldPtr)(FrmGetObjectPtr(frmP, (FrmGetObjectIndex(frmP, MainFld))));

  /* Allocate and lock the destination for the clipboard size */
  dstHandle = MemHandleNew(StrLen(ObStrat[CurrNo])+1);
  dstT = MemHandleLock(dstHandle);

  /* Move the string in, unlock it and repaint the field */
  StrCopy(dstT, ObStrat[CurrNo]);
  MemHandleUnlock(dstHandle);
  FldSetTextHandle(dstP, (Handle)dstHandle);
  FldDrawField(dstP);
}

/* ----------------------------------------------------- */
/* GetObjPtr                                             */
/*   Return the pointer to a form object                 */
/* Parms                                                 */
/*   objectID - The ID of the object, specified in the   */
/*              .rcp file.                               */
/* Returns                                               */
/*   A pointer to the specified object                   */
/* ----------------------------------------------------- */

static VoidPtr GetObjPtr(Int objectID)
{
  FormPtr frm;

  frm = FrmGetActiveForm();
  return(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objectID)));
}

/* ----------------------------------------------------- */
/* AboutViewHandleEvent                                  */
/*   Handle something happening on the about form        */
/* Parms                                                 */
/*   event - Pointer to an event type structure          */
/* Returns                                               */
/*   True - if the event has been dealt with             */
/* ----------------------------------------------------- */

static Boolean AboutViewHandleEvent(EventPtr event)
{
  Boolean handled = false;
  FormType frm;

  switch (event->eType)
  {
    case frmOpenEvent:
      FrmDrawForm(FrmGetActiveForm());
      handled = true;
      break;
    case ctlEnterEvent:
      if (event->data.popSelect.controlID==AboutDone)
      {
        FrmGotoForm(MainForm);
        handled = true;
        break;
      }
  }
  return(handled);
}

/* ----------------------------------------------------- */
/* MainViewHandleEvent                                   */
/*   This function loads a form and set the event        */
/*   handler for the form.                               */
/* Parms                                                 */
/*   event - Pointer to an event type structure          */
/* Returns                                               */
/*   True - if the event has been dealt with             */
/* ----------------------------------------------------- */

static Boolean MainViewHandleEvent(EventPtr event)
{
  Boolean handled = false;
  FormType frm;
  RectangleType rect;

  switch (event->eType)
  {
    case frmOpenEvent:
      FrmDrawForm(FrmGetActiveForm());
      break;
    case ctlSelectEvent:
      if (event->data.ctlEnter.controlID == MainRand)
      {
        CurrNo = RandN(maxno);
        DisplayWord();
        handled = true;
      }
      if (event->data.ctlEnter.controlID == MainPrev)
      {
        CurrNo = CurrNo--;
        if (CurrNo < 0)
          CurrNo = maxno-1;
        DisplayWord();
        handled = true;
      }
      if (event->data.ctlEnter.controlID == MainNext)
      {
        CurrNo = CurrNo++;
        if (CurrNo > maxno-1)
          CurrNo = 0;
        DisplayWord();
        handled = true;
      }
    case menuEvent:
      MenuEraseStatus(0);
      switch (event->data.menu.itemID)
      {
        case menuHelp:
          FrmHelp(HelpText);
          handled = true;
          break;
        case menuAbout:
          FrmPopupForm(FormAbout);
          handled = true;
          break;
      }
      handled = true;
      break;
  }
  return(handled);
}

/* ----------------------------------------------------- */
/* ApplicationHandleEvent                                */
/*   This function loads a form and set the event        */
/*   handler for the form.                               */
/* Parms                                                 */
/*   event - Pointer to an event type structure          */
/* Returns                                               */
/*   True - if the event has been dealt with             */
/* ----------------------------------------------------- */

static Boolean ApplicationHandleEvent(EventPtr event)
{
  FormPtr frm;
  Int formId;
  Boolean handled = false;

  if (event->eType == frmLoadEvent)
  {
    formId = event->data.frmLoad.formID;
    frm = FrmInitForm(formId);
    FrmSetActiveForm(frm);

    switch (formId)
    {
      case MainForm:
        FrmSetEventHandler(frm, MainViewHandleEvent);
        break;
      case FormAbout:
        FrmSetEventHandler(frm, AboutViewHandleEvent);
        break;
    }
    handled = true;
  }
  return handled;
}

/* ----------------------------------------------------- */
/* InitApplication                                       */
/*   Get everything ready.                               */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

static void InitApplication(void)
{
  FrmGotoForm(MainForm);
}

/* ----------------------------------------------------- */
/* StopApplication                                       */
/*   Like my Mum used to say "Tidy up after yourself".   */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

static void StopApplication(void)
{
  FrmCloseAllForms ();
}

/* ----------------------------------------------------- */
/* EventLoop                                             */
/*   This function gets events from the Event Manager,   */
/*   passes them to the system, menu and application     */
/*   event handlers before passing them onto our own     */
/*   processing.                                         */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

static void EventLoop(void)
{
  EventType event;
  Word error;
  do
  {
    EvtGetEvent(&event, evtWaitForever);
    if (! SysHandleEvent(&event))
      if (! MenuHandleEvent(NULL, &event, &error))
        if (!ApplicationHandleEvent(&event))
          FrmDispatchEvent(&event);
  }
  while (event.eType != appStopEvent);
}

/* ----------------------------------------------------- */
/* PilotMain                                             */
/*   Equivalent of the normal C Main(), it starts the    */
/*   execution of the application.                       */
/* Parms                                                 */
/*   cmd - command specifying how to launch the app      */
/*   cmdPBP - parameter block for the command            */
/*   launchFlags - flags used to config the launch       */
/* Returns                                               */
/*   An applicable error code                            */
/* ----------------------------------------------------- */

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
  Int err;

  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    InitApplication();
    EventLoop();
    StopApplication();
  }
  return 0;
}
