/*
 * John the Ripper  Copyright (c) 1996,97 by Solar Designer
 *
 * This file got too large, I should probably split it into several readable
 * parts. There are too many global variables, functions are too large, etc.
 * It all started with a tiny incremental-only cracker. To fix some time...
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#ifdef CYGWIN32
#include <windows.h>
#define NOGLOB
#else
#ifndef NOGLOB
#include <glob.h>
#endif
#include <signal.h>
#include <malloc.h>
#endif

#ifdef MSDOS
#include <bios.h>
#include <dos.h>
#include <dpmi.h>
#endif

#include "fcrypt.h"
#include "compiler.h"
#include "config.h"

#define version "1.3"
#define charsign "CHR0"

/*
 * Allow some duplicate password lines to be loaded, even if the encrypted
 * passwords match, but the logins don't. This may crack some more accounts
 * with the "single crack" mode.
 */

#define DUPES

#define bzero(buf, cnt) memset(buf, 0, cnt)
#define min(a, b) (((a) < (b)) ? (a) : (b))

/*
 * Constants to determine the hash table size (none, 16, 256, 4096 elements)
 * depending on the number of accounts with that salt.
 */

#define hashfallback 3
#define hashmin1 8
#define hashmin2 (4 * 16)
#define hashmin3 (4 * 16 * 16)

/*
 * Shift counts used to get information bits out of the binary encrypted
 * passwords, for use in the hash functions.
 */

#ifndef CRYPT_128K
#if defined(CRYPT_64BIT) && CRYPT_SCALE == 8
#define hashift_even 1
#define hashift_odd 1
#else
#define hashift_even 3
#define hashift_odd 3
#endif
#else
#ifndef CRYPT_64BIT
#define hashift_even 3
#define hashift_odd 1
#else
#define hashift_even 4
#define hashift_odd 2
#endif
#endif

#define hashift1 (hashift_even + 0 * 4)
#define hashift2 (hashift_odd + 1 * 4)
#define hashift3 (hashift_even + 2 * 4)

/*
 * The key cache allows moving both crypt_setkey() and crypt_setsalt() out of
 * the inner cracking loop.
 */

#define keycachesize 128
sbpb24 keycache[keycachesize][32 / SIZEDIV];
char wordcache[keycachesize][16];
int keyindex = 0;

#define copykey(dst, src) memcpy(dst, src, KEYSIZE)

#ifdef MSDOS
#define checkdelay 5000

/*
 * UNIXish time functions are too slow in DJGPP...
 */

typedef unsigned long dostime_t;

dostime_t dostime() {
  __dpmi_regs r;

  r.h.ah = 0x2C;
  __dpmi_int(0x21, &r);

  return
    (dostime_t)r.h.dl +
    (dostime_t)r.h.dh * 100 +
    (dostime_t)r.h.cl * 6000 +
    (dostime_t)r.h.ch * 360000;
}
#else
#define checkdelay 50000

typedef signed long dostime_t;

dostime_t dostime() {
  return (signed long)time(NULL) * 100;
}
#endif

#define savedelay (10 * 60 * 100)

#ifdef MSDOS
int keypressed() {
  return _bios_keybrd(_KEYBRD_READY);
}

int readkey() {
  return _bios_keybrd(_KEYBRD_READ);
}
#else
FILE *stdcon;

int keypressed() {
  fd_set fd;
  struct timeval tv;

  if (stdcon) {
    FD_ZERO(&fd); FD_SET(fileno(stdcon), &fd);
    tv.tv_sec = 0; tv.tv_usec = 0;

    return select(fileno(stdcon) + 1, &fd, NULL, NULL, &tv) > 0;
  } else return 0;
}

int readkey() {
  if (stdcon)
  if (ferror(stdcon) || feof(stdcon) || fgetc(stdcon) < 0) stdcon = NULL;
  else return -1;
  return 0;
}
#endif

#ifdef X86
extern int is486();
#endif

typedef struct account *salthash[16 * 16 * 16];

struct saltinfo {
  unsigned long fixedsalt, salt;
  unsigned long countpersalt;
  salthash *hash;
  struct account *(*hashfunc)(struct saltinfo *current);
  unsigned long hashsize;
  struct account *nextsalt;
};

struct account {
  sbpb24 binary;
  struct account *nexthash, *next;
  struct saltinfo *salt;
  char passwd[13], login[16];
  char *gecos;
};

struct cracked {
  char passwd[13 + 1 + 8 + 1];
  struct cracked *next;
};

#define loginsize 16
#define gecossize sizeof(char *)

char johnpath[256];

int stop = 0, okay = -1;

FILE *fp, *fw = NULL, *fpot, *fr;
char fwname[256], *dfwname;
off_t fwsize = 0;
char frname[256];
#define default_frname "restore"
char fcname[256];

struct account *salts[4096];
#define csalts (struct cracked *)salts
struct account *accounts = NULL;

char (*lamesalts)[128][128];

unsigned long acount = 0, asalt = 0, guessed = 0;

time_t curtime, starttime, timediff, elapsedtime = 0;
long timeout = 0x7FFFFFFF;
dostime_t curtick, lasttick1, lasttick10;
unsigned long totalcrypts = 0, addedcrypts = 0;

#define worddone "*****DONE*****"
#define wordnone "*****NONE*****"
char word[96] = wordnone, lastword[sizeof(word)];

unsigned short lastsalt = 0xFFFF;

int rulenum = 0, rule_errno = 0;
struct cfg_line *ruleptr, *lastrule;

struct cfg_line *rules_s, *rules_w;
int rulecount_s, rulecount_w;

int lastid = 0, lastpos = 0;
unsigned char lastwordi[16] = {0, 0, 0, 0, 0, 0, 0, 0};

char *singlejohn = "johnsingle";
char *singlejack = "single";

/*
 * Some passwords to test the routines in fcrypt.c for correct operation. They
 * are carefully selected to test all parts of crypt_setkey().
 */

char *testpwd[] = {
  "U*U*U*U*",
  "U*U***U",
  "U*U***U*",
  "*U*U*U*U",
  "",
  NULL
};

char *testpwe[] = {
  "CCNf8Sbh3HDfQ",
  "CCX.K.MFy4Ois",
  "CC4rMpbg9AMZ.",
  "XXxzOu6maQKqQ",
  "SDbsugeBiC58A",
  NULL
};

char pot[256];

int external = 0, extcrack = 0, rules = 0, beep = 0, listwords = 0;
int noname = 0, nohash = 0;
int singlecrack = 0, show = 0, makechars = 0;
int realtime = 0, percent = 0;
int minsalts = 1;
char *incremental = NULL;
char incmodebuf[16] = "All";
char extname[64];

struct stringlist {
  char *name;
  struct stringlist *next;
};

struct stringlist *pwfiles = NULL, *users = NULL, *shells = NULL;
struct stringlist *flags = NULL, *words = NULL;

char *options[] = {
  "wordfile",
  "stdin",
  "pwfile",
  "quiet",
  "beep",
  "test",
  "help",
  "?",
  "restore",
  "list",
  "noname",
  "users",
  "timeout",
  "single",
  "incremental",
  "salts",
  "nohash",
  "shells",
  "show",
  "lamesalts",
  "rules",
  "external",
  "makechars",
  NULL
};

#define idscount (8 * 96 * 2)
extern unsigned char ids[idscount];

extern void *malloc_tiny(size_t size);

#ifdef DEBUG
void debug_check() {
  register struct account *currentsalt, *current;
  unsigned long asalt1 = 0, acount1 = 0, acount2 = 0;
  int invsalts = 0;
  unsigned long index, count;

  sbpb24 save_cout = crypt_cout[1];

  if (currentsalt = accounts) do {
    asalt1++;
    current = currentsalt;
    do {
      acount1++;
      if (current->salt != currentsalt->salt) invsalts++;
    } while (current = current->next);

    if (!(count = currentsalt->salt->hashsize / sizeof(struct account *))) count = 1;
    for (index = 0; index < count; index++) {
      crypt_cout[1] = 
        ((index & 0xF) << hashift1) |
        ((index & 0xF0) << hashift2) |
        ((index & 0xF00) << hashift3);

      if (current = currentsalt->salt->hashfunc(currentsalt->salt))
      do acount2++; while (current = current->nexthash);
    }
  } while (currentsalt = currentsalt->salt->nextsalt);

  crypt_cout[1] = save_cout;

  if (invsalts)
    printf("ERROR: invalid salt pointers: %d\n", invsalts);
  if (acount != acount1 || acount != acount2)
    printf("ERROR: invalid accounts count: %d/%d/%d\n", acount, acount1, acount2);
  if (asalt != asalt1)
    printf("ERROR: invalid salts count: %d/%d\n", asalt, asalt1);
}

void debug_memory(char *extra) {
#ifdef MSDOS
  __dpmi_free_mem_info meminfo;

  __dpmi_get_free_memory_information(&meminfo);
  printf("DEBUG: %d Kb free %s\n", meminfo.total_number_of_free_pages << 2, extra);
#endif
}
#endif

#ifndef CYGWIN32
void handler(int s) {
#else
int handler(int s) {
#endif
  if (stop--) {
    puts("Abort! "); exit(1);
  } else
#if defined(MSDOS) || defined(MSWIN)
  printf("Wait...\r");
#else
  printf("\nWait...\r");
#endif
  fflush(stdout);
#ifndef CYGWIN32
  signal(SIGINT, handler);
#else
  return -1;
#endif
}

struct account *hashfunc0(struct saltinfo *current) {
  return (struct account *)current->hash;
}

struct account *hashfunc1(struct saltinfo *current) {
  return (*(current->hash)) [
    (crypt_cout[1] & 0xFF) >> hashift1 ];
}

struct account *hashfunc2(struct saltinfo *current) {
  return (*(current->hash)) [
    ((crypt_cout[1] & 0xFFFF) >> hashift2) |
    ((crypt_cout[1] & 0xFF) >> hashift1) ];
}

struct account *hashfunc3(struct saltinfo *current) {
  return (*(current->hash)) [
    ((crypt_cout[1] & 0xFF0000) >> hashift3) |
    ((crypt_cout[1] & 0xFFFF) >> hashift2) |
    ((crypt_cout[1] & 0xFF) >> hashift1) ];
}

void usage() {
  puts(
    "Usage: john [flags] [passwd files]\n\n"
#ifdef NOGLOB
    "Flags: -pwfile:<file>[,..]     specify passwd file(s)\n"
#else
    "Flags: -pwfile:<file>[,..]     specify passwd file(s) (wildcards allowed)\n"
#endif
    "       -wordfile:<file> -stdin wordlist mode, read words from <file> or stdin\n"
    "       -rules                  enable rules for wordlist mode\n"
    "       -incremental[:<mode>]   incremental mode [using john.ini entry <mode>]\n"
    "       -single                 single crack mode\n"
    "       -external:<mode>        external mode, using john.ini entry <mode>\n"
    "       -restore[:<file>]       restore session [from <file>]\n"
    "       -makechars:<file>       make a charset, <file> will be overwritten\n"
    "       -show                   show cracked passwords\n"
    "       -test                   perform a benchmark\n"
    "       -users:<login|uid>[,..] crack this (these) user(s) only\n"
    "       -shells:[!]<shell>[,..] crack users with this (these) shell(s) only\n"
    "       -salts:[!]<count>       crack salts with at least <count> accounts only\n"
    "       -lamesalts              assume cleartext passwords were used as salts\n"
    "       -timeout:<time>         abort session after a period of <time> minutes\n"
    "       -list                   list each word\n"
    "       -beep -quiet            beep or don't beep when a password is found\n"
    "       -noname -nohash         don't use memory for login names or hash tables");
}

int addlist(struct stringlist **where, char *what, int parse) {
  char *comma;
  struct stringlist *last;

  do {
    if (comma = strchr(what, ','))
    if (parse) *comma = 0; else comma = NULL;

    last = *where;
    if (*where = (struct stringlist *)malloc_tiny(sizeof(struct stringlist)))
    if ((*where)->name = (char *)malloc_tiny(strlen(what) + 1)) {
      (*where)->next = last;
      strcpy((*where)->name, what);
    }
    if (!*where || !(*where)->name) {
      *where = last;
      puts("Not enough free memory"); return 1;
    }

    what = comma + 1;
  } while (comma);

  return 0;
}

struct stringlist *inlist(struct stringlist *where, char *what) {
  if (where) do
    if (!strcmp(where->name, what)) break;
  while (where = where->next);

  return where;
}

struct cfg_line *c_ext_line;
int c_ext_pos;

int c_cfg_getchar() {
  register char c;

  if (!c_ext_line || !c_ext_line->value) return -1; else
  if (!(c = c_ext_line->value[c_ext_pos++])) {
    c_ext_line = c_ext_line->next; c_ext_pos = 0;
    return '\n';
  } else return c;
}

void c_cfg_rewind() {
  c_ext_line = cfg_getl(extname)->list; c_ext_pos = 0;
  c_datasize = 9;
}

int initext() {
  static struct c_VAR c_ext_vars = {
    NULL, "word", 0
  };
  struct c_FUNC *func;

  c_globalvars = &c_ext_vars;

  c_ext_getchar = c_cfg_getchar; c_ext_rewind = c_cfg_rewind;
  c_compile();

  if (c_error) {
    if (!c_ext_line) c_ext_line = cfg_getl(extname)->tail;

    printf("Error in john.ini, line %d: %s\n",
      c_ext_line->linenum, c_messages[c_error]);
  } else {
    c_execute("init");
    if (func = c_globalfuncs) do
      if (!strcmp(func->name, "generate")) extcrack = -1;
    while (func = func->next);
  }

  return c_error;
}

void callext(char *name) {
  register int i;

  if (!external) return;

  i = 9; while (i--) c_data[i] = word[i];
  c_execute(name);
  i = 9; while (i--) word[i] = c_data[i];
}

int findpwfile(char *wildcard) {
  char *comma;

#ifndef NOGLOB
  char **current;
  glob_t list;
#endif

  do {
    if (comma = strchr(wildcard, ',')) *comma = 0;

#ifdef NOGLOB
    if (addlist(&pwfiles, wildcard, 0)) return 1;
#else
    if (glob(wildcard, GLOB_NOSORT, NULL, &list)) {
      printf("Unable to find passwd file: %s\n", wildcard); return 1;
    }

    current = list.gl_pathv;
    while (*current)
    if (addlist(&pwfiles, *current++, 0)) return 1;

    globfree(&list);
#endif

    wildcard = comma + 1;
  } while (comma);

  return 0;
}

int readpwfile() {
  register struct account *current, *last;
  register struct cracked *crk1, *crk2;
  char s[256], src[256];
  char *p, *pe, *pi, *pin, *pie, *pg, *pge;
  int i, pass;
  unsigned short salt;
  struct stringlist *currentpw, *currentshell;
  int badshell, reqshell;

  if (singlecrack) noname = 0;

  if (currentpw = pwfiles) do {
    if (!(fp = fopen(currentpw->name, "r"))) {
      printf("Unable to open passwd file: %s\n", currentpw->name); return 1;
    }

    while (fgets(s, sizeof(s) - 16, fp)) {
      if (stop) {
        puts("Session aborted"); return 1;
      }

      if (p = strchr(s, '\r')) *p = 0;
      if (p = strchr(s, '\n')) *p = 0;

      if (!(p = strchr(s, ':'))) continue;
      *p++ = 0;
      if (!(pe = strchr(p, ':'))) pe = strchr(p, 0);
      if (pe - p != 13 && pe - p != 24 &&
        (!show || pe != p || !*pe || s[0] == '+')) continue;

      if (show)
      if (pwfiles->next) sprintf(src, "%s (in %s)", pe, currentpw->name);
      else strcpy(src, pe);

      if (shells) {
        if (*(pin = pi = pe)) {
          pi = pe;
          for (i = 0; i < 4; i++)
          if (!(pi = strchr(pi + 1, ':'))) break;
          if (pi) {
            if (pie = strchr(++pi, ':')) *pie = 0; else pie = strchr(pi, 0);
            for (pin = pie; *pin != '/' && pin >= pi; pin--); pin++;
          } else pin = pi = "";
        }

        currentshell = shells; badshell = reqshell = 0;
        do {
          if (currentshell->name[0] != '!') {
            reqshell--;
            if (!strcmp(currentshell->name, pi) || !strcmp(currentshell->name, pin)) break;
          } else
          if (!strcmp(currentshell->name + 1, pi) || !strcmp(currentshell->name + 1, pin)) {
            badshell--; break;
          }
        } while (currentshell = currentshell->next);

        if (badshell || reqshell && !currentshell) continue;
      }

      if (users) {
        pi = s;
        if (*pe) if (pie = strchr(pi = pe + 1, ':')) *pie = 0;
        if (!inlist(users, s) && !inlist(users, pi)) continue;
      }

      if (show || makechars) {
        if (p == pe) {
          guessed++;
          if (show) printf("%s:NO PASSWORD%s\n", s, src);
        } else {
          if (crk1 = csalts[crypt_getsalt(p)]) do
            if (!memcmp(crk1->passwd, p, 13)) break;
          while (crk1 = crk1->next);

          if (pe - p == 24) {
            if (crk2 = csalts[crypt_getsalt(p + 2)]) do
              if (!memcmp(crk2->passwd + 2, p + 13, 11)) break;
            while (crk2 = crk2->next);

            if (crk1 || crk2) {
              if (crk1 && crk2) guessed += 2; else guessed++;
              if (show)
              printf("%s:%s%s%s\n", s,
                crk1 ? crk1->passwd + 14 : "????????",
                crk2 ? crk2->passwd + 14 : "????????", src);
              else {
                if (crk1 && addlist(&words, crk1->passwd + 14, 0)) return 1;
                if (crk2 && addlist(&words, crk2->passwd + 14, 0)) return 1;
              }
            }

            acount++;
          } else
          if (crk1) {
            guessed++;
            if (show) printf("%s:%s%s\n", s, crk1->passwd + 14, src);
            else if (addlist(&words, crk1->passwd + 14, 0)) return 1;
          }
        }

        acount++; continue;
      }

      pg = NULL;
      if (singlecrack && *pe) {
        pg = pe;
        for (i = 0; i < 2; i++)
        if (!(pg = strchr(pg + 1, ':'))) break;
        if (pg && (pge = strchr(++pg, ':'))) *pge = 0;
      }

      *pe = 0;

      if (p[13]) pass = 1; else pass = 0;
      do {
        if (!(last = salts[salt = crypt_getsalt(p)])) asalt++; else {
          current = last;
          do {
            if (*current->passwd == *p &&
              !memcmp(p, current->passwd, 13)
#ifdef DUPES
              && (noname || (!memcmp(s, current->login, min(strlen(s), 15) + 1)))
#endif
              ) break;
          } while (current = current->next);
          if (current) break;
        }
        acount++;

        if (!(current = (struct account *)malloc_tiny(sizeof(struct account)
          -(noname ? loginsize : (singlecrack ? 0 : (loginsize - 1) - min(loginsize - 1, strlen(s) + (pass ? 2 : 0))))
          -(singlecrack ? 0 : gecossize)))) {
          puts("Not enough free memory"); return 1;
        }

        if (current->nexthash = current->next = last) current->salt = last->salt; else {
          if (!(current->salt = (struct saltinfo *)malloc_tiny(sizeof(struct saltinfo)))) {
            puts("Not enough free memory"); return 1;
          }

          current->salt->salt = salt;
          current->salt->fixedsalt = crypt_fixsalt(salt);

          current->salt->hashfunc = hashfunc0;
          current->salt->hashsize = 0;
        }

        (struct account *)current->salt->hash = current;

        current->binary = *crypt_binary(p, !singlecrack)[0];
        memcpy(current->passwd, p, 13);

        if (lamesalts) (*lamesalts)[p[1] & 0x7F][p[0] & 0x7F] = -1;

        if (!noname) {
          if (singlecrack)
          if (pg && *pg) {
            if (!(current->gecos = (char *)malloc_tiny(strlen(pg) + 1))) {
              puts("Not enough free memory"); return 1;
            }
            strcpy(current->gecos, pg);
          } else current->gecos = NULL;

          if (pass) s[13] = 0; else s[15] = 0;
          sprintf(current->login, pass ? "%s:%d" : "%s", s, pass);
        }
        salts[salt] = current;
        current = NULL;

        p[11] = p[2]; p[12] = p[3]; p += 11;
        if (pass) pass++;
      } while (pe - p >= 13);

      if (current) continue;
    }

    fclose(fp);
  } while (currentpw = currentpw->next);

  return 0;
}

int openwordfile(char *name) {
  struct stat fwstat;

  if (!(fw = fopen(name, "r"))) {
    printf("Unable to open wordlist file: %s\n", name); return 1;
  }
  if (!stat(strcpy(fwname, name), &fwstat)) fwsize = fwstat.st_size;

  return 0;
}

#ifdef DEBUG
int benchmark() {
#else
void benchmark() {
#endif
  dostime_t curtime, starttime;
  unsigned long crypts1, crypts2, setkeys1, setkeys2;

  int example;
  unsigned long examples[][2] = {
    {1,       1},
    {10,      10},
    {100,     99},
    {1000,    887},
    {10000,   3740},
    {100000,  4096},
    {1000000, 4096},
    {100,     1},
    {10000,   100},
    {10000,   1},
    {0,       0}
  };

  unsigned long expected(unsigned long accounts, unsigned long salts) {
    return
      (unsigned long long)(setkeys2 + (crypts2 - setkeys2) * (salts - 1) / salts) *
      accounts / salts / 15 * (4096 - 100 - accounts / 3000 - accounts / salts / 30) >> 12;
  }

  printf("Running benchmark for 1 minute...");
  fflush(stdout);

  saltvalue = crypt_fixsalt(crypt_getsalt(testpwe[0]));
  do {
    setkeys1 = 0;
    starttime = dostime();
    while ((curtime = dostime()) == starttime); starttime = curtime;
    do {
      crypt_setkey(++setkeys1 & 1 ? testpwd[3] : testpwd[0]); XForm1();
    } while (setkeys1 & 0x7F || ((curtime = dostime()) - starttime < 15 * 100 && curtime >= starttime && !stop));
  } while (curtime < starttime);
#ifdef DEBUG
  crypt_binary(setkeys1 & 1 ? testpwe[3] : testpwe[0], 0);
  if (memcmp(crypt_cout, crypt_cbin, crypt_binsize)) return -1;
  crypt_setkey(testpwd[0]); crypt_binary(testpwe[0], 0);
#endif

  do {
    crypts1 = 0;
    starttime = dostime();
    while ((curtime = dostime()) == starttime); starttime = curtime;
    do {
      crypts1++; XForm1();
    } while (crypts1 & 0x7F || ((curtime = dostime()) - starttime < 15 * 100 && curtime >= starttime && !stop));
  } while (curtime < starttime);
#ifdef DEBUG
  if (memcmp(crypt_cout, crypt_cbin, crypt_binsize)) return -1;
#endif

  crypt_setsalt(crypt_getsalt(testpwe[0]));
  do {
    setkeys2 = 0;
    starttime = dostime();
    while ((curtime = dostime()) == starttime); starttime = curtime;
    do {
      crypt_setkey(++setkeys2 & 1 ? testpwd[1] : testpwd[0]); XForm2();
    } while (setkeys2 & 0x7F || ((curtime = dostime()) - starttime < 15 * 100 && curtime >= starttime && !stop));
  } while (curtime < starttime);
#ifdef DEBUG
  crypt_binary(setkeys2 & 1 ? testpwe[1] : testpwe[0], -1);
  if (memcmp(crypt_cout, crypt_cbin, crypt_binsize)) return -1;
  crypt_setkey(testpwd[0]); crypt_binary(testpwe[0], -1);
#endif

  do {
    crypts2 = 0;
    starttime = dostime();
    while ((curtime = dostime()) == starttime); starttime = curtime;
    do {
      crypts2++; XForm2();
    } while (crypts2 & 0x7F || ((curtime = dostime()) - starttime < 15 * 100 && curtime >= starttime && !stop));
  } while (curtime < starttime);
#ifdef DEBUG
  if (memcmp(crypt_cout, crypt_cbin, crypt_binsize)) return -1;
#endif

  if (!stop) {
    printf(
      " Done!\n"
      "\n"
#if defined(MSDOS) || defined(MSWIN)
      "Raw speed:\n"
      "  c/s     functions     comment\n"
      "\n"
        "%6lu  xform1         single crack mode (many accounts)\n"
        "%6lu  xform1+setkey  single crack mode (only a few accounts)\n"
        "%6lu  xform2 (*)     wordlist and incremental modes (many accounts)\n"
        "%6lu  xform2+setkey  wordlist and incremental modes (only one account)\n"
      "(*) this is the value that should be compared to v1.0's benchmark result\n"
      "\n"
      "Expected cracking speed (wordlist and incremental modes):\n"
      " accounts  salts  c/s\n"
      "\n",
#else
      "Raw speed:\n"
      "  c/s  |   functions   |  comment\n"
      "-------+---------------+-----------\n"
        "%6lu | xform1        | single crack mode (many accounts)\n"
        "%6lu | xform1+setkey | single crack mode (only a few accounts)\n"
        "%6lu | xform2 (*)    | wordlist and incremental modes (many accounts)\n"
        "%6lu | xform2+setkey | wordlist and incremental modes (only one account)\n"
      "(*) this is the value that should be compared to v1.0's benchmark result\n"
      "\n"
      "Expected cracking speed (wordlist and incremental modes):\n"
      " accounts | salts | c/s\n"
      "----------+-------+-----------\n",
#endif
      crypts1 / 15, setkeys1 / 15, crypts2 / 15, setkeys2 / 15);

    if (setkeys1 > crypts1) crypts1 = setkeys1;
    if (setkeys2 > crypts2) crypts2 = setkeys2;

    for (example = 0; examples[example][0]; example++) printf(
#if defined(MSDOS) || defined(MSWIN)
      " %-9lu %-6lu %lu\n",
#else
      " %-9lu| %-6lu| %lu\n",
#endif
      examples[example][0], examples[example][1],
      expected(examples[example][0], examples[example][1]));
  } else puts("Aborted...");

#ifdef DEBUG
  return 0;
#endif
}

int processoption(char *option);

void writerestore() {
  struct stringlist *currentpw = pwfiles, *currentuser = users;
  struct stringlist *currentflag, *lastflag;
  int wordpos;

  fflush(fpot);

  if (!(fr = fopen(frname, "w"))) return;

  fprintf(fr, "PWfile=");
  do
    fprintf(fr, "%s%c", currentpw->name, currentpw->next ? ',' : '\n');
  while(currentpw = currentpw->next);
  if (singlecrack) fprintf(fr, "Lastsalt=%d\nLastrule=%s\n", lastsalt, ruleptr ? ruleptr->value : worddone);
  else if (incremental) {
    fprintf(fr, "Lastid=%d\nLastpos=%d\nLastvalue=", lastid, lastpos);
    for (wordpos = 0; wordpos < 8; wordpos++)
      fprintf(fr, "%d%c", lastwordi[wordpos], wordpos == 7 ? '\n' : ',');
  } else {
    if (fwname[0]) fprintf(fr, "Wordfile=%s\n", fwname);
    fprintf(fr, "Lastword=%s\n", lastword);
    if (rules) fprintf(fr, "Lastrule=%s\n", lastrule ? lastrule->value : worddone);
  }
  if (currentuser) {
    fprintf(fr, "User=");
    do
      fprintf(fr, "%s%c", currentuser->name, currentuser->next ? ',' : '\n');
    while(currentuser = currentuser->next);
  }
  if (flags) {
    lastflag = NULL;
    do {
      currentflag = flags;
      while (currentflag->next != lastflag) currentflag = currentflag->next;
      fprintf(fr, "Flag=%s\n", currentflag->name);
    } while ((lastflag = currentflag) != flags);
  }

  fprintf(fr, "v=%lu\nc/s=%lu%03lu/%lu\n",
    guessed,
    totalcrypts + addedcrypts / 1000, addedcrypts % 1000,
    (long)(time(NULL) - starttime));

  fclose(fr);
}

int readrestore() {
  char *buf, *p, *pe;
  #define bufsize 16384
  int res;
  int notfound = -1;
  int wordpos;

  if (!(fr = fopen(frname, "r"))) {
    printf("Unable to open restore file: %s\n", frname); return 1;
  }
  if (!(buf = (char *)malloc(bufsize))) {
    puts("Not enough free memory"); return 1;
  }

  if (fw) {
    fclose(fw); fw = NULL;
  }

  word[0] = 0;
  lastsalt = 0xFFFF; lastid = 0xFFFF; lastpos = 0xFFFF; lastwordi[7] = 0xFF;
  while (fgets(buf, bufsize, fr)) {
    if (p = strchr(buf, '\r')) *p = 0;
    if (p = strchr(buf, '\n')) *p = 0;

    if (!(p = strchr(buf, '='))) continue;
    *p++ = 0;

    if (!strcmp(buf, "PWfile")) {
      if (findpwfile(p)) return 1;
    } else
    if (!strcmp(buf, "Wordfile")) {
      if (openwordfile(p)) return 1;
    } else
    if (!strcmp(buf, "Lastword")) {
      if (!strcmp(p, worddone)) {
        puts("Session previously completed"); return 2;
      }
      p[sizeof(word) - 1] = 0; strcpy(word, p);
    } else
    if (!strcmp(buf, "Lastid")) {
      if ((lastid = atoi(p)) == 0xFFFF) {
        puts("Session previously completed"); return 2;
      } else lastid &= 0xFFFE;
    } else
    if (!strcmp(buf, "Lastpos")) lastpos = atoi(p); else
    if (!strcmp(buf, "Lastvalue")) {
      for (wordpos = 0; wordpos < 8; wordpos++) {
        lastwordi[wordpos] = atoi(p);
        if (p = strchr(p, ',')) p++; else break;
      }
    } else
    if (!strcmp(buf, "Lastsalt")) {
      if ((lastsalt = atoi(p)) == 0xFFFF) {
        puts("Session previously completed"); return 2;
      }
    } else
    if (!strcmp(buf, "Lastrule")) {
      rulenum = 0; ruleptr = fw ? rules_w : rules_s;
      do {
        if (!strcmp(p, ruleptr->value)) break;
        rulenum++;
      } while (ruleptr = ruleptr->next);
      if (!ruleptr) {
        printf("Rule not found: %s\n", p); return 1;
      }
      lastrule = ruleptr;
    } else
    if (!strcmp(buf, "User")) {
      if (addlist(&users, p, 1)) return 1;
    } else
    if (!strcmp(buf, "Flag")) {
      if (!strcmp(p, singlejack)) {
        puts("Jack-style single crack mode not supported"); return 1;
      }
      if (!strcmp(p, singlejohn)) p = singlejack;
      if (res = processoption(p)) return res;
    } else
    if (!strcmp(buf, "v")) guessed = atoi(p); else
    if (!strcmp(buf, "c/s")) {
      if (pe = strchr(p, '/')) {
        addedcrypts = atoi(pe - 3); *(pe - 3) = 0;
        totalcrypts = atoi(p);
        elapsedtime = atoi(pe + 1);
      }
    } else {
      printf("Unknown parameter in restore file: %s\n", buf); return 1;
    }
  }

  if (pwfiles && (
    !singlecrack && !incremental && fw && word[0] && (!rules || ruleptr) ||
    singlecrack && lastsalt != 0xFFFF && ruleptr ||
    incremental && lastid != 0xFFFF && lastpos != 0xFFFF && lastwordi[7] != 0xFF ||
    !fw && !singlecrack && !incremental && extcrack))
  {
    if (!singlecrack && !incremental && word[0] && strcmp(word, wordnone)) {
      if (extcrack) callext("restore"); else {
        while (fgets(buf, bufsize, fw)) {
          if (p = strchr(buf, '\r')) *p = 0;
          if (p = strchr(buf, '\n')) *p = 0;

          if (!(notfound = strncmp(buf, word, sizeof(word) - 1))) break;
        }
        if (notfound) {
          printf("Word not found: %s\n", word); return 1;
        }
      }
    }
  } else {
    puts("Required parameters missing in restore file"); return 1;
  }

  free(buf);
  fclose(fr);

  return 0;
}

int processoption(char *option) {
  int opti, optf;
  char s[256], c[256];
  char *p, *po;

  strcpy(s, option);
  if (p = strchr(s, ':')) {
    *p++ = 0; if (!*p) p = NULL;
  }

  strlwr(strcpy(c, s));

  opti = 0; optf = -1;
  do {
    if (strlen(c) <= strlen(options[opti]))
    if (!memcmp(c, options[opti], strlen(c)))
    if (optf == -1) optf = opti; else optf = -2;
  } while (options[++opti]);

  if (optf < 0) {
    printf("Invalid option: %s\n", s); return 1;
  }
  po = options[optf];

  if (fw && (optf <= 1)) {
    puts("Only one wordlist file can be specified"); return 1;
  }
  switch (optf) {
    case 0:
      if (show || makechars) return 3;
      if (p) if (openwordfile(p)) return 1;
      break;
    case 1:
      if (show || makechars || rules) return 3;
      if (addlist(&flags, po, 0)) return 1;
      fw = stdin; fwname[0] = 0;
      break;
    case 2:
      if (p) if (findpwfile(p)) return 1;
      break;
    case 3:
    case 4:
      if (addlist(&flags, po, 0)) return 1;
      beep = 3 - optf;
      break;
    case 5:
#ifdef DEBUG
      if (benchmark()) puts("ERROR: a bug in benchmark()");
#else
      benchmark();
#endif
      return 2;
    case 6:
    case 7:
      usage();
      return 2;
    case 8:
      if (show) return 3;
      if (p) strcpy(frname, p);
      return readrestore();
    case 9:
      listwords = -1;
      if (addlist(&flags, po, 0)) return 1;
      break;
    case 10:
      if (singlecrack) return 3;
      if (addlist(&flags, po, 0)) return 1;
      noname = -1;
      break;
    case 11:
      if (!p) p = "0";
      if (addlist(&users, p, 1)) return 1;
      break;
    case 12:
      if (p && (timeout = atoi(p))) {
        sprintf(c, "%s:%s", po, p);
        if (addlist(&flags, c, 0)) return 1;
      } else {
        puts("Invalid timeout value"); return 1;
      }
      break;
    case 13:
      if (show || makechars || incremental || noname) return 3;
      singlecrack = -1;
      if (addlist(&flags, singlejohn, 0)) return 1;
      break;
    case 14:
      if (show || makechars || singlecrack) return 3;
      if (p) {
        p[15] = 0; strcpy(incmodebuf, p);
      }
      sprintf(c, "incremental:%s", incremental = incmodebuf);
      if (!cfg_gets(c, NULL)) {
        printf("No definition for incremental mode: %s\n", incmodebuf);
        return 1;
      }
      if (addlist(&flags, c, 0)) return 1;
      break;
    case 15:
      if (minsalts != 1) return 3;
      if (p && p[0] == '!') {
        p++; minsalts = -1;
      }
      if (p && (minsalts *= atoi(p))) {
        sprintf(c, "%s:%s", po, p);
        if (addlist(&flags, c, 0)) return 1;
      } else {
        puts("Invalid accounts per salt count"); return 1;
      }
      break;
    case 16:
      nohash = -1;
      if (addlist(&flags, po, 0)) return 1;
      break;
    case 17:
      if (!p) break;
      sprintf(c, "%s:%s", po, p);
      if (addlist(&flags, c, 0)) return 1;
      if (addlist(&shells, p, 1)) return 1;
      break;
    case 18:
      if (fw || incremental || singlecrack || makechars) return 3;
      show = -1;
      break;
    case 19:
      if (addlist(&flags, po, 0)) return 1;
      if (!(lamesalts = (char (*)[][])calloc(1, sizeof(*lamesalts)))) {
        puts("Not enough free memory"); return 1;
      }
      break;
    case 20:
      if (fw == stdin) return 3;
      rules = -1;
      if (addlist(&flags, po, 0)) return 1;
      break;
    case 21:
      if (show) return 3;
      if (!p) {
        puts("Specify an external mode name"); return 1;
      }
      p[32] = 0; sprintf(extname, "list.external:%s", p);
      if (!cfg_gets(extname, NULL)) {
        printf("No definition for external mode: %s\n", p);
        return 1;
      } else if (initext()) return 1;
      sprintf(c, "external:%s", p);
      external = -1;
      if (addlist(&flags, c, 0)) return 1;
      break;
    case 22:
      if (fw || incremental || singlecrack || show) return 3;
      if (!p) {
        puts("Specify a charset file name"); return 1;
      }
      strcpy(fcname, p);
      makechars = -1;
      break;
  }

  return 0;
}

int readoptions(int argc, char **argv) {
  int argi, res;

  sprintf(frname, "%s%s", johnpath, default_frname);

  if (timeout = cfg_geti("Defaults", "Timeout") < 0) timeout = 0x7FFFFFFF;
  beep = cfg_getb("Defaults", "Beep");

  realtime = cfg_getb("Options", "Realtime");
  percent = cfg_getb("Options", "Percent");

  for (argi = 1; argi < argc; argi++)
#ifdef MSDOS
  if (argv[argi][0] == '-' || argv[argi][0] == '/') {
#else
  if (argv[argi][0] == '-') {
#endif
    if (res = processoption(&argv[argi][1])) return res;
  } else if (findpwfile(argv[argi])) return 1;

  return 0;
}

void initpath(char **argv) {
  int pos;

  strcpy(johnpath, argv[0]);
  for (pos = strlen(johnpath); pos >= 0 && johnpath[pos] != '/'; johnpath[pos--] = 0);
}

char *apply(char *, char *, int);

int initrules() {
  struct cfg_section *s;
  char **testptr;
  char *testwords[] = {
    "lower",
    "UPPER",
    "Both",
    "1234",
    "Num1",
    "toolongword",
    NULL
  };

  if (!(s = cfg_getl("List.Rules:Single")) ||
    !(ruleptr = rules_s = s->list) || (rulecount_s = s->listcount) < 1)
  {
    puts("Invalid single crack mode rules definition"); return 1;
  }

  do {
    testptr = testwords;
    do {
      apply(*testptr++, ruleptr->value, 3);
      if (rule_errno) {
        printf("Invalid single crack mode rule: %s (in john.ini, line %d)\n",
          ruleptr->value, ruleptr->linenum);
        return 1;
      }
    } while (*testptr);
  } while (ruleptr = ruleptr->next);

  if (!(s = cfg_getl("List.Rules:Wordlist")) ||
    !(ruleptr = rules_w = s->list) || (rulecount_w = s->listcount) < 1)
  {
    puts("Invalid wordlist mode rules definition"); return 1;
  }

  do {
    testptr = testwords;
    do {
      apply(*testptr++, ruleptr->value, -1);
      if (rule_errno) {
        printf("Invalid wordlist mode rule: %s (in john.ini, line %d)\n",
          ruleptr->value, ruleptr->linenum);
        return 1;
      }
    } while (*testptr);
  } while (ruleptr = ruleptr->next);

  return 0;
}

void inithash(struct account *currentsalt) {
  register struct account *current, *last;
  register unsigned long index;

  (current = currentsalt)->salt->countpersalt = 0;
  do currentsalt->salt->countpersalt++; while (current = current->next);

  if (currentsalt->salt->hashsize && currentsalt->salt->countpersalt < hashfallback) {
#ifdef DEBUG
    puts("DEBUG: hash fallback");
#endif
    currentsalt->salt->hashsize = 0; currentsalt->salt->hashfunc = hashfunc0;
  }

  if ((current = currentsalt)->salt->hashsize) {
    bzero(*(currentsalt->salt->hash), currentsalt->salt->hashsize);

    switch (currentsalt->salt->hashsize) {
      case 16 * sizeof(struct account *):
        currentsalt->salt->hashfunc = hashfunc1;
        break;
      case 16 * 16 * sizeof(struct account *):
        currentsalt->salt->hashfunc = hashfunc2;
        break;
      case 16 * 16 * 16 * sizeof(struct account *):
        currentsalt->salt->hashfunc = hashfunc3;
    }

    do {
      crypt_binary(current->passwd, !singlecrack);
      index = ((unsigned char)crypt_cbin[1]) >> hashift1;
      if (currentsalt->salt->hashsize >= 16 * 16 * sizeof(struct account *)) {
        index |= ((unsigned short)crypt_cbin[1]) >> hashift2;
        if (currentsalt->salt->hashsize >= 16 * 16 * 16 * sizeof(struct account *))
        index |= (crypt_cbin[1] >> hashift3) & 0xF00;
      }

      last = (*(currentsalt->salt->hash))[index];
      (*(currentsalt->salt->hash))[index] = current;
      current->nexthash = last;
    } while (current = current->next);
  } else {
    (struct account *)current->salt->hash = current;
    while (current = current->nexthash = current->next);
  }
}

int readpot() {
  char s[256];
  char *p;
  register unsigned long salt;
  register struct account *current, *last;
  int count;

  sprintf(pot, "%s%s", johnpath, "john.pot");

  if (fpot = fopen(pot, "r")) {
    while (fgets(s, sizeof(s), fpot)) {
      if (show || makechars) {
        if (p = strchr(s, '\r')) *p = 0;
        if (p = strchr(s, '\n')) *p = 0;

        if (strlen(s) <= 13 || s[13] != ':') continue;
        s[13 + 1 + 8] = 0;

        if (pwfiles) {
          last = salts[salt = crypt_getsalt(s)];
          if (!(csalts[salt] = (struct cracked *)malloc_tiny(sizeof(struct cracked)))) {
            puts("Not enough free memory"); return 1;
          }
          strcpy((csalts[salt])->passwd, s);
          (csalts[salt])->next = (struct cracked *)last;
        } else if (addlist(&words, s + 14, 0)) return 1;
      } else {
        last = NULL;
        if (strlen(s) >= 13 && (current = salts[salt = crypt_getsalt(s)])) do {
          if (((*(int *)current->passwd) != (*(int *)s)) ||
            memcmp(current->passwd, s, 13)) last = current; else {
            if (last) last->next = current->next; else
            if (!(salts[salt] = current->next)) asalt--;
            acount--;
          }
        } while (current = current->next);
      }
    }
    fclose(fpot);
  }

  if (show || makechars) return 0;

  for (salt = 0; salt < 4096; salt++) {
    count = 0;
    if (current = salts[salt]) do
      count++;
    while (current = current->next);
    if (count) {
      if (count < minsalts || minsalts < 0 && count >= -minsalts) {
        salts[salt] = NULL;
        acount -= count; asalt--;
      } else
      if (nohash || count < hashmin1) salts[salt]->salt->hashsize = 0; else
      if (count < hashmin2) salts[salt]->salt->hashsize = 16 * sizeof(struct account *); else
      if (count < hashmin3) salts[salt]->salt->hashsize = 16 * 16 * sizeof(struct account *);
      else salts[salt]->salt->hashsize = 16 * 16 * 16 * sizeof(struct account *);
    }
  }

  last = NULL;
  for (salt = 0; salt < 4096; salt++) {
    if (!(current = salts[salt])) continue;
    if (last) last->salt->nextsalt = current; else accounts = current;
    if (current->salt->hashsize)
    if (!(current->salt->hash = (salthash *)malloc(current->salt->hashsize))) {
      puts("Not enough free memory"); return 1;
    }
    inithash(last = current);
  }
  if (last) last->salt->nextsalt = NULL;

  return 0;
}

char *asciitime(time_t time) {
  static char buf[32];
  long fwpos;

  if (realtime)
  sprintf(buf, "t: %lu:%02lu:%02lu:%02lu",
    (long)time / 86400,
    (long)time % 86400 / 3600,
    (long)time % 3600 / 60,
    (long)time % 60);
  else
  sprintf(buf, "s: %lu", (long)time);

  if (percent && (
    singlecrack && rulecount_s > 9 ||
    fwsize && (fwpos = ftell(fw)) >= 0))
  sprintf(buf + strlen(buf), " %d%%",
    singlecrack ? rulenum * 100 / rulecount_s :
    rules ? (rulenum * 100 + (int)((long long)fwpos * 100 / (fwsize + 1))) / rulecount_w :
    (int)((long long)fwpos * 100 / (fwsize + 1)));

  return buf;
}

void showstatus() {
  char range[32];
  char *p;

  if (totalcrypts < 0xFF000000) totalcrypts += addedcrypts / 1000;
  addedcrypts %= 1000;

  if (keyindex && asalt > 1) sprintf(range, "%s - %s", wordcache[0], wordcache[keyindex - 1]);
  else strcpy(range, word);

  for (p = range; *p; p++)
  if (*p < ' ') *p = ' '; else *p &= 0x7F;

  if ((timediff = time(NULL) - starttime) && totalcrypts)
  if (totalcrypts < 0xFF000000)
  printf("v: %lu  c: %lu%03lu  %s  c/s: %lu  w: %s\n",
    guessed, totalcrypts, addedcrypts, asciitime(timediff),
    (totalcrypts / timediff) * 1000 +
    ((totalcrypts % timediff) * 1000 + addedcrypts) / timediff,
    range);
  else
  printf("v: %lu  c: OVERFLOW  %s  c/s: UNKNOWN  w: %s\n",
    guessed, asciitime(timediff), range);
}

void checkkeyboard() {
  if (addedcrypts >= checkdelay) {
    if (totalcrypts < 0xFF000000) totalcrypts += addedcrypts / 1000;
    addedcrypts %= 1000;

    if (((curtick = dostime()) - lasttick1 > 60 * 100) || (curtick < lasttick1)) {
      lasttick1 = curtick;
      if ((curtick - lasttick10 > savedelay) || (curtick < lasttick10)) {
        lasttick10 = curtick; writerestore();
      }
      if ((time(NULL) - starttime) / 60 >= timeout) stop = -1;
    }

    if (keypressed())
    if (timediff = (curtime = time(NULL)) - starttime) {
      do readkey(); while (keypressed());
      showstatus();
    }
  }
}

#define setword() if (listwords) puts(word); crypt_setkey(word);

void showguessed(struct account *guess, struct account *salt, char *word) {
  register struct account *current;

  if (beep) fprintf(stderr, "\007");
  printf("%-9s(%s)\n", word, noname ? "?" : guess->login);
  fwrite(guess->passwd, 13, 1, fpot);
  fprintf(fpot, ":%s\n", word);

#ifdef DEBUG
  {
    crypt_bin save_cout;
    char saveKS[KEYSIZE];
    char savelastpw[16];

    memcpy(save_cout, crypt_cout, crypt_binsize);
    copykey(saveKS, KS); memcpy(savelastpw, lastpw, sizeof(savelastpw));

    bzero(lastpw, sizeof(lastpw));
    crypt_setkey(word);

    if (memcmp(crypt_check(crypt_fixsalt(crypt_getsalt(guess->passwd))), crypt_binary(guess->passwd, 0), crypt_binsize))
      puts("ERROR: guessed password check failed");

    memcpy(crypt_cout, save_cout, crypt_binsize);
    copykey(KS, saveKS); memcpy(lastpw, savelastpw, sizeof(lastpw));
  }
#endif

  if (guess != salt) {
#ifdef DEBUG
    if (salt != accounts) puts("DEBUG: guess!=salt && salt!=accounts");
    else puts("DEBUG: guess!=salt && salt==accounts");
#endif
    current = salt;
    while (current->next != guess) {
      current = current->next;
#ifdef DEBUG
      if (!current) puts("ERROR: guessed password is non-existent or already-guessed or has a wrong salt");
#endif
    }
    current->next = guess->next;
  } else if (salt != accounts) {
#ifdef DEBUG
    puts("DEBUG: guess==salt && salt!=accounts");
#endif
    current = accounts;
    while (current->salt->nextsalt != salt) current = current->salt->nextsalt;
    if (salt->next) current->salt->nextsalt = salt->next; else {
      current->salt->nextsalt = salt->salt->nextsalt; asalt--;
    }
  } else if (salt->next) {
#ifdef DEBUG
    puts("DEBUG: guess==salt && salt==accounts && salt->next");
#endif
    accounts = salt->next;
  } else {
#ifdef DEBUG
    puts("DEBUG: guess==salt && salt==accounts && !salt->next");
#endif
    accounts = salt->salt->nextsalt; asalt--;
  }

  guessed++; acount--;

  if (current = accounts) {
    do if (current->salt == salt->salt) break; while (current = current->salt->nextsalt);
    if (current) inithash(current);
  }

#ifdef DEBUG
  debug_check();
#endif
}

/*
 * Apply rule to a word. This implementation is a lot faster than Crack's due
 * to exchanging pointers between rules instead of doing a strcpy(), and using
 * table lookups instead of a strchr() for character classes. This might be
 * important when cracking only a few salts.
 *
 * special > 0    "single crack" mode, special is the 2nd word's position
 * special == 0   "single crack" mode, only one word
 * special < 0    other cracking modes, "single crack" mode rules are invalid
 */

char *apply(char *word, char *rule, int special) {
  static char buf1[256], buf2[256];
  char buf3[128];
  int which;
  char *in = buf1, *out = buf2;
  register int ipos, opos;
  int ccnt, rcnt;

  char *kc_s =  "`1234567890-=\\qwertyuiop[]asdfghjkl;'zxcvbnm,./"
                "~!@#$%^&*()_+|QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>?";
  char *kc_di = "~!@#$%^&*()_+|QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>?"
                "`1234567890-=\\qwertyuiop[]asdfghjkl;'zxcvbnm,./";
  char *kc_dI = "`1234567890-=\\QWERTYUIOP[]ASDFGHJKL;'ZXCVBNM,./"
                "~!@#$%^&*()_+|qwertyuiop{}asdfghjkl:\"zxcvbnm<>?";
  char *kc_dv = "`1234567890-=\\QWeRTYuioP[]aSDFGHJKL;'ZXCVBNM,./"
                "~!@#$%^&*()_+|QWeRTYuioP{}aSDFGHJKL:\"ZXCVBNM<>?";
  char *kc_dr = "1234567890-=\\\\wertyuiop[]]sdfghjkl;''xcvbnm,./\\"
                "!@#$%^&*()_+||WERTYUIOP{}}SDFGHJKL:\"\"XCVBNM<>?|";
  char *kc_dl = "``1234567890-=qqwertyuiop[aasdfghjkl;zzxcvbnm,."
                "~~!@#$%^&*()_+QQWERTYUIOP{AASDFGHJKL:ZZXCVBNM<>";

  static char kc_all[256];
  static unsigned char kc_cur = 0;

  void kc_init(char *kc_d) {
    int pos;
    char *s = kc_s;

    for (pos = 0; pos < 256; pos++) kc_all[pos] = pos;
    do kc_all[*s++] = *kc_d++; while (*s);
  }

  void kc_initclass(char *class, int invert) {
    memset(kc_all, invert != 0, sizeof(kc_all)); invert = !invert;
    while (*class) kc_all[*class++] = invert;
  }

  void kc_conv(char mode, char *src, char *dst) {
    int pos;

    if (mode != kc_cur)
    switch (kc_cur = mode) {
      case 'i': kc_init(kc_di); break;
      case 'I': kc_init(kc_dI); break;
      case 'v': kc_init(kc_dv); break;
      case '>': kc_init(kc_dr); break;
      case '<': kc_init(kc_dl);
    }

    for (pos = 0; dst[pos] = kc_all[src[pos]]; pos++);
  }

  void setclass(unsigned char classid) {
    register char *class;

    if (kc_cur == classid + 0x80) return;

    switch (tolower(classid)) {
      case '?':
        class = "?";
        break;
      case 'v':
        class = "aeiouAEIOU";
        break;
      case 'c':
        class = "bcdfghjklmnpqrstvwxyzBCDFGHJKLMNPQRSTVWXYZ";
        break;
      case 'w':
        class = " \t";
        break;
      case 'p':
        class = ".,:;'\"?!`";
        break;
      case 's':
        class = "$%^&*()-_+=|\\<>[]{}#@/~";
        break;
      case 'l':
        class = "abcdefghijklmnopqrstuvwxyz";
        break;
      case 'u':
        class = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        break;
      case 'd':
        class = "0123456789";
        break;
      case 'a':
        class = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        break;
      case 'x':
        class = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        break;
      default:
        if (!rule_errno) rule_errno = 2;
        class = "";
    }

    kc_initclass(class, isupper(classid));
    kc_cur = classid + 0x80;
  }

  strcpy(in, word);
  if (*rule == ':' && !*(rule + 1)) {
    in[8] = 0; return in;
  }

  which = 0;
  do {
    if (!in[0] || !in[1]) return NULL;

    switch (*rule++) {
/* Crack v4.1 rules */
      case ':':
        in[8] = 0; return in;
      case '<':
        if (strlen(in) >= (*rule++) - '0') return NULL; else out = in;
        break;
      case '>':
        if (strlen(in) <= (*rule++) - '0') return NULL; else out = in;
        break;
      case 'l':
        for (ipos = 0; out[ipos] = tolower(in[ipos]); ipos++);
        break;
      case 'u':
        for (ipos = 0; out[ipos] = toupper(in[ipos]); ipos++);
        break;
      case 'c':
        out[0] = toupper(in[0]);
        for (ipos = 1; out[ipos] = tolower(in[ipos]); ipos++);
        if (out[0] == 'M' && out[1] == 'c') out[2] = toupper(out[2]);
        break;
      case 'r':
        out[opos = strlen(in)] = 0;
        for (ipos = 0; in[ipos]; ipos++) out[--opos] = in[ipos];
        break;
      case 'd':
        strcpy(out, in); strcat(out, in);
        break;
      case 'f':
        out = in;
        out[opos = strlen(out) << 1] = 0;
        for (ipos = 0; out[ipos]; ipos++) out[--opos] = out[ipos];
        break;
      case '$':
        out = in;
        out[opos = strlen(out)] = *rule++; out[opos + 1] = 0;
        break;
      case '^':
        out[0] = *rule++; strcpy(&out[1], in);
        break;
      case 'x':
        if ((ipos = (*rule++) - '0') >= strlen(in)) opos = 0;
        else memcpy(out, &in[ipos], opos = ((*rule++) - '0'));
        out[opos] = 0;
        break;
      case 'i':
        if ((ipos = (*rule++) - '0') >= (opos = strlen(in))) {
          out = in; out[opos++] = *rule++; out[opos] = 0;
        } else {
          memcpy(out, in, ipos); out[ipos] = *rule++;
          strcpy(&out[ipos + 1], &in[ipos]);
        }
        break;
      case 'o':
        out = in; opos = (*rule++) - '0'; out[opos] = *rule++;
        break;
      case 's':
        out = in;
        if (*rule == '?') {
          setclass(*++rule);
          for (opos = 0; out[opos]; opos++)
          if (kc_all[out[opos]]) out[opos] = *(rule + 1);
        } else {
          for (opos = 0; out[opos]; opos++)
          if (out[opos] == *rule) out[opos] = *(rule + 1);
        }
        rule += 2;
        break;
      case '@':
        if (*rule == '?') {
          setclass(*++rule);
          for (opos = ipos = 0; in[ipos]; ipos++)
          if (!kc_all[in[ipos]]) out[opos++] = in[ipos];
        } else {
          for (opos = ipos = 0; in[ipos]; ipos++)
          if (in[ipos] != *rule) out[opos++] = in[ipos];
        }
        out[opos] = 0; rule++;
        break;
      case '!':
        if (*rule == '?') {
          setclass(*++rule);
          for (ipos = 0; in[ipos]; ipos++)
          if (kc_all[in[ipos]]) return NULL;
        } else {
          for (ipos = 0; in[ipos]; ipos++)
          if (in[ipos] == *rule) return NULL;
        }
        out = in; rule++;
        break;
      case '/':
        if (*rule == '?') {
          setclass(*++rule);
          for (ipos = 0; in[ipos]; ipos++)
          if (kc_all[in[ipos]]) break;
        } else {
          for (ipos = 0; in[ipos]; ipos++)
          if (in[ipos] == *rule) break;
        }
        if (!in[ipos]) return NULL;
        out = in; rule++;
        break;
      case '=':
        if ((ipos = (*rule++) - '0') >= strlen(in)) return NULL;
        if (*rule == '?') {
          setclass(*++rule); rule++;
          if (!kc_all[in[ipos]]) return NULL;
        } else if (in[ipos] != *rule++) return NULL;
        out = in;
        break;
      case 'p':
        out = in;
        if (strchr("hsx", out[opos = strlen(out) - 1])) strcat(out, "es"); else
        if (out[opos] == 'f' && out[opos - 1] != 'f') strcpy(out + opos, "ves"); else
        if (opos > 1 && out[opos] == 'e' && out[opos - 1] == 'f') strcpy(out + opos - 1, "ves"); else
        if (opos > 1 && out[opos] == 'y')
        if (strchr("aeiou", out[opos - 1])) strcat(out, "s");
        else strcpy(out + opos, "ies");
        else strcat(out, "s");
        break;

/* Additional rules added in John */
      case 'P':
        out = in;
        if (out[opos = strlen(out) - 1] == 'd' && out[opos - 1] == 'e') break;
        if (out[opos] == 'y') out[opos] = 'i'; else
        if (strchr("bgp", out[opos]) && !strchr("bgp", out[opos - 1])) {
          out[opos + 1] = out[opos]; out[opos + 2] = 0;
        }
        if (out[opos] == 'e') strcat(out, "d"); else strcat(out, "ed");
        break;
      case 'G':
        out = in;
        if ((opos = strlen(out) - 1) < 2 || out[opos] == 'g' && out[opos - 1] == 'n' && out[opos - 2] == 'i') break;
        if (strchr("aeiou", out[opos])) strcpy(out + opos, "ing"); else {
          if (strchr("bgp", out[opos]) && !strchr("bgp", out[opos - 1])) {
            out[opos + 1] = out[opos]; out[opos + 2] = 0;
          }
          strcat(out, "ing");
        }
        break;
      case '{':
        strcpy(out, &in[1]); in[1] = 0; strcat(out, in);
        break;
      case '}':
        out[0] = in[opos = strlen(in) - 1]; in[opos] = 0; strcpy(&out[1], in);
        break;
      case 'D':
        if ((ipos = (*rule++) - '0') >= strlen(in)) return NULL;
        memcpy(out, in, ipos); strcpy(out, &in[ipos + 1]);
        break;
      case '~':
        kc_conv(*rule++, in, out);
        break;

/* Additional "single crack" mode rules */
      case '1':
      case '2':
        if (special < 0 && !rule_errno) rule_errno = 3;
        if (special <= 0) return NULL;
        if (which) strcpy(buf3, in);
        if (*(rule - 1) == '1') {
          if (!which) strcpy(buf3, &word[special]);
          memcpy(out, word, special); out[special] = 0; which = 1;
        } else {
          if (!which) {
            memcpy(buf3, word, special); buf3[special] = 0;
          }
          strcpy(out, &word[special]); which = 2;
        }
        break;
      case '+':
        if (!which) {
          if (!rule_errno) rule_errno = 3; return NULL;
        }
        if (which == 1) strcat(out = in, buf3);
        else sprintf(out, "%s%s", buf3, in);
        which = 0;
        break;

/* Crack v5.0 compatibility rules */
      case '[':
        strcpy(out, &in[1]);
        break;
      case ']':
        *(strchr((out = in), 0) - 1) = 0;
        break;
      case 'C':
        out[0] = tolower(in[0]);
        for (ipos = 1; out[ipos] = toupper(in[ipos]); ipos++);
        if (out[0] == 'm' && out[1] == 'C') out[2] = tolower(out[2]);
        break;
      case 't':
        kc_conv('I', in, out);
        break;
      case '(':
        if (in[0] != *rule++) return NULL;
        out = in;
        break;
      case ')':
        if (*(strchr(in, 0) - 1) != *rule++) return NULL;
        out = in;
        break;
      case '\'':
        (out = in)[(*rule++ - '0')] = 0;
        break;
      case '%':
        ccnt = 0; rcnt = (*rule++) - '0';
        if (*rule == '?') {
          setclass(*++rule);
          for (ipos = 0; in[ipos]; ipos++)
          if (kc_all[in[ipos]])
          if (++ccnt >= rcnt) break;
        } else {
          for (ipos = 0; in[ipos]; ipos++)
          if (in[ipos] == *rule)
          if (++ccnt >= rcnt) break;
        }
        if (ccnt < rcnt) return NULL;
        out = in; rule++;
        break;

/* Invalid rules will most likely get caught at startup */
      default:
        if (!rule_errno) rule_errno = 1;
        return NULL;
    }

    out[127] = 0;
    if ((in = out) == buf2) out = buf1; else out = buf2;
  } while (*rule);

  if (which)
  if (which == 1) strcat(in, buf3); else {
    sprintf(out, "%s%s", buf3, in); in = out;
  }

  in[8] = 0;
  if (strcmp(in, word) && in[0]) return in; else return NULL;
}

int do_cache_crack() {
  register struct account *current, *samesalt;
  register struct saltinfo *salt, *lastsalt;
  register int do_keyindex;

  addedcrypts += (salt = accounts->salt)->countpersalt * keyindex;

  if (current = salt->nextsalt) {
    do {
      checkkeyboard();
      if (stop) return 1;

      lastsalt = salt;
      crypt_setsalt((salt = current->salt)->salt);
      addedcrypts += salt->countpersalt * keyindex;

      if (lamesalts)
      for (do_keyindex = 0; do_keyindex < keyindex; do_keyindex++) {
        if (*(short *)wordcache[do_keyindex] != *(short *)current->passwd)
          continue;

        copykey(KS, keycache[do_keyindex]);
        XForm2();

        if (samesalt = salt->hashfunc(salt)) do {
          if (crypt_cout[0] == samesalt->binary)
          if (!memcmp(crypt_cout, crypt_binary(samesalt->passwd, -1), crypt_binsize)) {
            showguessed(samesalt, current, wordcache[do_keyindex]);
            if (!acount) {
              lastid = 0xFFFF; strcpy(word, worddone); return 0;
            }
            if (current != lastsalt->nextsalt) goto nextsalt;
          }
        } while (samesalt = samesalt->nexthash);
      }
      else
      for (do_keyindex = 0; do_keyindex < keyindex; do_keyindex++) {
        copykey(KS, keycache[do_keyindex]);
        XForm2();

        if (samesalt = salt->hashfunc(salt)) do {
          if (crypt_cout[0] == samesalt->binary)
          if (!memcmp(crypt_cout, crypt_binary(samesalt->passwd, -1), crypt_binsize)) {
            showguessed(samesalt, current, wordcache[do_keyindex]);
            if (!acount) {
              lastid = 0xFFFF; strcpy(word, worddone); return 0;
            }
            if (current != lastsalt->nextsalt) goto nextsalt;
          }
        } while (samesalt = samesalt->nexthash);
      }
nextsalt:
    } while (current = salt->nextsalt);

    crypt_setsalt(accounts->salt->salt);
  } else checkkeyboard();

  return keyindex = 0;
}

void do_wordlist_crack() {
  register struct account *samesalt;
  register struct saltinfo *salt;
  char srcword[sizeof(word)], last[16];
  char *p, *resword;

  lasttick1 = lasttick10 = dostime();

  if (!lastrule) lastrule = ruleptr = rules_w;
  strcpy(lastword, word);
  do {
    crypt_setsalt(accounts->salt->salt);

    strcpy(last, "\n");
    while (fgets(srcword, sizeof(srcword), fw)) {
      if (srcword[0] == '#')
      if (!strncmp(srcword, "#!comment:", 10)) continue;

      if (p = strchr(srcword, '\r')) *p = 0;
      if (p = strchr(srcword, '\n')) *p = 0;

      if (rules)
      if (resword = apply(srcword, ruleptr->value, -1)) strcpy(word, resword);
      else continue;
      else memcpy(word, srcword, 8);
      word[8] = 0;
      if (!strcmp(last, word)) continue;
      callext("filter"); if (!word[0]) continue;
      memcpy(last, word, sizeof(last));

      if (lamesalts && !(*lamesalts)[word[1] & 0x7F][word[0] & 0x7F]) {
        addedcrypts += acount;
        continue;
      }

      setword();
      copykey(keycache[keyindex], KS);
      memcpy(wordcache[keyindex++], word, 12);

      if (!lamesalts || *(short *)word == *(short *)accounts->passwd) {
        XForm2();

        if (samesalt = (salt = accounts->salt)->hashfunc(salt)) do {
          if (crypt_cout[0] == samesalt->binary)
          if (!memcmp(crypt_cout, crypt_binary(samesalt->passwd, -1), crypt_binsize)) {
            if (!do_cache_crack()) {
              strcpy(lastword, srcword); lastrule = ruleptr;
            }
            showguessed(samesalt, accounts, word);
            if (!acount) {
              strcpy(word, worddone); strcpy(lastword, word); return;
            }
            crypt_setsalt(accounts->salt->salt);
          }
        } while (samesalt = samesalt->nexthash);
      }

      if (keyindex >= keycachesize)
      if (do_cache_crack()) break; else {
        strcpy(lastword, srcword); lastrule = ruleptr;
      }

      if (stop) break;
    }
    if (stop) break;

    if (rules && ruleptr->next) fseek(fw, 0, SEEK_SET);

    rulenum++;
  } while (rules && (ruleptr = ruleptr->next));
  if (!ruleptr) rulenum--;

  if (!stop) {
    strcpy(word, worddone);
    if (!do_cache_crack()) {
      strcpy(lastword, word); lastrule = ruleptr;
    }
  }
}

void do_single_crack() {
  register struct account *current, *samesalt, *currentsalt;
  register struct saltinfo *salt;

  #define maxlwcountlog 2
  #define maxlwcount (1 << maxlwcountlog)
  char lastwords[maxlwcount][16];
  int lwcount, lwptr, lwindex, lwmatch;

  char *pos1, *pos2, *gecos, *resword;
  int gecosi;

  int pass, wordcount, word1, word2, special;
  #define maxwscount 4
  char wordstack[maxwscount][16];

  char validchars[256];
  int validchar;

#ifdef DEBUG
  int rulehits;
#endif

  bzero(validchars, sizeof(validchars));
  for (validchar = 'a'; validchar <= 'z'; validchars[validchar++]--);
  for (validchar = 'A'; validchar <= 'Z'; validchars[validchar++]--);
  for (validchar = '0'; validchar <= '9'; validchars[validchar++]--);
  validchars['_']--;

  lasttick1 = lasttick10 = dostime();
  word[8] = 0;

  if (!ruleptr) ruleptr = rules_s;
  do {
    currentsalt = accounts;
    if (lastsalt < 0xF000)
    do if (currentsalt->salt->salt >= lastsalt) break;
    while (currentsalt = currentsalt->salt->nextsalt);

#ifdef DEBUG
    rulehits = 0;
#endif

    if (current = currentsalt)
    do {
      saltvalue = (salt = current->salt)->fixedsalt; lastsalt = salt->salt;

      lwcount = lwptr = 0;
      do {
        for (pos1 = current->login, pos2 = word; *pos1 && *pos1 != ':'; *pos2++ = *pos1++); *pos2 = 0;
        gecos = current->gecos;
        wordcount = 0; word1 = -1; word2 = maxwscount;

        for (pass = 0; pass <= 2; pass++)
        do {
          if (stop) break;

          special = 0;
          if (pass) {
            do {
              if (++word2 >= wordcount) {
                word1++; word2 = 0;
              }
              if (word1 == word2)
              if (++word2 >= wordcount) break;
            } while (pass == 1 &&
              (strlen(wordstack[word1]) > 7 || !wordstack[word1][1]) ||
              !isalpha(wordstack[word1][0]));
            if (word2 >= wordcount) {
              word1 = -1; word2 = maxwscount; break;
            }
            if (pass == 1) {
              special = strlen(strcpy(word, wordstack[word1]));
              strcat(word, wordstack[word2]);
            } else {
              word[0] = wordstack[word1][0]; strcpy(word + 1, wordstack[word2]);
            }
          }

          if (resword = apply(word, ruleptr->value, special)) {
            lwmatch = -1;
            for (lwindex = 0; lwindex < lwcount; lwindex++)
            if (!strcmp(lastwords[lwindex], resword)) { lwmatch++; break; }

            if (lwmatch) {
              strcpy(lastwords[lwptr++], resword);
              lwptr &= maxlwcount - 1; if (lwcount < maxlwcount) lwcount++;

              if (lamesalts && *(short *)resword != *(short *)current->passwd) {
                if (listwords) puts(resword);
                checkkeyboard();
              } else {
                strcpy(word, resword);
                callext("filter"); if (!word[0]) goto nextword;

                setword();
                checkkeyboard();

                XForm1();

                if (samesalt = salt->hashfunc(salt)) do {
                  if (crypt_cout[0] == samesalt->binary)
                  if (!memcmp(crypt_cout, crypt_binary(samesalt->passwd, 0), crypt_binsize)) {
                    showguessed(samesalt, currentsalt, word);
#ifdef DEBUG
                    rulehits++;
#endif
                    if (!acount) {
                      strcpy(word, worddone); lastsalt = 0xFFFF; return;
                    }

                    {
                      register struct account *currentw, *samesaltw;
                      register struct saltinfo *saltw;

                      addedcrypts += acount;

                      currentw = accounts;
                      do {
                        if ((saltw = currentw->salt) != salt) {
                          saltvalue = saltw->fixedsalt;
                          XForm1();

                          if (samesaltw = saltw->hashfunc(saltw)) do {
                            if (crypt_cout[0] == samesaltw->binary)
                            if (!memcmp(crypt_cout, crypt_binary(samesaltw->passwd, 0), crypt_binsize)) {
                              showguessed(samesaltw, currentw, word);
#ifdef DEBUG
                              rulehits++;
#endif
                              if (!acount) {
                                strcpy(word, worddone); lastsalt = 0xFFFF; return;
                              }
                            }
                          } while (samesaltw = samesaltw->nexthash);
                        }
                      } while (currentw = saltw->nextsalt);

                      saltvalue = salt->fixedsalt;
                    }

                    if (samesalt == currentsalt)
                    if (!(currentsalt = currentsalt->next)) goto nextsalt;
                  }
                } while (samesalt = samesalt->nexthash);
              }

              addedcrypts += salt->countpersalt;
            }
          }

nextword:
          if (!pass) {
            if (gecos && *gecos) {
              for (gecosi = 0; gecosi < 15; gecosi++)
              if (!validchars[word[gecosi] = *gecos++]) break;
              word[gecosi] = 0;
              gecos--;
              while (validchars[*gecos]) gecos++;
              while (!validchars[*gecos] && *gecos) gecos++;
            } else break;

            if (wordcount < maxwscount) {
              word[15] = 0; strcpy(wordstack[wordcount++], word);
            }
          }
        } while(1);

        if (stop) break;
      } while (current = current->next);

nextsalt:
      if (stop) break;
    } while (current = currentsalt = salt->nextsalt);

#ifdef DEBUG
    printf("DEBUG: rule %s got %d hits\n", ruleptr->value, rulehits);
#endif

    if (stop) break;
    lastsalt = 0xFFFE; rulenum++;
  } while (ruleptr = ruleptr->next);
  if (!ruleptr) rulenum--;

  if (!stop) {
    strcpy(word, worddone); lastsalt = 0xFFFF;
  }
}

void do_incremental_crack() {
  char section[32], name[32], *fname;
  FILE *ff;
  unsigned char ofs[9][4];
  unsigned char prev1, prev2, buf[96];
  int bufpos, cc, lastcount;

  int maxcnt, minlen, maxlen, wordlike;
  char *charset[8][8], **currentset;
  int charcnt[8][8], currentcnt[8], currentdec[8];

  char char1[95], (*char2)[96][95], (*chars[6])[96][96][95];
  char allchars[96];

  register struct account *samesalt;
  register struct saltinfo *salt;

  int id, usecount, usechars, usepos, len, pos, wpos, startpos;
  unsigned char wordi[16], startwordi[16];

  unsigned short classcount[2], classindex;
  char vowels[128];

  void expand(char *dst, char *src) {
    char *pos1 = src, *pos2 = dst;
    char notindst[128];

    memset(notindst, -1, sizeof(notindst));
    while (*pos2) notindst[*pos2++] = 0;

    while (*pos1)
    if (notindst[*pos1]) {
      *pos2++ = *pos1++; *pos2 = 0;
    } else pos1++;
  }

  sprintf(section, "Incremental:%s", incremental);

  if ((maxcnt = cfg_geti(section, "CharCount")) < 0) maxcnt = 127;
  if ((minlen = cfg_geti(section, "MinLen")) < 0) minlen = 1;
  if ((maxlen = cfg_geti(section, "MaxLen")) < 0) maxlen = 8;
  wordlike = cfg_getb(section, "Wordlike");

  if (minlen < 1 || maxlen > 8 || minlen > maxlen ||
    maxcnt < 2 || maxcnt > 127) okay = 0;
  else
  if (fname = cfg_gets(section, "File")) {
    sprintf(fcname, "%s%s",
      *fname == '/'
#if defined(MSDOS) || defined(MSWIN)
      || *fname == '\\'
#endif
      ? "" : johnpath, fname);

    if (!(ff = fopen(fcname, "rb"))) {
      printf("Unable to open charset file: %s\n", fcname);
      okay = 0; return;
    }

    if (fread(ofs, 1, sizeof(ofs), ff) != sizeof(ofs) ||
      strncmp(ofs[0], charsign, 4)) {
      printf("Invalid charset file: %s\n", fcname);
      okay = 0; return;
    }

    fread(allchars, 1, len = fgetc(ff), ff); allchars[len] = 0;
    expand(allchars, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~");

    if (maxcnt == 127) maxcnt = len;

    if (maxlen >= 2 && !(char2 = (char (*)[][])malloc(sizeof(*char2)))) {
      puts("Not enough free memory"); okay = 0; return;
    }

    for (pos = 0; pos < maxlen - 2; pos++)
    if (!(chars[pos] = (char (*)[][][])malloc(sizeof(*chars[0])))) {
      puts("Not enough free memory"); okay = 0; return;
    }

#ifdef DEBUG
    debug_memory("after allocating charsets");
#endif
  } else
  for (len = minlen - 1; len < maxlen; len++)
  for (pos = 0; pos <= len; pos++) {
    sprintf(name, "Charset%d%d", len + 1, pos + 1);
    if (charset[len][pos] = cfg_gets(section, name))
    charcnt[len][pos] = strlen(charset[len][pos]);
    else okay = 0;
  }

  if (!okay) {
    printf("Invalid definition for incremental mode: %s\n", incremental);
    return;
  }

  bzero(vowels, sizeof(vowels));
  vowels['a']++; vowels['e']++; vowels['i']++; vowels['o']++; vowels['u']++;
  vowels['A']++; vowels['E']++; vowels['I']++; vowels['O']++; vowels['U']++;

  crypt_setsalt(accounts->salt->salt);

  memcpy(startwordi, lastwordi, 8); startpos = lastpos;
  lastcount = -1;

  lasttick1 = lasttick10 = dostime();
  for (id = lastid; id < idscount; id += 2) {
    usecount = ids[id];
    if (usecount < minlen || usecount > maxlen) continue;
    if ((usechars = ids[id + 1]) >= maxcnt) continue;

    if (fname && usecount != lastcount) {
      lastcount = usecount;

      char1[0] = 0;
      if (usecount >= 2) bzero(char2, sizeof(*char2));
      for (pos = 0; pos < usecount - 2; pos++)
        bzero(chars[pos], sizeof(*chars[0]));

#ifdef DEBUG
      debug_memory("while cracking");
#endif

      fseek(ff,
        (long)ofs[usecount][0] + ((long)ofs[usecount][1] << 8) +
        ((long)ofs[usecount][2] << 16) + ((long)ofs[usecount][3] << 24),
        SEEK_SET);

      pos = -1; cc = fgetc(ff);
      do {
        if (cc & 0x80)
        if (cc < 0xA0) {
          if ((cc & 0x7F) != usecount - 1) break;
          pos = fgetc(ff) & 0x7F;
        } else {
          if (pos < 0) break;

          prev1 = (cc & 0x7F) - ' ';
          if (pos > 1) prev2 = (fgetc(ff) & 0x7F) - ' ';
        }

        else {
          buf[bufpos = 0] = cc;

          while ((buf[++bufpos] = cc = fgetc(ff)) < 0x80)
          if (bufpos >= 95) {
            pos = -1; break;
          }
          if (pos < 0) break;

          buf[bufpos] = 0;

          if (!pos) strcpy(char1, buf); else
          if (pos == 1) strcpy((*char2)[prev1], buf); else
          strcpy((*chars[pos - 2])[prev1][prev2], buf);

          continue;
        }

        cc = fgetc(ff);
      } while (cc != EOF);

      if (pos < 0) {
        printf("Invalid charset file: %s\n", fcname);
        okay = 0; return;
      }

      expand(char1, allchars);
      for (prev1 = 0; prev1 < 95; prev1++) {
        if (usecount >= 2) {
          expand((*char2)[prev1], (*char2)[95]);
          expand((*char2)[prev1], allchars);
        }

        for (prev2 = 0; prev2 < 95; prev2++)
        for (pos = 0; pos < usecount - 2; pos++) {
          expand((*chars[pos])[prev1][prev2], (*chars[pos])[95][prev2]);
          expand((*chars[pos])[prev1][prev2], (*chars[pos])[95][95]);
          expand((*chars[pos])[prev1][prev2], allchars);
        }
      }
    }

    wpos = usecount;
    for (usepos = startpos; usepos < usecount; usepos++) {
      if (fname)
      for (pos = 0; pos < usecount; pos++) currentcnt[pos] = usechars;
      else {
        if (usechars >= charcnt[usecount - 1][usepos]) continue;

        currentset = charset[usecount - 1];
        for (pos = 0; pos < usecount; pos++)
          currentcnt[pos] = min(usechars, charcnt[usecount - 1][pos] - 1);
      }

      for (pos = 0; pos < usecount; pos++) currentdec[pos] =
        (pos < usepos && currentcnt[pos] >= currentcnt[usepos]) ? 1 : 0;
      for (pos = 0; pos < usecount; pos++) currentcnt[pos] -= currentdec[pos];

      startpos = usepos;
      memcpy(wordi, startwordi, 8); wordi[usepos] = usechars;

      word[usecount] = 0;
      do {
        if (fname) {
          word[0] = char1[wordi[0]];
          if (usecount >= 2) word[1] = (*char2)[word[0] - ' '][wordi[1]];
          for (pos = 2; pos < usecount; pos++)
            word[pos] = (*chars[pos - 2])[word[pos - 2] - ' '][word[pos - 1] - ' '][wordi[pos]];
        } else
        for (pos = 0; pos < usecount; pos++)
          word[pos] = currentset[pos][wordi[pos]];

        if (wordlike) {
          *(long *) & classcount = 0;
          for (wpos = 0; wpos < usecount; wpos++) {
            classcount[classindex = vowels[word[wpos]]]++;
            classcount[classindex ^ 1] = 0;
            if (classcount[0] > 2 || classcount[1] > 1) break;
          }
        }

        if (wpos == usecount) {
          if (lamesalts && !(*lamesalts)[word[1] & 0x7F][word[0] & 0x7F]) {
            addedcrypts += acount;
            checkkeyboard();
          } else {
            callext("filter"); if (!word[0]) goto nextword;

            if (keyindex >= keycachesize)
            if (do_cache_crack()) break; else {
              lastid = id; lastpos = usepos; memcpy(lastwordi, wordi, 8);
            }

            setword();
            copykey(keycache[keyindex], KS);
            memcpy(wordcache[keyindex++], word, 12);

            if (!lamesalts || *(short *)word == *(short *)accounts->passwd) {
              XForm2();

              if (samesalt = (salt = accounts->salt)->hashfunc(salt)) do {
                if (crypt_cout[0] == samesalt->binary)
                if (!memcmp(crypt_cout, crypt_binary(samesalt->passwd, -1), crypt_binsize)) {
                  if (!do_cache_crack()) {
                    lastid = id; lastpos = usepos; memcpy(lastwordi, wordi, 8);
                  }
                  showguessed(samesalt, accounts, word);
                  if (!acount) {
                    lastid = 0xFFFF; strcpy(word, worddone); return;
                  }
                  crypt_setsalt(accounts->salt->salt);
                }
              } while (samesalt = samesalt->nexthash);
            }
          }
        }

nextword:
        if (stop) break;

        if (usecount == 1) pos = (wordi[0]++ >= currentcnt[0]) ? 1 : 0; else
        for (pos = 0; pos < usecount; pos++) {
          if (pos == usepos) continue;
          if (wordi[pos]++ < currentcnt[pos]) break; else wordi[pos] = 0;
        }
      } while (pos < usecount);

      if (!usechars || stop) break;
      bzero(startwordi, 8);
    }

    if (stop) break;
    startpos = 0;
  }

  if (!stop) {
    strcpy(word, worddone);
    if (!do_cache_crack()) lastid = 0xFFFF;
  }
}

void do_external_crack() {
  register struct account *samesalt;
  register struct saltinfo *salt;
  register int i;

  crypt_setsalt(accounts->salt->salt);

  lasttick1 = lasttick10 = dostime();
  do {
    c_execute("generate"); if (!c_data[0]) break;
    c_execute("filter"); if (!c_data[0]) continue;
    i = 9; while (i--) word[i] = c_data[i];

    if (lamesalts && !(*lamesalts)[word[1] & 0x7F][word[0] & 0x7F]) {
      addedcrypts += acount;
      continue;
    }

    setword();
    copykey(keycache[keyindex], KS);
    memcpy(wordcache[keyindex++], word, 12);

    if (!lamesalts || *(short *)word == *(short *)accounts->passwd) {
      XForm2();

      if (samesalt = (salt = accounts->salt)->hashfunc(salt)) do {
        if (crypt_cout[0] == samesalt->binary)
        if (!memcmp(crypt_cout, crypt_binary(samesalt->passwd, -1), crypt_binsize)) {
          if (!do_cache_crack()) strcpy(lastword, word);
          showguessed(samesalt, accounts, word);
          if (!acount) {
            strcpy(word, worddone); strcpy(lastword, word); return;
          }
          crypt_setsalt(accounts->salt->salt);
        }
      } while (samesalt = samesalt->nexthash);
    }

    if (keyindex >= keycachesize)
    if (do_cache_crack()) break; else strcpy(lastword, word);
  } while (!stop);

  if (!stop) {
    strcpy(word, worddone);
    if (!do_cache_crack()) strcpy(lastword, word);
  }
}

int do_makechars() {
  FILE *ff;
  unsigned char ofs[8][4];
  long ofsl, ferror;
  unsigned char buf[96], *wordptr, best;
  int len, pos, i, j, k, l;
  unsigned long (*counts)[96][96][95], max;
  struct stringlist *current, *last;

  if (!(counts = (unsigned long (*)[][][])malloc(sizeof(*counts)))) {
    puts("Not enough free memory"); return 1;
  }

  last = NULL;
  if (current = words) do {
    if (stop) {
      puts("Aborted..."); return 0;
    }

    for (wordptr = current->name; *wordptr; wordptr++)
    if (*wordptr < ' ' || *wordptr > 0x7E) break;
    if (*wordptr) word[0] = 0; else {
      strcpy(word, current->name); callext("filter");
    }

    if (word[0]) last = current; else
    if (last) last->next = current->next; else words = current->next;
  } while (current = current->next);

  if (!(ff = fopen(fcname, "wb"))) {
    printf("Unable to open charset file: %s\n", fcname); return 1;
  }
  ferror = fwrite(charsign, 1, 4, ff);
  ferror |= fwrite(ofs, 1, sizeof(ofs), ff);

  bzero(counts, sizeof(*counts));
#ifdef DEBUG
  debug_memory("after allocating charsets");
#endif

  if (current = words) do
    for (wordptr = current->name; *wordptr; wordptr++) (*counts)[0][0][*wordptr - ' ']++;
  while (current = current->next);

  l = 0;

  do {
    for (best = max = k = 0; k < 95; k++)
    if ((*counts)[0][0][k] > max) {
      max = (*counts)[0][0][k]; best = k + ' ';
    }

    if (best) {
      (*counts)[0][0][best - ' '] = 0; buf[l++] = best;
    }
  } while (best);

  ferror |= fputc(l, ff);
  ferror |= fwrite(buf, 1, l, ff);

  for (len = 0; len < 8; len++) {
    ofs[len][0] = (ofsl = ftell(ff)); ofs[len][1] = ofsl >> 8;
    ofs[len][2] = ofsl >> 16; ofs[len][3] = ofsl >> 24;
    ferror |= ofsl;

    for (pos = 0; pos <= len; pos++) {
      if (stop) {
        fclose(ff); unlink(fcname);
        puts("Aborted..."); return 0;
      }

      ferror |= fputc(0x80 + len, ff); ferror |= fputc(0x80 + pos, ff);

      bzero(counts, sizeof(*counts));

      if (current = words)
      do if (strlen(wordptr = current->name) == len + 1) {
        (*counts)[95][95][wordptr[pos] - ' ']++;
        if (pos) (*counts)[95][wordptr[pos - 1] - ' '][wordptr[pos] - ' ']++;
        if (pos > 1) (*counts)[wordptr[pos - 2] - ' '][wordptr[pos - 1] - ' '][wordptr[pos] - ' ']++;
      } while (current = current->next);

      for (i = (pos > 1 ? 0 : 95); i < 96; i++)
      for (j = (pos ? 0 : 95); j < 96; j++) {
        l = 0;

        do {
          for (best = max = k = 0; k < 95; k++)
          if ((*counts)[i][j][k] > max) {
            max = (*counts)[i][j][k]; best = k + ' ';
          }

          if (best) {
            (*counts)[i][j][best - ' '] = 0; buf[l++] = best;
          }
        } while (best);

        if (l) {
          if (pos > 1) ferror |= fputc((i + ' ') | 0x80, ff);
          if (pos) ferror |= fputc((j + ' ') | 0x80, ff);
          ferror |= fwrite(buf, 1, l, ff);
        }
      }
    }
  }

  if (fseek(ff, 4, SEEK_SET)) ferror = -1;
  ferror |= fwrite(ofs, 1, sizeof(ofs), ff);

  if ((ferror | fclose(ff)) < 0) {
    unlink(fcname);
    printf("Unable to write charset file: %s\n", fcname); return 1;
  }

  return 0;
}

int selftest1(char *pwd, char *pwe) {
  crypt_setkey(pwd);

  keycache[1][0] = 0xDEADBEEF; copykey(keycache, KS);
  bzero(KS, KEYSIZE); copykey(KS, keycache);
  if (keycache[1][0] != 0xDEADBEEF) return -1;

  crypt_binary(pwe, 0);
  saltvalue = crypt_fixsalt(crypt_getsalt(pwe));
  XForm1();

  if (memcmp(crypt_cout, crypt_cbin, crypt_binsize)) return -1;

  crypt_binary(pwe, -1);
  crypt_setsalt(crypt_getsalt(pwe));
  XForm2();

  return memcmp(crypt_cout, crypt_cbin, crypt_binsize);
}

int selftest() {
  char **currentd = testpwd, **currente = testpwe;

  do
    if (selftest1(*currentd++, *currente++)) return 1;
  while (*currentd);

  return 0;
}

int john(int argc, char **argv) {
#ifdef MSDOS
  setcbrk(-1);
#endif

#ifdef CYGWIN32
  SetConsoleCtrlHandler((HANDLER_ROUTINE *)handler, TRUE);
#else
  signal(SIGINT, handler);
  signal(SIGTERM, handler);
#endif

  puts("\nJohn the Ripper  Version "version"  Copyright (c) 1996,97 by Solar Designer\n");

  init_des();

  if (selftest()) {
    puts("crypt() failed test"); return 1;
  }

  if (argc < 2) {
    usage(); return 0;
  }

#ifdef DEBUG
  debug_memory("at startup");
#endif

  bzero(salts, sizeof(salts));

  initpath(argv);
  if (cfg_read()) return 1;
  if (initrules()) return 1;

  switch (readoptions(argc, argv)) {
    case 3:
      puts("Invalid options combination");
    case 1:
      return 1;
    case 2:
      return 0;
  }

  if (!makechars && !pwfiles) {
    puts("No passwd files specified"); return 1;
  }

  if (show || makechars) {
    if (readpot()) return 1;
#ifdef DEBUG
    debug_memory("after loading");
#endif
    if (readpwfile()) return 1;
    if (makechars) return do_makechars();

    printf("%s%lu password%s cracked, %lu left\n",
      guessed ? "\n" : "",
      guessed, guessed != 1 ? "s" : "", acount - guessed);

    return 0;
  }

  if (singlecrack) {
    if (fw) {
      puts("No wordlist supported in single crack mode"); return 1;
    }
  } else if (incremental) {
    if (fw) {
      puts("No wordlist supported in incremental mode"); return 1;
    }
  } else if (!fw) {
    if (!extcrack)
    if (!(dfwname = cfg_gets("Defaults", "Wordfile"))) {
      puts("No cracking mode specified"); return 1;
    } else if (openwordfile(dfwname)) return 1;
  }

  if (readpwfile()) return 1;
  if (readpot()) return 1;

#ifdef DEBUG
  debug_memory("after loading");
  debug_check();
#endif

  printf("Loaded %lu password%s", acount, acount != 1 ? "s" : "");
  if (acount > 1) {
    printf(" with ");
    printf(asalt != 1 ? "%lu" : "no", asalt);
    puts(" different salts\n");
  } else puts("\n");

  if (!acount) return 0;

#if !defined(MSDOS) && !defined(MSWIN)
  if (geteuid())
#endif
  chmod(pot, 0600);
  if (!(fpot = fopen(pot, "a"))) {
    printf("Unable to open output file: %s\n", pot); return 1;
  }

#ifdef X86
#ifndef CRYPT_128K
  if (!is486()) puts(
    "Warning: a CPU with internal cache is required, but it is not detected, the\n"
    "program may run extremely slow...\n");
#endif
#endif

#ifndef MSDOS
  stdcon = fopen("/dev/tty", "r");
#endif

  starttime = time(NULL) - elapsedtime;

  if (singlecrack) do_single_crack(); else
  if (incremental) do_incremental_crack(); else
  if (fw) do_wordlist_crack(); else do_external_crack();

#ifdef DEBUG
  debug_check();
#endif

  if (okay) {
    showstatus();
    writerestore();
    if (stop) puts("Session aborted");
  }

  fclose(fpot);
  chmod(pot, 0400);

  if (fw) fclose(fw);

  return 0;
}

extern int xtract(int argc, char **argv);
extern int unshadow(int argc, char **argv);

int main(int argc, char **argv) {
  char *prg;

#ifdef MSDOS
  if (!--argc) return 1;
  prg = argv[1];
  argv[1] = argv[0]; argv++;
#else
  prg = strchr(argv[0], 0);
  while (prg > argv[0] && *prg != '/') prg--;
  if (*prg == '/') prg++;
#ifdef MSWIN
  if (!strcmp(strlwr(prg) + strlen(prg) - 4, ".exe")) prg[strlen(prg) - 4] = 0;
#endif
#endif

  if (!strcmp(prg, "xtract")) return xtract(argc, argv);
  if (!strcmp(prg, "unshadow")) return unshadow(argc, argv);
#ifdef MSDOS
  if (strcmp(prg, "john")) return 1; else
#endif
  return john(argc, argv);
}
