#include <stdio.h>
#include <string.h>

extern void *malloc_tiny(size_t size);

struct shadowinfo {
  char *login, *passwd;
  struct shadowinfo *next;
};

int unshadow(int argc, char **argv) {
  FILE *passwd, *shadow;
  struct shadowinfo *current, *hash[256];
  char s[256];
  char *p, *pe;
  int hashval;

  int hashfunc(char *login) {
    hashval = 0;
    while (*login) {
      hashval <<= 1; hashval ^= *login++;
    }
    hashval ^= hashval >> 8; return hashval &= 0xFF;
  }

  if (argc != 3) {
    puts("Usage: unshadow <passwd file> <shadow file> [> target file]");
    return 0;
  }

  if (!(passwd = fopen(argv[1], "r"))) {
    printf("Unable to open: %s\n", argv[1]); return 1;
  }
  if (!(shadow = fopen(argv[2], "r"))) {
    printf("Unable to open: %s\n", argv[2]); return 1;
  }

  memset(hash, 0, sizeof(hash));

  while (fgets(s, sizeof(s), shadow)) {
    if (p = strchr(s, '\r')) *p = 0;
    if (p = strchr(s, '\n')) *p = 0;

    if (!(p = strchr(s, ':'))) continue;
    *p++ = 0;
    if (!(pe = strchr(p, ':'))) pe = strchr(p, 0);
    if (pe - p < 1) continue;
    *pe = 0;

    current = hash[hashfunc(s)];
    if (!(hash[hashval] = malloc_tiny(sizeof(struct shadowinfo))) ||
      !(hash[hashval]->login = malloc_tiny(strlen(s) + 1)) ||
      !(hash[hashval]->passwd = malloc_tiny(strlen(p) + 1))) {
      puts("Not enough free memory"); return 1;
    }
    strcpy(hash[hashval]->login, s); strcpy(hash[hashval]->passwd, p);
    hash[hashval]->next = current;
  }
  fclose(shadow);

  while (fgets(s, sizeof(s), passwd)) {
    if (p = strchr(s, '\r')) *p = 0;
    if (p = strchr(s, '\n')) *p = 0;

    if (!(p = strchr(s, ':'))) continue;
    *p++ = 0;
    if (!(pe = strchr(p, ':'))) pe = strchr(p, 0);

    if (current = hash[hashfunc(s)]) do
      if (!strcmp(current->login, s)) break;
    while (current = current->next);

    if (current) printf("%s:%s%s\n", s, current->passwd, pe);
    else printf("%s:%s\n", s, p);
  }
  fclose(passwd);

  return 0;
}
