#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define bzero(buf, cnt) memset(buf, 0, cnt)

extern void *malloc_tiny(size_t size);

struct cfg_param {
  char name[32], value[128];
  struct cfg_param *next;
};

struct cfg_line {
  char *value;
  int linenum;
  struct cfg_line *next;
};

struct cfg_section {
  char name[32];
  int islist, listcount;
  struct cfg_param *params;
  struct cfg_line *list, *tail;
  struct cfg_section *next;
};

char *cfg_file = "john.ini";
extern char johnpath[];

struct cfg_section *cfg_list = NULL;

char *strlwr(char *s) {
  register char *pos;

  pos = s; while (*pos = tolower(*pos)) pos++;

  return s;
}

char *trim(char *s) {
  register int pos;
  register char *res;

  for (res = s; *res && isspace(*res); res++);
  for (pos = strlen(res) - 1; pos >= 0 && isspace(res[pos]); pos--); res[++pos] = 0;

  return res;
}

int cfg_read() {
  FILE *f;
  char fn[256], buf[256];
  char *ps, *pe, *pv;
  char rangechar, rangemax[8], rangepos[8];
  char rangeindex[128], rangevalues[8][128];
  int rangecount, rangenum;
  struct cfg_section *lasts;
  struct cfg_param *lastp;
  struct cfg_line *lastl;
  int linenum = 0;

  sprintf(fn, "%s%s", johnpath, cfg_file);
  if (!(f = fopen(fn, "r"))) {
    printf("Unable to open configuration file: %s\n", fn); return 1;
  }

  while (fgets(buf, sizeof(buf) - 32, f)) {
    linenum++;

    ps = trim(buf);
    if (!*ps || *ps == '#' || *ps == ';') continue;

    if (pe = strchr(ps, '\r')) *pe = 0;
    if (pe = strchr(ps, '\n')) *pe = 0;

    if (*ps == '[') {
      lasts = cfg_list;
      if (!(cfg_list = (struct cfg_section *)malloc_tiny(sizeof(struct cfg_section)))) {
        puts("Not enough free memory"); return 1;
      }
      ps++[31] = 0; if (pe = strchr(ps, ']')) *pe = 0;
      cfg_list->islist = !memcmp(strcpy(cfg_list->name, strlwr(trim(ps))), "list.", 5);
      cfg_list->listcount = 0;
      cfg_list->params = NULL; cfg_list->list = cfg_list->tail = NULL;
      cfg_list->next = lasts;
    } else if (cfg_list && (cfg_list->islist || (pv = strchr(ps, '=')))) {
      if (cfg_list->islist) {
        rangecount = 0;
        if (!memcmp(cfg_list->name, "list.rules:", 11)) {
          if (*ps == ':' && *(ps + 1)) ps++;
          ps[127] = 0; pv = buf + 128;
          do {
            if (*ps == '\\') {
              ps++; *pv++ = *ps++;
            } else
            if (*ps != '[' || rangecount >= 8) *pv++ = *ps++; else {
              ps++; rangemax[rangecount] = 0;
              do {
                if (*ps == '\\') {
                  ps++; rangevalues[rangecount][rangemax[rangecount]++] = *ps++;
                } else
                if (*ps == ']') {
                  ps++; break;
                } else
                if ((rangevalues[rangecount][rangemax[rangecount]] = *ps++) == '-') {
                  if (rangemax[rangecount])
                  for (rangechar = rangevalues[rangecount][rangemax[rangecount] - 1] + 1;
                    rangechar <= *ps; rangechar++)
                  rangevalues[rangecount][rangemax[rangecount]++] = rangechar;
                  ps++;
                } else rangemax[rangecount]++;
              } while (1);
              if (rangemax[rangecount]) {
                rangepos[rangecount] = pv - (buf + 128);
                *pv++ = rangevalues[rangecount++][0];
              }
            }
          } while (*ps);
          *pv = 0; pv = buf + 128;
          bzero(rangeindex, sizeof(rangeindex));
        } else pv = ps;

        do {
          lastl = cfg_list->tail;
          if (!(cfg_list->tail = (struct cfg_line *)malloc_tiny(sizeof(struct cfg_line))) ||
            !(cfg_list->tail->value = (char *)malloc_tiny(strlen(pv) + 1))) {
            puts("Not enough free memory"); return 1;
          }
          strcpy(cfg_list->tail->value, pv); cfg_list->tail->next = NULL;
          cfg_list->tail->linenum = linenum;
          cfg_list->listcount++;
          if (lastl) lastl->next = cfg_list->tail;
          else cfg_list->list = cfg_list->tail;

          if ((rangenum = rangecount - 1) >= 0)
          do {
            pv[rangepos[rangenum]] = rangevalues[rangenum][++rangeindex[rangenum]];
            if (rangeindex[rangenum] >= rangemax[rangenum])
              pv[rangepos[rangenum]] = rangevalues[rangenum][rangeindex[rangenum] = 0];
            else break;
          } while (rangenum--);
        } while (rangenum >= 0);
      } else {
        lastp = cfg_list->params;
        if (!(cfg_list->params = (struct cfg_param *)malloc_tiny(sizeof(struct cfg_param)))) {
          puts("Not enough free memory"); return 1;
        }
        *pv++ = 0; pv[127] = 0;
        strcpy(cfg_list->params->value, trim(pv));
        ps[31] = 0;
        strcpy(cfg_list->params->name, strlwr(trim(ps)));
        cfg_list->params->next = lastp;
      }
    } else {
      printf("Error in %s, line %d\n", fn, linenum); return 1;
    }
  }

  fclose(f);
  return 0;
}

char *cfg_gets(char *section, char *param) {
  register struct cfg_section *currents;
  register struct cfg_param *currentp;
  char sectionlower[32], paramlower[32];

  strlwr(strcpy(sectionlower, section));
  if (param) strlwr(strcpy(paramlower, param));

  if (currents = cfg_list) do if (!strcmp(currents->name, sectionlower)) {
    if (!param) return (char *)currents;
    if (currentp = currents->params) do
      if (!strcmp(currentp->name, paramlower)) return currentp->value;
    while (currentp = currentp->next);
  } while (currents = currents->next);

  return NULL;
}

int cfg_geti(char *section, char *param) {
  register char *res;

  if (res = cfg_gets(section, param)) return atoi(res); else return -1;
}

int cfg_getb(char *section, char *param) {
  register char *res;

  if (res = cfg_gets(section, param)) return tolower(res[0]) != 'n'; else return 0;
}

struct cfg_section *cfg_getl(char *section) {
  return (struct cfg_section *)cfg_gets(section, NULL);
}
