#include <stdio.h>
#include <stdlib.h>

#define allocsize 65536
#ifndef CRYPT_64BIT
#define alignsize 4
#else
#define alignsize 8
#endif

void *malloc_tiny(size_t size) {
  static char *buffer;
  static size_t bufree = 0;
  char *start;

  if (size <= bufree) {
    start = buffer;
    buffer += size + (alignsize - 1); (long)buffer &= ~(alignsize - 1);
    bufree -= buffer - start;
    return start;
  } else if (size <= allocsize) {
    if (buffer = (char *)malloc(bufree = allocsize)) return malloc_tiny(size);
    else return NULL;
  } else return (void *)malloc(size);
}
