/* mypcnfsd.x
 * By squarewave April 19th, 1994
 * never found the RPC specs for vers 1, so I wrote this up.
 * the vers 2 specs are available at tmc.edu
 * - SW
 */
 
enum arstat {
   AUTH_RES_OK = 0,         /* not only is authorization pathetic, */
   AUTH_RES_FAKE = 1,       /* it it isn't even used! */
   AUTH_RES_FAIL = 2
};
 
enum pirstat {
   PI_RES_OK=0,
   PI_RES_NO_SUCH_PRINTER=1,/* I have absolutely no idea why this is here */ 
   PI_RES_FAIL=2
};
 
enum psrstat {
   PS_RES_OK=0,
   PS_RES_ALREADY=1,          /* already queued */   
   PS_RES_NULL=2,
   PS_RES_NO_FILE=3,
   PS_RES_FAIL=4
};
 
const USERLEN = 32;
const GENERIC = 64;
const SPOOLLEN = 255;
 
typedef string myself<USERLEN>;
typedef string genstr<GENERIC>;
typedef string spool<SPOOLLEN>;
 
struct auth_args {
   myself aa_ident;
   genstr aa_password;
};
 
struct auth_res {
   enum arstat ar_stat;
   long ar_uid;
   long ar_gid;
};
 
struct pr_init_args {
   genstr pia_client;
   genstr pia_printername;
};
 
struct pr_init_res {
   enum pirstat pir_stat;
   spool pir_spooldir;
};
 
struct pr_start_args {
   genstr psa_client;
   genstr psa_printername;
   genstr psa_username;
   genstr psa_filename;
   genstr psa_options;
};
 
struct pr_start_res {
   enum psrstat psr_stat;
};
 
program PCNFSD {
   version PCNFSD_VERS {
      void
      PCNFSD_NULL(void) = 0;
 
      auth_res
      PCNFSD_AUTH(auth_args) = 1;
 
      pr_init_res
      PCNFSD_PR_INIT(pr_init_args) = 2;
 
      pr_start_res
      PCNFSD_PR_START(pr_start_args) = 3;
   } = 1;
} = 150001;

