# Find out if this rpc service is accessible, return error text if not

sub check_rpc {
    local($target, $service) = @_;

    if (open(RPCINFO, "$RPCINFO -p $target 2>&1|")) {
	while (<RPCINFO>) {
	    last if (/$service/);
	}
	close(RPCINFO);
    }
 
    if ($? != 0) {
	return "cannot contact portmapper at $target";
    }
     
    if (! /$service/) {
	return "$target does not run $service";
    }
}
1;
