#
# miscellaneous perl functions that don't belong anywhere else
#

# strip leading directory and optional suffix information.
sub basename {
    local($path, $suffix) = @_;

    $path =~ s:.*/::;
    if ($suffix) {
	$path =~ s/$suffix$//;
    }
    return $path;
}

# print the output for the brain/optimizer
sub satan_print {

    print "$target|$service|$status|$severity|$trustee|$trusted|$service_output|$text\n";

}

# format the output for the brain/optimizer
sub satan_text {

    return "$target|$service|$status|$severity|$trustee|$trusted|$service_output|$text";

}

# breakup record into its constituent fields
sub satan_split {
    local ($line) = @_;

    ($target,$service,$status,$severity,$trustee,$trusted,$service_output,$text) = split(/\|/, $line);

}

1;
