# Schema for a 3.12 bindery.

# Every object has a mandatory back-links property.
obj FFFF * 
  OBJ_BACK_LINKS     02 44

# File server object representing this fileserver, i.e. the one
# which has the bindery.
obj 0400 *
  access 40
  NET_ADDRESS        01 40
  ACCT_LOCKOUT       00 33
  ?OPERATORS         02 31              
  ?ACCOUNT_SERVERS   02 31

# various objects have an identification string
obj 0100 *
obj 0200 *
obj 0700 *
  ?IDENTIFICATION    00 31

# users and user groups have a 'managers' attribute;
# in the user's case it is called a User Account Manager
obj 0100 * 
obj 0200 * 
  ?OBJ_SUPERVISORS   02 32

# print queue
obj 0300 *
  Q_USERS            02 31
  Q_OPERATORS        02 31
  Q_SERVERS          02 31
  Q_DIRECTORY        00 33

# print server
obj 0700 *
  ?PS_USERS          02 31
  ?PS_OPERATORS      02 31

# this group of properties relates to objects which 'log in'.
obj 0100 * 
obj 0500 *
obj 0700 * 
obj 5300 * 
  ?PASSWORD          00 44
  LOGIN_CONTROL      00 32
  ?ACCOUNT_BALANCE   00 32

# SUPERVISOR has various special properties
obj 0100 SUPERVISOR      
  MANAGERS           02 32      # Workgroup managers
  USER_DEFAULTS      00 31      # SYSCON special
  ?HOMEDIRPATH       00 31      # SYSCON special
  REGISTER           00 33      # no idea!!

# user
obj 0100 * 
  SECURITY_EQUALS    02 32
  GROUPS_I'M_IN      02 31
  ?MISC_LOGIN_INFO   00 22      # created and updated by user at login
  ?NODE_CONTROL      00 32
  ?HOME_DIR          00 21      # not Novell standard

# user group
obj 0200 * 
  GROUP_MEMBERS      02 31


# Following objects are installed by products.

obj 0802 ATPS_INFORMATION
  ignore

obj 290C *
obj 2096 SOFTRACK_ADMIN
  ignore
