#include "mtypes.h"

#define OCR1	0x20			/* 8259-1 Operation control register */
#define IMR1	0x21			/* 8259-1 Mask register */

#define OCR2	0xA0			/* 8259-2 Operation control register */
#define IMR2	0xA1			/* 8259-2 Mask register */

#define MAKE_MSW(x)     ((long)((long)(x)) << 16)
#define LSW(x)          ((unsigned int)(x))
#define MSW(x)          ((unsigned int)(((long)x)>>16))
#define MSB(x)          (unsigned char)((unsigned int)(x)>>8)
#define LSB(x)          ((unsigned char)(x))

#define ADDR_HIGH(x) ((unsigned int)((unsigned int)((x>>7L)&0x1fffL)))
#define ADDR_LOW(x)  ((unsigned int)((unsigned int)((x&0x7fL)<<9L)))

#define JOYSTICK_TIMER  (GUS_PORT+0x201)                /* 201 */
#define JOYSTICK_DATA   (GUS_PORT+0x201)                /* 201 */

#define GF1_MIDI_CTRL   (GUS_PORT+0x100)                /* 3X0 */
#define GF1_MIDI_DATA   (GUS_PORT+0x101)                /* 3X1 */

#define GF1_PAGE        (GUS_PORT+0x102)                /* 3X2 */
#define GF1_REG_SELECT  (GUS_PORT+0x103)                /* 3X3 */
#define GF1_VOICE_SELECT (GUS_PORT+0x102)               /* 3X3 */
#define GF1_DATA_LOW    (GUS_PORT+0x104)                /* 3X4 */
#define GF1_DATA_HI     (GUS_PORT+0x105)                /* 3X5 */
#define GF1_IRQ_STAT    (GUS_PORT+0x006)                /* 2X6 */
#define GF1_DRAM        (GUS_PORT+0x107)                /* 3X7 */

#define GF1_MIX_CTRL    (GUS_PORT+0x000)                /* 2X0 */
#define GF1_TIMER_CTRL  (GUS_PORT+0x008)                /* 2X8 */
#define GF1_TIMER_DATA  (GUS_PORT+0x009)                /* 2X9 */
#define GF1_IRQ_CTRL    (GUS_PORT+0x00B)                /* 2XB */

#define CLOCK_RATE              9878400L

#define ENABLE_LINE             0x01
#define ENABLE_DAC              0x02
#define ENABLE_MIC              0x04

#define CNTRL_8259              0x21
#define OCR_8259                0x20
#define EOI                     0x20
#define REARM3                  0x2F3
#define REARM5                  0x2F5

#define CNTRL_M_8259			0x21
#define CNTRL_M2_8259  			0xA1
#define OCR_2_8259              0xA0

#define DMA_CONTROL             0x41
#define SET_DMA_ADDRESS         0x42
#define SET_DRAM_LOW            0x43
#define SET_DRAM_HIGH           0x44

#define TIMER_CONTROL           0x45
#define TIMER1                  0x46
#define TIMER2                  0x47

#define SET_SAMPLE_RATE         0x48
#define SAMPLE_CONTROL          0x49

#define SET_JOYSTICK            0x4B
#define MASTER_RESET            0x4C

#define SET_CONTROL                     0x00
#define SET_FREQUENCY           0x01
#define SET_START_HIGH          0x02
#define SET_START_LOW           0x03
#define SET_END_HIGH            0x04
#define SET_END_LOW                     0x05
#define SET_VOLUME_RATE         0x06
#define SET_VOLUME_START        0x07
#define SET_VOLUME_END          0x08
#define SET_VOLUME                      0x09
#define SET_ACC_HIGH            0x0a
#define SET_ACC_LOW                     0x0b
#define SET_BALANCE                     0x0c
#define SET_VOLUME_CONTROL      0x0d
#define SET_VOICES                      0x0e

#define GET_CONTROL                     0x80
#define GET_FREQUENCY           0x81
#define GET_START_HIGH          0x82
#define GET_START_LOW           0x83
#define GET_END_HIGH            0x84
#define GET_END_LOW                     0x85
#define GET_VOLUME_RATE         0x86
#define GET_VOLUME_START        0x87
#define GET_VOLUME_END          0x88
#define GET_VOLUME                      0x89
#define GET_ACC_HIGH            0x8a
#define GET_ACC_LOW                     0x8b
#define GET_BALANCE                     0x8c
#define GET_VOLUME_CONTROL      0x8d
#define GET_VOICES                      0x8e
#define GET_IRQV                        0x8f

#define MIDI_RESET      0x03
#define MIDI_ENABLE_XMIT        0x20
#define MIDI_ENABLE_RCV         0x80

#define MIDI_RCV_FULL           0x01
#define MIDI_XMIT_EMPTY         0x02
#define MIDI_FRAME_ERR          0x10
#define MIDI_OVERRUN            0x20
#define MIDI_IRQ_PEND           0x80

#define JOY_POSITION            0x0f
#define JOY_BUTTONS                     0xf0

#define MIDI_TX_IRQ                     0x01            /* pending MIDI xmit IRQ */
#define MIDI_RX_IRQ                     0x02            /* pending MIDI recv IRQ */
#define GF1_TIMER1_IRQ          0x04            /* general purpose timer */
#define GF1_TIMER2_IRQ          0x08            /* general purpose timer */
#define WAVETABLE_IRQ           0x20            /* pending wavetable IRQ */
#define ENVELOPE_IRQ            0x40            /* pending volume envelope IRQ */
#define DMA_TC_IRQ                      0x80            /* pending dma tc IRQ */

#define ENABLE_LINE_IN          0x01            /* 0=enable */
#define ENABLE_OUTPUT           0x02            /* 0=enable */
#define ENABLE_MIC_IN           0x04            /* 1=enable */
#define ENABLE_GF1_IRQ          0x08            /* 1=enable */
#define GF122                           0x10            /* ?? */
#define ENABLE_MIDI_LOOP        0x20            /* 1=enable loop back */
#define SELECT_GF1_REG          0x40            /* 0=irq latches */
										/* 1=dma latches */
#define DMA_ENABLE                      0x01
#define DMA_READ                        0x02            /* 1=read,0=write */
#define DMA_WIDTH_16            0x04            /* 1=16 bit,0=8 bit (dma chan width)*/
#define DMA_RATE                        0x18            /* 00=fast, 11=slow */
#define DMA_IRQ_ENABLE          0x20            /* 1=enable */
#define DMA_IRQ_PENDING         0x40            /* read */
#define DMA_DATA_16                     0x40            /* write (data width) */
#define DMA_TWOS_COMP           0x80            /* 1=do twos comp */

#define DMA_R0          0x00            /* Fastest DMA xfer (~650khz) */
#define DMA_R1          0x08            /* fastest / 2 */
#define DMA_R2          0x10            /* fastest / 4 */
#define DMA_R3          0x18            /* Slowest DMA xfer (fastest / 8) */

#define ENABLE_ADC                      0x01
#define ADC_MODE                        0x02            /* 0=mono, 1=stereo */
#define ADC_DMA_WIDTH           0x04            /* 0=8 bit, 1=16 bit */
#define ADC_IRQ_ENABLE          0x20            /* 1=enable */
#define ADC_IRQ_PENDING         0x40            /* 1=irq pending */
#define ADC_TWOS_COMP           0x80            /* 1=do twos comp */

#define GF1_MASTER_RESET        0x01            /* 0=hold in reset */
#define GF1_OUTPUT_ENABLE       0x02            /* enable output */
#define GF1_MASTER_IRQ          0x04            /* master IRQ enable */

#define VOICE_STOPPED           0x01            /* voice has stopped */
#define STOP_VOICE                      0x02            /* stop voice */
#define VC_DATA_TYPE            0x04            /* 0=8 bit,1=16 bit */
#define VC_LOOP_ENABLE          0x08            /* 1=enable */
#define VC_BI_LOOP                      0x10            /* 1=bi directional looping */
#define VC_WAVE_IRQ                     0x20            /* 1=enable voice's wave irq */
#define VC_DIRECT                       0x40            /* 0=increasing,1=decreasing */
#define VC_IRQ_PENDING          0x80            /* 1=wavetable irq pending */

#define VL_RATE_MANTISSA                0x3f
#define VL_RATE_RANGE                   0xC0

#define VL_START_MANT                   0x0F
#define VL_START_EXP                    0xF0

#define VL_END_MANT                             0x0F
#define VL_END_EXP                              0xF0

#define VOLUME_STOPPED          0x01            /* volume has stopped */
#define STOP_VOLUME                     0x02            /* stop volume */
#define VC_ROLLOVER                     0x04            /* Roll PAST end & gen IRQ */
#define VL_LOOP_ENABLE          0x08            /* 1=enable */
#define VL_BI_LOOP                      0x10            /* 1=bi directional looping */
#define VL_WAVE_IRQ                     0x20            /* 1=enable voice's wave irq */
#define VL_DIRECT                       0x40            /* 0=increasing,1=decreasing */
#define VL_IRQ_PENDING          0x80            /* 1=wavetable irq pending */

#define VOICE_VOLUME_IRQ        0x40            /* individual voice irq bit */
#define VOICE_WAVE_IRQ          0x80            /* individual waveform irq bit */

#define UltraSelect(x) outportb(GF1_REG_SELECT,GUS_SELECT=x)
#define MAKE_MS_SWORD( x )       ((unsigned long)((unsigned long)(x)) << 16)

#define MIXER_ADDRESS 		(sb_port+0x4)
#define MIXER_DATA			(sb_port+0x5)
#define DSP_RESET			(sb_port+0x6)
#define DSP_READ_DATA		(sb_port+0xa)
#define DSP_WRITE_DATA		(sb_port+0xc)
#define DSP_WRITE_STATUS	(sb_port+0xc)
#define DSP_DATA_AVAIL		(sb_port+0xe)

