Release Notes for MPASM Version 1.50
March 21, 1997
  
------------------------------------------------------------    
WHATS NEW!!
------------------------------------------------------------    

New Device Support for 12C671, 12C672, 16C642, 16C662,
	16C66, 16C67, 16C76, 16C77, 17C752, 17C756, 24xx, 93xx

MPASM can now be used to create files for programming 
Microchip Serial EEPROM devices (1.40 and later).  


------------------------------------------------------------
Full Device Support List:
------------------------------------------------------------

	12C508 	12C509 	12C671*	12C672*	14000	16C52
	16C54	16CR54	16C54A	16CR54A	16C55	16C554
	16C556 	16C558	16C56	16C57	16CR57A	16CR57B
	16C58A	16CR58A	16C5X	16C61	16C62	16CR62
	16C62A	16C620	16C621	16C622	16C63	16C64
	16CR64	16C64A	16C642*	16C65	16C65A	16C66*
	16C662*	16C67*	16C71	16C710	16C711	16C715
	16C72	16C73	16C73A	16C74	16C74A	16C76*
	16C77*	16CR83	16C84	16CR84	16C923	16C924
	16CXX   16F83	16F84	17C42	17CR42	17C42A
	17C43	17CR43	17C44	17C752* 17C756*	17CXX
    EEPROM8	EEPROM16
	
	*-new product support

THESE PARTS MAY NOT ALL BE COMMERCIALLY AVAILABLE.

These can be chosen through the introductory screen, on the
command line, or in source file.  Three selections, 16C5X, 
16CXX, and 17CXX are also supported as generic family 
indicators.  

The selections EEPROM8 and EEPROM16 are provided for generic 
memory product support.  Read below for a description of how
to use MPASM to generate files for programming Microchip Serial 
EEPROM devices.

The standard header files have been updated to reflect these
devices.  No header files are provided for generic memory product 
support.



------------------------------------------------------------
Important Notes:
------------------------------------------------------------

EEPROM:
Two "processor" selections are provided to generate byte data - 
EEPROM8 and EEPROM16.  Both generate data in terms of bytes, 
but EEPROM8 considers a "word" to be 8 bits wide, while 
EEPROM16 considers a "word" to be 16 bits wide.  The "program
counter" is always incremented in terms of bytes.

The default size for memory products is 128 bytes.  This can
be overridden by using the LIST M=<max address> directive.  
Note that <max address> is always evaluated as a decimal number.
The header file MEMORY.INC is provided to define the maximum
address for available memory devices.  The format of the 
defined symbols is _<device>; for example, to set the maximum
memory size for a 24LCS21, use the directive LIST M=_24LCS21.

The following data generation directives are supported for 
memory products:

	DW	FILL	ORG

The behavior of other data generation directives is not 
guaranteed.  All other directives are unchanged.

An example of generating a file for programming a memory device
is as follows:

	;*************************************************
	; Generate data for a 8-bit wide memory device.

	        LIST    P=EEPROM8, R=DECIMAL
	        INCLUDE "MEMORY.INC"
	        LIST    M=_24LCS21

	#DEFINE MAX_VALUE       255

	        ORG     0

	;-------------------------------------------------
	; Create a packed-byte, null terminated string.

	        DW      "Hello World", 0

	;-------------------------------------------------
	; Create data representing a line.  The X position
	; is implied from the position of the data in the
	; device.  The Y values are stored in the device.

	; First, define an equation for the line.

	#DEFINE Line( X )       Slope * X + Y_Intercept

	; Now define the values needed for the equation.

	Slope                   EQU     10
	Y_Intercept             EQU     5

	; Declare and initialize the X and Y values.

	        VARIABLE        X = 0, Y = Line( X )

	; Generate values until the maximum Y value is 
	; reached or the device is filled up.

	        WHILE (Y <= MAX_VALUE) && ($ <= _24LCS21)
	           DW   Y
	X = X + 1
	Y = Line( X )
	        ENDW

	;-------------------------------------------------
	; Perform some checking based on the line data 
	; generated above.

	; If the device filled up before the end of the
	; line was reached, generate an error.  Otherwise,
	; if the device is almost out of room, generate a
	; message.

	        IF (Y < MAX_VALUE)
	           ERROR        "Device is full."
	        ELSE
	           IF (($+10) > _24LCS21)
	              MESSG     "Device is nearly full."
	           ENDIF
	        ENDIF

	;-------------------------------------------------
	; Fill the rest of the device with zeroes.

	        FILL    0, _24LCS21 - $ + 1

	        END

CBLOCK:

The CBLOCK syntax was expanded to allow labels to be given
a "size" (1.40 and later).  The new syntax is as follows:

	CBLOCK [<first value>]
	   <label>[:<increment>][, <label>[:<increment>]]
	ENDC

where <label> is a valid symbol name and <first value> and 
<increment> are integer expressions.  

If <increment> is specified, the next label is assigned the value 
of <increment> 
plus the value of the previous label.  Note that <increment> 
can be zero to create more than one <label> with the same value.
If <first increment> is not specified, <label> is given the value 
of the last CBLOCK <label> assigned plus its <increment>.  If 
<first increment> is not specified for the first CBLOCK, the
first <label> is assigned a value of zero.

NOTE: CBLOCK is the recommended method of allocating RAM 
locations.  When labels are generated using the program counter,
they are marked as ROM address labels.  To effectively use labels 
as RAM locations in MPLAB and MPSIM, they must be defined 
using CBLOCK, EQU, or SET.

Examples of using the new syntax is as follows:

	; Start generic RAM allocation at location H'30'.  Use an empty
	; CBLOCK so that subsequent CBLOCKs can be moved around without
	; using a starting value.

		CBLOCK H'30'
		ENDC

	; Allocate space for a queue of size 20, with head and 
	; tail pointers.

	#define QUEUE_SIZE D'20'

		CBLOCK
		   Queue : QUEUE_SIZE
		   QueueHead, QueueTail
		ENDC

	; Now define two double precision (two byte) variables.

		CBLOCK
		   Double1 : 2, Double2 : 2
		ENDC

	; Finally, define a third double precision variable, also
	; providing labels to reference each byte separately.

		CBLOCK
		   TwoByteVar:0, HighByte, LowByte
		ENDC



TYPE CHECKING:

Minimal type checking was added (1.40 and later).  If a program tries to 
use the value of a symbol that has no meaningful value (for 
example, using a macro name as a CALL destination), a warning 
is generated.  This is shown in the following list file excerpt:

	                    00060 MyMacro macro
	                    00061         NOP
	                    00062         endm
	                    00063 
	Warning[225]: Label being used out of context. (MyMacro)
	0012 2001           00064         CALL    MyMacro      
	Warning[225]: Label being used out of context. (MyMacro)
	0013 0001           00065         data    MyMacro      

CLRW COMMAND:

The CLRW encoding was changed on all 14-bit core devices 
from 0x0100 to 0x0103 (1.40 and later).  This will not affect
the expected operation of the instruction, but it will change
the value for the instruction in the hex file and therefore
the checksum.

WARNING MESSAGE:
The text for Message #302 was modified to explain more
clearly that bank indication bits are stripped when assembling
instructions that access file registers.  The appropriate
bank must be selected by the appropriate bank selection bits.  
For example, 14-bit core devices contain the lower seven bits 
of the file register address in the opcode, with two bank 
selection bits in the STATUS register.  The message was 
changed from:
        Argument out of range.  Least significant bits used.
to:
        Register in operand not in bank 0.  Ensure that bank 
        bits are correct.

END DIRECTIVE:

Take care to not use the END directive in a macro.  If the END 
directive is encountered in a macro, it can cause the assembler
to loop indefinitely.  Macros should be terminted with the
ENDM directive.  

------------------------------------------------------------    
Instructions on Using MPASM    
------------------------------------------------------------    
    
Create your source code with any text editor.  The file 
should contain ASCII text only.  Assemble your code with the 
command line:
	
	MPASM <file>[.asm]    
    
Correct any syntax problems, referring to the MPASM User's 
Guide for syntax help.  MPASM assembles with INHX8M as the 
default hex output, and generates a listing file, error file,
and .COD file.
    
MPASM currently runs in DOS real mode.  If you have "out of 
memory" problems, try using the DOS protected mode (DPMI) 
version.  To use this assembler, you must have the files 
RTM.EXE and DPMI16BI.OVL (distributed with this release) 
available in your path or in the current directory.  You must 
also have EMM386 or another memory manager running or run the 
assembler from a Windows DOS box.  To invoke this assembler, 
use the command:

	MPASM_DP <file>[.asm]    

A version of MPASM is also available for Windows.  To invoke 
this assembler, execute:

	MPASMWIN.EXE

from within Windows.  You will then be given a Windows
interface window.  Help on using the interface is provided
on-line.  MPASMWIN can also be invoked with parameters or 
through drag-and-drop.  In these cases, the interface 
screen is not displayed and assembly begins immediately.


------------------------------------------------------------    
How To Contact Microchip    

Microchip provides two methods of on-line support.  These are the Microchip BBS 
and the Microchip World Wide Web (WWW) site.

Use  Microchip's Bulletin Board Service (BBS) to get current information and 
help about Microchip products.  Microchip provides the BBS communication channel 
for you to use in extending your technical staff with microcontroller and memory 
experts.

To provide you with the most responsive service possible, the Microchip systems 
team monitors the BBS, posts the latest component data and software tool 
updates, provides technical help and embedded systems insights, and discusses 
how  Microchip products provide project solutions.  

The web site, like the BBS, is used by Microchip as a means to make files and 
information easily available to customers.  To view the site, the user must have 
access to the Internet and a web browser, such as Netscape Navigator or Microsoft 
Explorer.  Files are also available for FTP download from our FTP site.

Connecting to the Microchip Internet Web Site==============================

The Microchip web site is available by using your favorite Internet browser to 
attach to:

		www.microchip.com or www.microchip2.com

The file transfer site is available by using an FTP service to connect to:

		ftp.futureone.com/pub/microchip

The web site and file transfer site provide a variety of services.  Users may 
download files for the latest Development Tools, Datasheets, Application Notes, 
User's Guides, Articles and Sample Programs.

A variety of Microchip specific business information is also available, 
including listings of Microchip sales offices, distributors and factory 
representatives.  Other data available for consideration is:

		Latest Microchip Press Releases
		Technical Support Section with Frequently Asked Questions Design Tips
		Device Errata
		Job Postings
		Microchip Consultant Program Member Listing
		Links to other useful web sites related to Microchip Products

You may also e-mail technical support questions on any of our products to: 
webmaster@microchip.com.


Connecting to the Microchip BBS======================================

Connect worldwide to the Microchip BBS using either the Internet or the 
CompuServe communications network.

Internet:

You can telnet or ftp to the Microchip BBS at the address:

		mchipbbs.microchip.com.

CompuServe Communications Network:

When using the BBS via the CompuServe Network, in most cases, a local call is 
your only expense.  The Microchip BBS connection does not use CompuServe 
membership services, therefore you do not need CompuServe membership to join 
Microchip's BBS.  There is no charge for connecting to the Microchip BBS.

The procedure to connect will vary slightly from country to country.  Please 
check with your local CompuServe agent for details if you have a problem.  
CompuServe service allows multiple users various baud rates depending on the 
local point of access.

The following connect procedure applies in most locations.
1.	Set your modem to 8-bit, No parity, and One stop (8N1).
	This is not the normal CompuServe setting which is 7E1.
2.	Dial your local CompuServe access number.
3.	Depress the <Enter> key and a garbage string will appear because 
	CompuServe is expecting a 7E1 setting.
4.	Type +, depress the <Enter> key and "Host Name:" will appear.
5.	Type MCHIPBBS, depress the <Enter> key and you will be connected to the 
	Microchip BBS.

In the United States, to find the CompuServe phone number closest to you, set your 
modem to 7E1 and dial (800) 848-4480 for 300-2400 baud or (800) 331-7166 for 
9600-14400 baud connection. After the system responds with "Host Name:", type 
NETWORK, depress the <Enter> key and follow CompuServe's directions.
For voice information (or calling from overseas), you may call (614) 723-1550 
for your local CompuServe number.

Microchip regularly uses the Microchip BBS to distribute technical information, 
application notes, source code, errata sheets, bug reports, and interim patches 
for Microchip systems software products.  For each SIG, a moderator monitors, 
scans, and approves or disapproves files submitted to the SIG. No executable 
files are accepted from the user community in general to limit the spread of 
computer viruses.


Systems Information and Upgrade Hot Line===============================

The Systems Information and Upgrade Line provides system users a listing 
of the latest versions of all of Microchip's development systems software 
products. Plus, this line provides information on how customers can receive any 
currently available upgrade kits. The Hot Line Numbers are: 

		1-800-755-2345 for U.S. and most of Canada
		1-602-786-7302  for the rest of the world

TECHNICAL SUPPORT 

Technical support questions should first be directed to your distributor and representative, local sales office, Field Application Engineer (FAE) or Corporate Applications Engineer (CAE). 

REGIONAL TECHNICAL SUPPORT
AMERICAS
Atlanta
Tel: 770-640-0034  
Fax: 770-640-0307

Boston
Tel: 508-480-9990  
Fax: 508-480-8575

Chicago
Tel: 708-285-0071 
Fax: 708-285-0075

Dallas
Tel: 972-991-7177  
Fax: 972-991-8588

Dayton
Tel: 937-291-1654  
Fax: 937-291-9175

Los Angeles
Tel: 714-263-1888  
Fax: 714-263-1338

New York
Tel: 516-273-5305  
Fax: 516-273-5335

San Jose
Tel: 408-436-7950  
Fax: 408-436-7955

Toronto
Tel: 905-405-6279  
Fax:  905-405-6253


ASIA/PACIFIC
Hong Kong
Tel: 852-2-401-1200  
Fax: 852-2-401-3431

India
Tel: 91-80-299-4036 
Fax: 91-80-559-9840

Korea
Tel: 82-2-554-7200  
Fax: 82-2-558-5934

Shanghai
Tel: 86-21-6275-5700  
Fax: 86 21-6275-5060  

Singapore
Tel:  65-334-8870  
Fax: 65-334-8850

Taiwan, R.O.C
Tel: 886 2-717-7175  
Fax: 886-2-545-0139

EUROPE
United Kingdom
Tel: 44-1628-851077  
Fax: 44-1628-850259

France
Tel: 33-1-69-53-63-20  
Fax: 33-1-69-30-90-79

Germany
Tel: 49-89-627-144 0  
Fax: 49-89-627-144-44

Italy
Tel: 39-39-6899939  
Fax: 39-39-6899883

JAPAN
Tel: 81-4-5471- 6166  
Fax: 81-4-5471-6122

TECHNICAL SUPPORT HOTLINE:
US & Canada: (800) 755-2345
All other areas: (602) 786-7627

Microchip Technology Inc.
Corporate Offices:
(602) 786-7200
-----------------------------------------------------------------------------------------------------------
------------------------------------------------------------
Blank SSR (System Service Request) Form
------------------------------------------------------------

If you encounter any problem or wish to
see a new feature, please contact Microchip (see the
second section of this document on how to contact
Microchip).


Blank System Service Request Form

Microchip
Product:    ______________________________________________

Description:______________________________________________

Date:       ______________________________________________

SVR:        ______________________________________________

Reported By:______________________________________________

Detailed
Description:______________________________________________

            ______________________________________________

            ______________________________________________

            ______________________________________________

            ______________________________________________

              
Microchip
Product:    ______________________________________________

Description:______________________________________________ 

Date:       ______________________________________________

SVR:        ______________________________________________

Reported By:______________________________________________ 

Detailed
Description:______________________________________________

            ______________________________________________

            ______________________________________________

            ______________________________________________

            ______________________________________________

Microchip Technology System Service Request
Fax to (602) 786-7578


