%{
/*
   yylex.l: lex version of the lexical analyzer for watcher.

   Kenneth Ingham

   Copyright (C) 1989 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

extern int lexverbose;
extern int control_line;
%}

%%

"."		return '.';
","		return ',';
";"		return ';';
":"		return ':';
"%"		return '%';
"-"		return '-';
"+"		return '+';
"{"		return '{';
"}"		return '}';

\([^)]*\)	{	/* pipeline */
			/* start at 1 due to ( */
			yylval.str = strnsave(&yytext[1], yyleng-2);
			yylval.str[yyleng-2] = '\0';
			if (lexverbose)
				printf("pipeline: '%s'\n", yylval.str);
			return PIPELINE;
		}

[0-9]*\.[0-9]+	{	/* float */
			/*
			   note a float cannot end in a . since we also
			   end entries with '.' and we couldn't tell
			   them apart (unless we used lookahead)
			*/

			yylval.real = (float) atof(yytext);
			if (lexverbose)
				printf("float: '%f'\n", yylval.real);
			return FLOAT;
		}

[0-9]+		{	/* integer */

			yylval.integer = atoi(yytext);
			if (lexverbose)
				printf("integer: '%d'\n", yylval.integer);
			return INTEGER;
		}

('[^\']*')|(\"[^\"]*\")	{	/* string in 's or "s */
			/* copy, *except* for 's */
			yylval.str = strnsave(&yytext[1], yyleng-2);
			yylval.str[yyleng-2] = '\0';

			if (lexverbose)
				printf("string in %cs: '%s'\n", yytext[0],
				       yylval.str);

			if (yytext[0] == '"')
				return QUOTED_STRING;
			else /* string is in 's */
				return STRING;
		}

[a-zA-Z_][a-zA-Z_0-9]*	{/* string */
			yylval.str = strsave(yytext);

			if (lexverbose)
				printf("string: '%s'\n", yytext);

			return STRING;
		}

[ \t]+		; /* white space - ignored */

\n		{ control_line++; } /* newline - ignored except to note it */

\#[^\n]*	; /* comment - ignored */

%%

/*
   yywrap tells lex whether to stop at end of file or not.  It is
   assummed by lex that if yywrap returns 0 then lex can continue
   looking for tokens.  In our case, EOF means we're done with the
   control file.
*/
yywrap() {return 1;}
