/*
   line_to_vec: take a string and separate it into a vector of strings,
	splitting it at characters which are supplied in 'splits'.
	Ignore any 'splits' at the beginning.  Multiple 'splits' are
	condensed into one.  Splits are discarded.

   Assumptions:
	line is null terminated.  
	no single word is longer than MAX_STR.

   Arguments:
	line: line to split.
	vec: split line.
	splits: array of characters on which to split.  Null terminated.

   Local variables:
	name: current entry in the vector we are building.
	word: pointer into name.

   Returns:
	The number of vectors created.
	The argument vec is left with a NULL pointer after the last word.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

line_to_vec(line, vec, splits)
char *line, *vec[], *splits;
{
	register int i, v, j;
	int n;
	char word[MAX_STR];

	if (line == NULL || line[0] == '\0')
		return 0;
	
	/* skip any splits in the beginning */
	for (i=0; line[i] && index(splits, line[i]) != 0; i++)
		;
	
	j = 0;
	v = 0;
	n = 0;
	while (line[i]) {
		if (index(splits, line[i]) != 0) { /* found the end of a word */
			word[j] = '\0';
			vec[v] = strsave(word);
			j = 0;
			v++;
			n++;
			i++;
			for ( ; line[i] && index(splits, line[i]) != 0; i++)
				;
		}
		else
			word[j++] = line[i++];
	}

	/* deal with the last word if the line didn't end in  a "split".  */
	if (index(splits, line[i]) != 0) {
		word[j] = '\0';
		vec[v] = strsave(word);
		n++;
	}

	return n;
}
