/*
   yylex for watcher: this is a simple routine looking for numbers,
   special characters and strings.  The special chars are stored in
   'words' and represent tokens by themselves.   In y.tab.h are the
   values to return for the various tokens which are not listed in
   'words'.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

char words[] = "\".,*|;:%@$-{}";

yylex()
{
	int c, i;
	static char str[MAX_STR];
	int real;

	while (isspace(c = getchar()))
		;

	if (c == EOF)
		return EOF;

	if (c == '(') { /* aha, pipeline */
		c = getchar();
		for (i=0; c != EOF && c != ')'; i++) {
			str[i] = c;
			c = getchar();
		}
		str[i] = '\0';
		if (c == EOF) {
			fprintf(stderr, "Missing ')' to end pipeline.\n");
			return EOF;
		}
		yylval.str = strsave(str);
		return PIPELINE;
	}

	if (c == '#') { /* comment to end of line */
		while (c != '\n' && c != EOF)
			c = getchar();
		if (c == EOF)
			return EOF;
		return yylex();
	}

	if (index(words, c) != 0)
		return c;

	if (c == '+' || c == '-' || isdigit(c)) { /* a number */
		real = False;
		i = 0;
		str[i++] = c;
		do {
			str[i++] = getchar();
			if (str[i-1] == '.') 
				real = True;
		} while (isdigit(str[i-1]) || str[i-1] == '.');
		(void) ungetchar(str[i-1]);
		str[i-1] = '\0';
		if (real) {
			yylval.real = (float) atof(str);
			return FLOAT;
		}
		else {
			yylval.integer = atoi(str);
			return INTEGER;
		}
	}

	if (c == '\'') { /* literal string */
		c = getchar();
		for (i=0; c != EOF && c != '\''; i++) {
			str[i] = c;
			c = getchar();
		}
		str[i] = '\0';
		yylval.str = strsave(str);
		return STRING;
	}

	/* nothing else matched.  Must be plain string (whitespace sep) */
	for (i=1, str[0]=c; c != EOF && !isspace(c) && !index(words,c); i++) {
		c = getchar();
		str[i] = c;
	}
	(void) ungetchar(c);
	str[i-1] = '\0';
	yylval.str = strsave(str);
	return STRING;
}
