/*
   save_key: save the key for this line in the history file so that
   we can use it next run.

   Assume that the keyword file is opened and that the pipeline has
   already been placed in the file.  We place the data in the file in
   the following format:

   pipeline
   \tkey_value
   \t\tname value
    .
    .
    .

   Side effect: return the actual key value for other parts of the
   program to use.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

save_key(cmd, line, key_val, hf)
struct cmd_st *cmd;
char *line, *key_val;
FILE *hf;
{
	extern int vflag;

	if (cmd->key == NULL) { /* no key; no reason to save. */
		if (vflag) 
			printf("%s has no key field.\n",cmd->pipeline);
		return;
	}

	switch (cmd->out_fmt->type) {
		case RELATIVE:
			(void) get_rel_field(line,
				cmd->key->out_fmt.rel_fmt->field,
				key_val);
			break;
		case COLUMN:
			(void) get_col_field(line,
				cmd->key->out_fmt.col_fmt->start,
				cmd->key->out_fmt.col_fmt->end, key_val);
			break;
	}
			
	if (!key_val[0]) {
		if (vflag)
			printf("the key field for %s is empty\n",cmd->pipeline);
		return;
	}
	fprintf(hf, "\t%s\n",key_val);
}
