/*
   pp: pretty print the command structure.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

pp(clist)
struct cmd_st *clist;
{
	extern char *histfilename;
	extern char *controlname;
	extern char *myname;

	printf("%s %s\n", myname, VERSION);
	printf("History file name: %s\n", histfilename);
	printf("Control file name: %s\n", controlname);
	printf("\n\n");

	while (clist != NULL) {
		printf("( %s )", clist->pipeline);
		if (clist->alias[0])
			printf(" { '%s' }\n", clist->alias);
		else
			printf("\n");
		pp_out(clist->out_fmt);
		printf(" :\n");
		pp_change(clist->change_fmt);
		clist = clist->next;
	}
}
