/*
   open_hf: open the history file for reading, taking care of the errors
   that can occur.

   Note that a missing history file is not an error.  We just don't do
   anything that uses previous values.

   Copyright (C) the University of New Mexico
*/

#include "defs.h"
#include <errno.h>

FILE *
open_hf()
{
	extern int vflag;
	extern char *histfilename;
	extern int errno;
	extern char *sys_errlist[];
	extern struct old_cmd_st *chead;

	FILE *hf;

	if (vflag)
		printf("Using %s for historyfile\n", histfilename);

	hf = fopen(histfilename, "r");
	if (hf == NULL) {
		if (errno == ENOENT) {
			if (vflag)
				printf("This is a first run.\n");
		}
		else { /* some other error */
			fprintf(stderr, "Warning: ");
			fprintf(stderr, "unable to open history file.\n");
			fprintf(stderr, "%s: %s\n", histfilename,
				sys_errlist[errno]);
			fprintf(stderr, "Ignoring history file.\n\n");
		}
		chead = NULL;
		return NULL;
	}

	return hf;
}
