/*
   init_sigs: take care of setting up the signal handling.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

init_sigs()
{
	extern int vflag;
	int exit(), baderr();

	(void) signal(SIGINT,  exit);
	(void) signal(SIGHUP,  exit);

	/* 
	   if verbose is on, let's leave a core dump behind for
	   debugging
	*/
	if (!vflag) {
		(void) signal(SIGQUIT, baderr);
		(void) signal(SIGSEGV, baderr);
		(void) signal(SIGBUS,  baderr);
		(void) signal(SIGFPE,  baderr);
		(void) signal(SIGILL,  baderr);
	}
}
