/*
  Structure definitions, included files needed and useful constants for
  Watcher.

  Kenneth Ingham

  Copyright (C) 1987 The University of New Mexico
*/

#include <stdio.h>
#include <ctype.h>

#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif

#include <signal.h>

#define False		0
#define True		1
#define SUCCESS		0
#define FAIL		1
#define EMPTY		0
#define MAX_STR		256
#define DEF_CONTROL	"watcherfile"
#define DEF_CONTROL2	"Watcherfile"
#define DEF_HISTFILE	"watcher.history"
#define VERSION		"Version 1.3"
#define MAX_NAME	16
#define MAX_VEC		100
#define STACKSIZE	256

#define ANY		2
#define PERCENT		3
#define ABSOLUTE	4
#define MAX_MIN		5
#define RELATIVE	6
#define COLUMN		7
#define KEY		9

/* 
   Below lie the structure definitions for all of the linked lists used
   in watcher.
*/

/* we start easy.  a number is either an int or a float... */
struct number {
	int type;
	union {
		float real;
		int integer;
	} value;
};

/*
   what a column output format entry looks like:
*/
struct col_out_st {
	char *name;			/* name of output field */
	int start;			/* where it starts... */
	int end;			/* ... and ends */
	int type;			/* what type of data to find there */
	struct col_out_st *next;	/* and the next in the list is... */
};

/* 
   and a relative output format...
*/
struct rel_out_st {
	char *name;			/* name of output field */
	int field;			/* Which field to look in for it */
	int type;			/* what type of data to find there */
	struct rel_out_st *next;	/* and the next in the list */
};

/*
   types of change formats; all joined in a union later.
*/
struct max_min_st {
	double max;			/* max allowable value... */
	double min;			/* ...and the min */
};

union fmt_u {
	float percent;			/* percent change */
	double abs_amount;		/* absolute change */
	struct max_min_st max_min;	/* max and min */
	char **str_value;		/* array of values for what the
					   string should be; terminated
					   by a NULL pointer */
};

struct chg_fmt_st {
	int type;
	union fmt_u fmt;
};

/*
   the actual structure describing how things are allowed to change.
*/
struct change_fmt_st {
	char *name;			/* name of the field this pertains to */
	struct chg_fmt_st fmt;		/* the format, depending on type */
	struct change_fmt_st *next;	/* and of course the next in the list */
};

/*
   for the various types of output formats:
*/
union out_fmt_u {
	struct rel_out_st *rel_fmt;	/* a relative output format (fields) */
	struct col_out_st *col_fmt;	/* or one that uses columns */
};

struct out_fmt_st {
	int type;
	union out_fmt_u out_fmt;
};

/* 
   what we are all about: the command structure.  Here we bring it all
   together and have something to work with (luckily the subroutines are
   also set up in a similar heirarchy and we can pass various parts of
   the linked lists to them and they don't care about the "upper" parts.
*/
struct cmd_st {
	char *pipeline;			/* the pipeline to execute */
	char *alias;			/* a name to use when refering to it */
	struct out_fmt_st *out_fmt;	/* the output format */
	struct out_fmt_st *key;		/* what to key on for btwn run cmps */
	struct change_fmt_st *change_fmt;/*the things to watch for changes */
	struct cmd_st *next;		/* and of course the next in the list */
};

/*
   now we get into the structures for the history linked list...
*/

/*
   a way of storing any data type:
*/
union everything_u {
	char *string, character;
	int integer;
	float real;
};

struct everything {
	int type;
	union everything_u data;
};

/*
   which is used here where we hold the value for a specified key value
   from the previous output.
*/
struct val_st {
	char *name;		/* output field name */
	struct everything val;	/* ... the data (wow!) */
	struct val_st *next;	/* and where would we be without a next one? */
};

/* 
   for each line in the output of a command, we grab the key and store
   all of the values obtained from the line.  Here is how it is done.
*/
struct key_st {
	char *key_value;	/* value for the key (could you guess?) */
	struct val_st *vals;	/* the various interesting parts of the line */
	struct key_st *next;	/* and of course the next one */
};

/*
   finally we come to the reaon for all of the above structures.  This is
   how previous commands are stored once they have been read in from the
   history file.
*/
struct old_cmd_st {
	char *pipeline;			/* the pipeline executed */
	struct key_st *keys;		/* the keys and their useful parts */
	struct old_cmd_st *next;	/* and the next pipeline... */
};

char *xmalloc(), *realloc(), *strsave(), *strnsave();
char *get_rel_field(), *get_col_field();
double atof();
struct old_cmd_st *find_cmd_prev();

/* Berkeley vs System V differences... */
#ifdef SYSV
#define index	strchr
#define rindex	strrchr
#endif

#define allocate(size)	((size *)xmalloc(sizeof(size)))
