/*
   to_double: convert a struct anything to a double, no matter what type
   it is currently.

   I'm not completely happy with this; should make better use of
   the info we are provided about the type of any instead of calling
   this routine.

   Kenneth Ingham
*/

#include "defs.h"
#include "y.tab.h"

double
to_double(any)
struct everything *any;
{
	switch (any->type) {
		case STRING:
			return (double)atof(any->data.string);
		case FLOAT:
			return any->data.real;
		case INTEGER:
			return (double)any->data.integer;
		default: 
			fprintf(stderr, "Unable to convert type %d",any->type);
			fprintf(stderr, " to double.\n");
			exit(1);
	}
	/*NOTREACHED*/
}
