/*
   pct_check: verify that the value has not changed more than the
   allowed percentage.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"

pct_check(current, prev_val, percent, cmd, name, line)
char *current;
double percent;
struct everything *prev_val;
char *cmd, *name, *line;
{
	extern int line_ok, cmd_ok;
	double change, previous, value;
	double to_double();

	previous = to_double(prev_val);
	value = atof(current);

	if (value == 0) /* avoid divide by 0 */
		return;

	change = (value - previous) / value;
	if (change > percent) {
		if (line_ok) {
			printf("%s had ", cmd);
			printf("%s change by more than %.2f percent.\n",
				name, percent*100);
			printf("%s\n",line);
		}
		else {
			printf("Also, it had ");
			printf("%s change by more than %.2f percent.\n",
				name, percent*100);
		}
		printf("Previous value %.2f; ", previous);
		printf("current value %.2f.\n", value);
		line_ok = False;
	}
}
