/*
   check_rel_item: find the part of the line corresponding to check.
   Also find the previous results corresponding to the key for this line
   (if any).  Pass all of this to check_item

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"

check_rel_item(prev_res, rel_fmt, key_val, line, cf, cmd_name, hf)
struct old_cmd_st *prev_res;
struct rel_out_st *rel_fmt;
char *key_val, *line;
struct change_fmt_st *cf;
char *cmd_name;
FILE *hf;
{
	struct everything *prev_value;
	char tchar();
	char value[MAX_STR];

	find_prev_value(prev_res, rel_fmt->name, key_val, &prev_value);
	if (get_rel_field(line, rel_fmt->field, value) != NULL)
		check_item(cf, value, cmd_name, line, prev_value);
	
	/*
	   save the value in the history file for future comparisons.
	*/
	if (*key_val)
		fprintf(hf, "\t\t%s %c %s\n", cf->name, tchar(rel_fmt->type),
			value);
}
