/*
   checkline: check the input line just read in against what we expect
   to find and report any problems.  Actually, most of the work is done
   by check_item.  We just identify what needs to be checked.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

checkline(cmd, line, prev_res, hf)
struct cmd_st *cmd;
char *line;
struct old_cmd_st *prev_res;
FILE *hf;
{
	extern int line_ok;
	struct change_fmt_st *cf;
	struct out_fmt_st of;
	char key_val[MAX_STR];
	char *cmd_name;

	cmd_name = ((cmd->alias != NULL) ? cmd->alias : cmd->pipeline);
		
	save_key(cmd, line, key_val, hf); /* side effect: return key value */

	/* for each change format item */
	line_ok = True;
	for (cf=cmd->change_fmt; cf; cf=cf->next) {
		/* find the output format entry for this item */
		if (!find_of(cf->name, cmd->out_fmt, &of)) {
			fprintf(stderr, "Warning: %s appears in change list ",
				cf->name);
			fprintf(stderr, "but not in output format for %s\n",
				cmd_name);
			continue;
		}

		/*
		   check the item, depending on which type of output
		   format we have.
		*/
		switch (cmd->out_fmt->type) {
			case RELATIVE:
				check_rel_item(prev_res, of.out_fmt.rel_fmt,
					key_val, line, cf, cmd_name, hf);
				break;
			case COLUMN:
				check_col_item(prev_res, of.out_fmt.col_fmt,
					key_val, line, cf, cmd_name, hf);
				break;
		}
	}
	if (!line_ok)
		printf("---------\n");
}
