/*
   build_cmd: build one command structure from the pieces provided.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

struct cmd_st *
build_cmd(pipeline, alias, out_fmt, change_fmt)
char *alias, *pipeline;
struct out_fmt_st *out_fmt;
struct change_fmt_st *change_fmt;
{
	extern struct out_fmt_st *key;
	struct cmd_st *p;

	p = allocate(struct cmd_st);

	p->pipeline = pipeline;
	p->alias = alias;
	p->change_fmt = change_fmt;
	p->next = NULL;
	p->out_fmt = out_fmt;
	p->key = key;
	key = NULL;

	return p;
}
