/*
   find_prev_value: given an old command structure, look through the
   prior output for the output for name of type type.  Return it in the
   struct pointed to by value or NULL if not found.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

find_prev_value(cmd, field_name, key_val, value)
struct old_cmd_st *cmd;
char *field_name, *key_val;
struct everything **value;
{
	struct val_st *vp;
	struct key_st *kp;

	*value = NULL;

	/* is there anything to look for a value for? */
	if (cmd == NULL || cmd->keys == NULL)
		return;

	/* find the correct key */
	kp = cmd->keys;
	while (kp != NULL && strcmp(kp->key_value, key_val) != 0)
			kp = kp->next;

	/* was a keyword and value found? */
	if (kp == NULL || kp->vals == NULL)
		return;

	/* find the value under the keyword */
	vp = kp->vals;
	while (vp != NULL && strcmp(vp->name, field_name) != 0)
		vp = vp->next;

	*value = &(vp->val);
}
